/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.converters;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.connect.converters.NumberConverterConfig;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaAndValue;
import org.apache.kafka.connect.errors.DataException;
import org.apache.kafka.connect.storage.Converter;
import org.apache.kafka.connect.storage.ConverterType;
import org.apache.kafka.connect.storage.HeaderConverter;

abstract class NumberConverter<T extends Number>
implements Converter,
HeaderConverter {
    private final Serializer<T> serializer;
    private final Deserializer<T> deserializer;
    private final String typeName;
    private final Schema schema;

    protected NumberConverter(String typeName, Schema schema, Serializer<T> serializer, Deserializer<T> deserializer) {
        this.typeName = typeName;
        this.schema = schema;
        this.serializer = serializer;
        this.deserializer = deserializer;
        assert (this.serializer != null);
        assert (this.deserializer != null);
        assert (this.typeName != null);
        assert (this.schema != null);
    }

    public ConfigDef config() {
        return NumberConverterConfig.configDef();
    }

    public void configure(Map<String, ?> configs) {
        NumberConverterConfig conf = new NumberConverterConfig(configs);
        boolean isKey = conf.type() == ConverterType.KEY;
        this.serializer.configure(configs, isKey);
        this.deserializer.configure(configs, isKey);
    }

    public void configure(Map<String, ?> configs, boolean isKey) {
        HashMap conf = new HashMap(configs);
        conf.put("converter.type", isKey ? ConverterType.KEY.getName() : ConverterType.VALUE.getName());
        this.configure(conf);
    }

    protected T cast(Object value) {
        return (T)((Number)value);
    }

    public byte[] fromConnectData(String topic, Schema schema, Object value) {
        try {
            return this.serializer.serialize(topic, value == null ? null : this.cast(value));
        }
        catch (ClassCastException e) {
            throw new DataException("Failed to serialize to " + this.typeName + " (was " + value.getClass() + "): ", (Throwable)e);
        }
        catch (SerializationException e) {
            throw new DataException("Failed to serialize to " + this.typeName + ": ", (Throwable)e);
        }
    }

    public SchemaAndValue toConnectData(String topic, byte[] value) {
        try {
            return new SchemaAndValue(this.schema, this.deserializer.deserialize(topic, value));
        }
        catch (SerializationException e) {
            throw new DataException("Failed to deserialize " + this.typeName + ": ", (Throwable)e);
        }
    }

    public byte[] fromConnectHeader(String topic, String headerKey, Schema schema, Object value) {
        return this.fromConnectData(topic, schema, value);
    }

    public SchemaAndValue toConnectHeader(String topic, String headerKey, byte[] value) {
        return this.toConnectData(topic, value);
    }

    public void close() throws IOException {
    }
}

