/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime.events;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.kafka.common.compress.Compression;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.utils.ByteBufferOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectMetadataCompressionUtils {
    private static final Logger log = LoggerFactory.getLogger(ConnectMetadataCompressionUtils.class);

    public static ByteBuffer compress(byte[] data, CompressionType compressionType) throws IOException {
        if (compressionType == CompressionType.NONE) {
            return ByteBuffer.wrap(data);
        }
        try (ByteBufferOutputStream compressedOut = new ByteBufferOutputStream(512);){
            Compression compression = Compression.of((CompressionType)compressionType).build();
            try (OutputStream out = compression.wrapForOutput(compressedOut, (byte)2);){
                out.write(data);
            }
            compressedOut.buffer().flip();
            ByteBuffer byteBuffer = compressedOut.buffer();
            return byteBuffer;
        }
    }

    public static String getContentEncodingHeader(CompressionType compressionType) {
        if (compressionType == null || compressionType == CompressionType.NONE) {
            return null;
        }
        switch (compressionType) {
            case GZIP: {
                return "gzip";
            }
            case ZSTD: {
                return "zstd";
            }
            case LZ4: {
                return "lz4";
            }
        }
        log.warn("Unknown compression type: {}, returning null for Content-Encoding", (Object)compressionType);
        return null;
    }

    public static boolean shouldCompress(int dataSize, int minSizeThreshold) {
        return dataSize >= minSizeThreshold;
    }
}

