/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.Collections;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.ProtoUtils;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.ApiVersionsResponse;

public class ApiVersionsRequest
extends AbstractRequest {
    public ApiVersionsRequest(short version) {
        this(new Struct(ProtoUtils.requestSchema(ApiKeys.API_VERSIONS.id, version)), version);
    }

    public ApiVersionsRequest(Struct struct, short versionId) {
        super(struct, versionId);
    }

    @Override
    public AbstractResponse getErrorResponse(Throwable e) {
        short versionId = this.version();
        switch (versionId) {
            case 0: {
                short errorCode = Errors.forException(e).code();
                return new ApiVersionsResponse(errorCode, Collections.emptyList());
            }
        }
        throw new IllegalArgumentException(String.format("Version %d is not valid. Valid versions for %s are 0 to %d", versionId, this.getClass().getSimpleName(), ProtoUtils.latestVersion(ApiKeys.API_VERSIONS.id)));
    }

    public static ApiVersionsRequest parse(ByteBuffer buffer, int versionId) {
        return new ApiVersionsRequest(ProtoUtils.parseRequest(ApiKeys.API_VERSIONS.id, versionId, buffer), (short)versionId);
    }

    public static ApiVersionsRequest parse(ByteBuffer buffer) {
        return ApiVersionsRequest.parse(buffer, ProtoUtils.latestVersion(ApiKeys.API_VERSIONS.id));
    }

    public static class Builder
    extends AbstractRequest.Builder<ApiVersionsRequest> {
        public Builder() {
            super(ApiKeys.API_VERSIONS);
        }

        @Override
        public ApiVersionsRequest build() {
            return new ApiVersionsRequest(this.version());
        }

        public String toString() {
            return "(type=ApiVersionsRequest)";
        }
    }
}

