/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.apache.kafka.clients.ClientRequest;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.Metadata;
import org.apache.kafka.clients.NodeApiVersions;
import org.apache.kafka.clients.RequestCompletionHandler;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.errors.AuthenticationException;
import org.apache.kafka.common.errors.InterruptException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.test.TestCondition;
import org.apache.kafka.test.TestUtils;

public class MockClient
implements KafkaClient {
    public static final RequestMatcher ALWAYS_TRUE = new RequestMatcher(){

        @Override
        public boolean matches(AbstractRequest body) {
            return true;
        }
    };
    private final Time time;
    private final Metadata metadata;
    private Set<String> unavailableTopics;
    private Cluster cluster;
    private Node node = null;
    private final Set<String> ready = new HashSet<String>();
    private final Map<Node, Long> blackedOut = new HashMap<Node, Long>();
    private final Queue<ClientRequest> requests = new ConcurrentLinkedDeque<ClientRequest>();
    private final Queue<ClientResponse> responses = new ConcurrentLinkedDeque<ClientResponse>();
    private final Queue<FutureResponse> futureResponses = new ArrayDeque<FutureResponse>();
    private final Queue<MetadataUpdate> metadataUpdates = new ArrayDeque<MetadataUpdate>();
    private volatile NodeApiVersions nodeApiVersions = NodeApiVersions.create();
    private volatile int numBlockingWakeups = 0;

    public MockClient(Time time) {
        this(time, null);
    }

    public MockClient(Time time, Metadata metadata) {
        this.time = time;
        this.metadata = metadata;
        this.unavailableTopics = Collections.emptySet();
    }

    public boolean isReady(Node node, long now) {
        return this.ready.contains(node.idString());
    }

    public boolean ready(Node node, long now) {
        if (this.isBlackedOut(node)) {
            return false;
        }
        this.ready.add(node.idString());
        return true;
    }

    public long connectionDelay(Node node, long now) {
        return 0L;
    }

    public void blackout(Node node, long duration) {
        this.blackedOut.put(node, this.time.milliseconds() + duration);
    }

    private boolean isBlackedOut(Node node) {
        if (this.blackedOut.containsKey(node)) {
            long expiration = this.blackedOut.get(node);
            if (this.time.milliseconds() > expiration) {
                this.blackedOut.remove(node);
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean connectionFailed(Node node) {
        return this.isBlackedOut(node);
    }

    public AuthenticationException authenticationException(Node node) {
        return null;
    }

    public void disconnect(String node) {
        long now = this.time.milliseconds();
        Iterator iter = this.requests.iterator();
        while (iter.hasNext()) {
            ClientRequest request = (ClientRequest)iter.next();
            if (!request.destination().equals(node)) continue;
            short version = request.requestBuilder().latestAllowedVersion();
            this.responses.add(new ClientResponse(request.makeHeader(version), request.callback(), request.destination(), request.createdTimeMs(), now, true, null, null));
            iter.remove();
        }
        this.ready.remove(node);
    }

    public void send(ClientRequest request, long now) {
        Iterator iterator = this.futureResponses.iterator();
        while (iterator.hasNext()) {
            FutureResponse futureResp = (FutureResponse)iterator.next();
            if (futureResp.node != null && !request.destination().equals(futureResp.node.idString())) continue;
            AbstractRequest.Builder builder = request.requestBuilder();
            short version = this.nodeApiVersions.latestUsableVersion(request.apiKey(), builder.oldestAllowedVersion(), builder.latestAllowedVersion());
            AbstractRequest abstractRequest = request.requestBuilder().build(version);
            if (!futureResp.requestMatcher.matches(abstractRequest)) {
                throw new IllegalStateException("Request matcher did not match next-in-line request " + abstractRequest);
            }
            UnsupportedVersionException unsupportedVersionException = null;
            if (futureResp.isUnsupportedRequest) {
                unsupportedVersionException = new UnsupportedVersionException("Api " + request.apiKey() + " with version " + version);
            }
            ClientResponse resp = new ClientResponse(request.makeHeader(version), request.callback(), request.destination(), request.createdTimeMs(), this.time.milliseconds(), futureResp.disconnected, unsupportedVersionException, futureResp.responseBody);
            this.responses.add(resp);
            iterator.remove();
            return;
        }
        this.requests.add(request);
    }

    public synchronized void enableBlockingUntilWakeup(int numBlockingWakeups) {
        this.numBlockingWakeups = numBlockingWakeups;
    }

    public synchronized void wakeup() {
        if (this.numBlockingWakeups > 0) {
            --this.numBlockingWakeups;
            this.notify();
        }
    }

    private synchronized void maybeAwaitWakeup() {
        try {
            int remainingBlockingWakeups = this.numBlockingWakeups;
            if (remainingBlockingWakeups <= 0) {
                return;
            }
            while (this.numBlockingWakeups == remainingBlockingWakeups) {
                this.wait();
            }
        }
        catch (InterruptedException e) {
            throw new InterruptException(e);
        }
    }

    public List<ClientResponse> poll(long timeoutMs, long now) {
        ClientResponse response;
        this.maybeAwaitWakeup();
        ArrayList<ClientResponse> copy = new ArrayList<ClientResponse>(this.responses);
        if (this.metadata != null && this.metadata.updateRequested()) {
            MetadataUpdate metadataUpdate = this.metadataUpdates.poll();
            if (this.cluster != null) {
                this.metadata.update(this.cluster, this.unavailableTopics, this.time.milliseconds());
            }
            if (metadataUpdate == null) {
                this.metadata.update(this.metadata.fetch(), this.unavailableTopics, this.time.milliseconds());
            } else {
                if (metadataUpdate.expectMatchRefreshTopics && !this.metadata.topics().equals(metadataUpdate.cluster.topics())) {
                    throw new IllegalStateException("The metadata topics does not match expectation. Expected topics: " + metadataUpdate.cluster.topics() + ", asked topics: " + this.metadata.topics());
                }
                this.unavailableTopics = metadataUpdate.unavailableTopics;
                this.metadata.update(metadataUpdate.cluster, metadataUpdate.unavailableTopics, this.time.milliseconds());
            }
        }
        while ((response = this.responses.poll()) != null) {
            response.onComplete();
        }
        return copy;
    }

    public Queue<ClientRequest> requests() {
        return this.requests;
    }

    public void respond(AbstractResponse response) {
        this.respond(response, false);
    }

    public void respond(RequestMatcher matcher, AbstractResponse response) {
        ClientRequest nextRequest = this.requests.peek();
        if (nextRequest == null) {
            throw new IllegalStateException("No current requests queued");
        }
        AbstractRequest request = nextRequest.requestBuilder().build();
        if (!matcher.matches(request)) {
            throw new IllegalStateException("Request matcher did not match next-in-line request " + request);
        }
        this.respond(response);
    }

    public void respondToRequest(ClientRequest clientRequest, AbstractResponse response) {
        AbstractRequest request = clientRequest.requestBuilder().build();
        this.requests.remove(clientRequest);
        short version = clientRequest.requestBuilder().latestAllowedVersion();
        this.responses.add(new ClientResponse(clientRequest.makeHeader(version), clientRequest.callback(), clientRequest.destination(), clientRequest.createdTimeMs(), this.time.milliseconds(), false, null, response));
    }

    public void respond(AbstractResponse response, boolean disconnected) {
        ClientRequest request = this.requests.remove();
        short version = request.requestBuilder().latestAllowedVersion();
        this.responses.add(new ClientResponse(request.makeHeader(version), request.callback(), request.destination(), request.createdTimeMs(), this.time.milliseconds(), disconnected, null, response));
    }

    public void respondFrom(AbstractResponse response, Node node) {
        this.respondFrom(response, node, false);
    }

    public void respondFrom(AbstractResponse response, Node node, boolean disconnected) {
        Iterator iterator = this.requests.iterator();
        while (iterator.hasNext()) {
            ClientRequest request = (ClientRequest)iterator.next();
            if (!request.destination().equals(node.idString())) continue;
            iterator.remove();
            short version = request.requestBuilder().latestAllowedVersion();
            this.responses.add(new ClientResponse(request.makeHeader(version), request.callback(), request.destination(), request.createdTimeMs(), this.time.milliseconds(), disconnected, null, response));
            return;
        }
        throw new IllegalArgumentException("No requests available to node " + node);
    }

    public void prepareResponse(AbstractResponse response) {
        this.prepareResponse(ALWAYS_TRUE, response, false);
    }

    public void prepareResponseFrom(AbstractResponse response, Node node) {
        this.prepareResponseFrom(ALWAYS_TRUE, response, node, false, false);
    }

    public void prepareResponse(RequestMatcher matcher, AbstractResponse response) {
        this.prepareResponse(matcher, response, false);
    }

    public void prepareResponseFrom(RequestMatcher matcher, AbstractResponse response, Node node) {
        this.prepareResponseFrom(matcher, response, node, false, false);
    }

    public void prepareResponse(AbstractResponse response, boolean disconnected) {
        this.prepareResponse(ALWAYS_TRUE, response, disconnected);
    }

    public void prepareResponseFrom(AbstractResponse response, Node node, boolean disconnected) {
        this.prepareResponseFrom(ALWAYS_TRUE, response, node, disconnected, false);
    }

    public void prepareResponse(RequestMatcher matcher, AbstractResponse response, boolean disconnected) {
        this.prepareResponseFrom(matcher, response, null, disconnected, false);
    }

    public void prepareUnsupportedVersionResponse(RequestMatcher matcher) {
        this.prepareResponseFrom(matcher, null, null, false, true);
    }

    private void prepareResponseFrom(RequestMatcher matcher, AbstractResponse response, Node node, boolean disconnected, boolean isUnsupportedVersion) {
        this.futureResponses.add(new FutureResponse(node, matcher, response, disconnected, isUnsupportedVersion));
    }

    public void waitForRequests(final int minRequests, long maxWaitMs) throws InterruptedException {
        TestUtils.waitForCondition(new TestCondition(){

            @Override
            public boolean conditionMet() {
                return MockClient.this.requests.size() >= minRequests;
            }
        }, maxWaitMs, "Expected requests have not been sent");
    }

    public void reset() {
        this.ready.clear();
        this.blackedOut.clear();
        this.requests.clear();
        this.responses.clear();
        this.futureResponses.clear();
        this.metadataUpdates.clear();
    }

    public boolean hasPendingMetadataUpdates() {
        return !this.metadataUpdates.isEmpty();
    }

    public void prepareMetadataUpdate(Cluster cluster, Set<String> unavailableTopics) {
        this.metadataUpdates.add(new MetadataUpdate(cluster, unavailableTopics, false));
    }

    public void prepareMetadataUpdate(Cluster cluster, Set<String> unavailableTopics, boolean expectMatchMetadataTopics) {
        this.metadataUpdates.add(new MetadataUpdate(cluster, unavailableTopics, expectMatchMetadataTopics));
    }

    public void setNode(Node node) {
        this.node = node;
    }

    public void cluster(Cluster cluster) {
        this.cluster = cluster;
    }

    public int inFlightRequestCount() {
        return this.requests.size();
    }

    public boolean hasInFlightRequests() {
        return !this.requests.isEmpty();
    }

    public boolean hasPendingResponses() {
        return !this.responses.isEmpty();
    }

    public int inFlightRequestCount(String node) {
        int result = 0;
        for (ClientRequest req : this.requests) {
            if (!req.destination().equals(node)) continue;
            ++result;
        }
        return result;
    }

    public boolean hasInFlightRequests(String node) {
        return this.inFlightRequestCount(node) > 0;
    }

    public boolean hasReadyNodes() {
        return !this.ready.isEmpty();
    }

    public ClientRequest newClientRequest(String nodeId, AbstractRequest.Builder<?> requestBuilder, long createdTimeMs, boolean expectResponse) {
        return this.newClientRequest(nodeId, requestBuilder, createdTimeMs, expectResponse, null);
    }

    public ClientRequest newClientRequest(String nodeId, AbstractRequest.Builder<?> requestBuilder, long createdTimeMs, boolean expectResponse, RequestCompletionHandler callback) {
        return new ClientRequest(nodeId, requestBuilder, 0, "mockClientId", createdTimeMs, expectResponse, callback);
    }

    public void close() {
    }

    public void close(String node) {
        this.ready.remove(node);
    }

    public Node leastLoadedNode(long now) {
        return this.node;
    }

    public void setNodeApiVersions(NodeApiVersions nodeApiVersions) {
        this.nodeApiVersions = nodeApiVersions;
    }

    private static class MetadataUpdate {
        final Cluster cluster;
        final Set<String> unavailableTopics;
        final boolean expectMatchRefreshTopics;

        MetadataUpdate(Cluster cluster, Set<String> unavailableTopics, boolean expectMatchRefreshTopics) {
            this.cluster = cluster;
            this.unavailableTopics = unavailableTopics;
            this.expectMatchRefreshTopics = expectMatchRefreshTopics;
        }
    }

    public static interface RequestMatcher {
        public boolean matches(AbstractRequest var1);
    }

    private static class FutureResponse {
        private final Node node;
        private final RequestMatcher requestMatcher;
        private final AbstractResponse responseBody;
        private final boolean disconnected;
        private final boolean isUnsupportedRequest;

        public FutureResponse(Node node, RequestMatcher requestMatcher, AbstractResponse responseBody, boolean disconnected, boolean isUnsupportedRequest) {
            this.node = node;
            this.requestMatcher = requestMatcher;
            this.responseBody = responseBody;
            this.disconnected = disconnected;
            this.isUnsupportedRequest = isUnsupportedRequest;
        }
    }
}

