/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.metrics;

import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.utils.SystemTime;
import org.apache.kafka.common.utils.Time;
import org.junit.Assert;
import org.junit.Test;

public class SensorTest {
    @Test
    public void testRecordLevelEnum() {
        Sensor.RecordingLevel configLevel = Sensor.RecordingLevel.INFO;
        Assert.assertTrue((boolean)Sensor.RecordingLevel.INFO.shouldRecord((int)configLevel.id));
        Assert.assertFalse((boolean)Sensor.RecordingLevel.DEBUG.shouldRecord((int)configLevel.id));
        configLevel = Sensor.RecordingLevel.DEBUG;
        Assert.assertTrue((boolean)Sensor.RecordingLevel.INFO.shouldRecord((int)configLevel.id));
        Assert.assertTrue((boolean)Sensor.RecordingLevel.DEBUG.shouldRecord((int)configLevel.id));
        Assert.assertEquals((Object)Sensor.RecordingLevel.valueOf((String)Sensor.RecordingLevel.DEBUG.toString()), (Object)Sensor.RecordingLevel.DEBUG);
        Assert.assertEquals((Object)Sensor.RecordingLevel.valueOf((String)Sensor.RecordingLevel.INFO.toString()), (Object)Sensor.RecordingLevel.INFO);
    }

    @Test
    public void testShouldRecord() {
        MetricConfig debugConfig = new MetricConfig().recordLevel(Sensor.RecordingLevel.DEBUG);
        MetricConfig infoConfig = new MetricConfig().recordLevel(Sensor.RecordingLevel.INFO);
        Sensor infoSensor = new Sensor(null, "infoSensor", null, debugConfig, (Time)new SystemTime(), 0L, Sensor.RecordingLevel.INFO);
        Assert.assertTrue((boolean)infoSensor.shouldRecord());
        infoSensor = new Sensor(null, "infoSensor", null, debugConfig, (Time)new SystemTime(), 0L, Sensor.RecordingLevel.DEBUG);
        Assert.assertTrue((boolean)infoSensor.shouldRecord());
        Sensor debugSensor = new Sensor(null, "debugSensor", null, infoConfig, (Time)new SystemTime(), 0L, Sensor.RecordingLevel.INFO);
        Assert.assertTrue((boolean)debugSensor.shouldRecord());
        debugSensor = new Sensor(null, "debugSensor", null, infoConfig, (Time)new SystemTime(), 0L, Sensor.RecordingLevel.DEBUG);
        Assert.assertFalse((boolean)debugSensor.shouldRecord());
    }
}

