/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.requests.DescribeConfigsResponse;
import org.apache.kafka.common.requests.Resource;
import org.apache.kafka.common.requests.ResourceType;

public class DescribeConfigsRequest
extends AbstractRequest {
    private static final String RESOURCES_KEY_NAME = "resources";
    private static final String INCLUDE_SYNONYMS = "include_synonyms";
    private static final String RESOURCE_TYPE_KEY_NAME = "resource_type";
    private static final String RESOURCE_NAME_KEY_NAME = "resource_name";
    private static final String CONFIG_NAMES_KEY_NAME = "config_names";
    private static final Schema DESCRIBE_CONFIGS_REQUEST_RESOURCE_V0 = new Schema(new Field("resource_type", Type.INT8), new Field("resource_name", Type.STRING), new Field("config_names", ArrayOf.nullable(Type.STRING)));
    private static final Schema DESCRIBE_CONFIGS_REQUEST_V0 = new Schema(new Field("resources", new ArrayOf(DESCRIBE_CONFIGS_REQUEST_RESOURCE_V0), "An array of config resources to be returned."));
    private static final Schema DESCRIBE_CONFIGS_REQUEST_V1 = new Schema(new Field("resources", new ArrayOf(DESCRIBE_CONFIGS_REQUEST_RESOURCE_V0), "An array of config resources to be returned."), new Field("include_synonyms", Type.BOOLEAN));
    private final Map<Resource, Collection<String>> resourceToConfigNames;
    private final boolean includeSynonyms;

    public static Schema[] schemaVersions() {
        return new Schema[]{DESCRIBE_CONFIGS_REQUEST_V0, DESCRIBE_CONFIGS_REQUEST_V1};
    }

    public DescribeConfigsRequest(short version, Map<Resource, Collection<String>> resourceToConfigNames, boolean includeSynonyms) {
        super(version);
        this.resourceToConfigNames = resourceToConfigNames;
        this.includeSynonyms = includeSynonyms;
    }

    public DescribeConfigsRequest(Struct struct, short version) {
        super(version);
        Object[] resourcesArray = struct.getArray(RESOURCES_KEY_NAME);
        this.resourceToConfigNames = new HashMap<Resource, Collection<String>>(resourcesArray.length);
        for (Object resourceObj : resourcesArray) {
            Struct resourceStruct = (Struct)resourceObj;
            ResourceType resourceType = ResourceType.forId(resourceStruct.getByte(RESOURCE_TYPE_KEY_NAME));
            String resourceName = resourceStruct.getString(RESOURCE_NAME_KEY_NAME);
            Object[] configNamesArray = resourceStruct.getArray(CONFIG_NAMES_KEY_NAME);
            ArrayList<String> configNames = null;
            if (configNamesArray != null) {
                configNames = new ArrayList<String>(configNamesArray.length);
                for (Object configNameObj : configNamesArray) {
                    configNames.add((String)configNameObj);
                }
            }
            this.resourceToConfigNames.put(new Resource(resourceType, resourceName), configNames);
        }
        this.includeSynonyms = struct.hasField(INCLUDE_SYNONYMS) ? struct.getBoolean(INCLUDE_SYNONYMS) : false;
    }

    public Collection<Resource> resources() {
        return this.resourceToConfigNames.keySet();
    }

    public Collection<String> configNames(Resource resource) {
        return this.resourceToConfigNames.get(resource);
    }

    public boolean includeSynonyms() {
        return this.includeSynonyms;
    }

    @Override
    protected Struct toStruct() {
        Struct struct = new Struct(ApiKeys.DESCRIBE_CONFIGS.requestSchema(this.version()));
        ArrayList<Struct> resourceStructs = new ArrayList<Struct>(this.resources().size());
        for (Map.Entry<Resource, Collection<String>> entry : this.resourceToConfigNames.entrySet()) {
            Resource resource = entry.getKey();
            Struct resourceStruct = struct.instance(RESOURCES_KEY_NAME);
            resourceStruct.set(RESOURCE_TYPE_KEY_NAME, (Object)resource.type().id());
            resourceStruct.set(RESOURCE_NAME_KEY_NAME, (Object)resource.name());
            String[] configNames = entry.getValue() == null ? null : entry.getValue().toArray(new String[0]);
            resourceStruct.set(CONFIG_NAMES_KEY_NAME, configNames);
            resourceStructs.add(resourceStruct);
        }
        struct.set(RESOURCES_KEY_NAME, (Object)resourceStructs.toArray(new Struct[0]));
        struct.setIfExists(INCLUDE_SYNONYMS, (Object)this.includeSynonyms);
        return struct;
    }

    @Override
    public DescribeConfigsResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        short version = this.version();
        switch (version) {
            case 0: 
            case 1: {
                ApiError error = ApiError.fromThrowable(e);
                HashMap<Resource, DescribeConfigsResponse.Config> errors = new HashMap<Resource, DescribeConfigsResponse.Config>(this.resources().size());
                DescribeConfigsResponse.Config config = new DescribeConfigsResponse.Config(error, Collections.emptyList());
                for (Resource resource : this.resources()) {
                    errors.put(resource, config);
                }
                return new DescribeConfigsResponse(throttleTimeMs, errors);
            }
        }
        throw new IllegalArgumentException(String.format("Version %d is not valid. Valid versions for %s are 0 to %d", version, this.getClass().getSimpleName(), ApiKeys.DESCRIBE_CONFIGS.latestVersion()));
    }

    public static DescribeConfigsRequest parse(ByteBuffer buffer, short version) {
        return new DescribeConfigsRequest(ApiKeys.DESCRIBE_CONFIGS.parseRequest(version, buffer), version);
    }

    public static class Builder
    extends AbstractRequest.Builder {
        private final Map<Resource, Collection<String>> resourceToConfigNames;
        private boolean includeSynonyms;

        public Builder(Map<Resource, Collection<String>> resourceToConfigNames) {
            super(ApiKeys.DESCRIBE_CONFIGS);
            this.resourceToConfigNames = resourceToConfigNames;
        }

        public Builder includeSynonyms(boolean includeSynonyms) {
            this.includeSynonyms = includeSynonyms;
            return this;
        }

        public Builder(Collection<Resource> resources) {
            this(Builder.toResourceToConfigNames(resources));
        }

        private static Map<Resource, Collection<String>> toResourceToConfigNames(Collection<Resource> resources) {
            HashMap<Resource, Collection<String>> result = new HashMap<Resource, Collection<String>>(resources.size());
            for (Resource resource : resources) {
                result.put(resource, null);
            }
            return result;
        }

        public DescribeConfigsRequest build(short version) {
            return new DescribeConfigsRequest(version, this.resourceToConfigNames, this.includeSynonyms);
        }
    }
}

