/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.DescribeGroupsResponse;
import org.apache.kafka.common.utils.Utils;

public class DescribeGroupsRequest
extends AbstractRequest {
    private static final String GROUP_IDS_KEY_NAME = "group_ids";
    private static final Schema DESCRIBE_GROUPS_REQUEST_V0;
    private static final Schema DESCRIBE_GROUPS_REQUEST_V1;
    private final List<String> groupIds;

    public static Schema[] schemaVersions() {
        return new Schema[]{DESCRIBE_GROUPS_REQUEST_V0, DESCRIBE_GROUPS_REQUEST_V1};
    }

    private DescribeGroupsRequest(List<String> groupIds, short version) {
        super(version);
        this.groupIds = groupIds;
    }

    public DescribeGroupsRequest(Struct struct, short version) {
        super(version);
        this.groupIds = new ArrayList<String>();
        for (Object groupId : struct.getArray(GROUP_IDS_KEY_NAME)) {
            this.groupIds.add((String)groupId);
        }
    }

    public List<String> groupIds() {
        return this.groupIds;
    }

    @Override
    protected Struct toStruct() {
        Struct struct = new Struct(ApiKeys.DESCRIBE_GROUPS.requestSchema(this.version()));
        struct.set(GROUP_IDS_KEY_NAME, (Object)this.groupIds.toArray());
        return struct;
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        short version = this.version();
        switch (version) {
            case 0: {
                return DescribeGroupsResponse.fromError(Errors.forException(e), this.groupIds);
            }
            case 1: {
                return DescribeGroupsResponse.fromError(throttleTimeMs, Errors.forException(e), this.groupIds);
            }
        }
        throw new IllegalArgumentException(String.format("Version %d is not valid. Valid versions for %s are 0 to %d", version, this.getClass().getSimpleName(), ApiKeys.DESCRIBE_GROUPS.latestVersion()));
    }

    public static DescribeGroupsRequest parse(ByteBuffer buffer, short version) {
        return new DescribeGroupsRequest(ApiKeys.DESCRIBE_GROUPS.parseRequest(version, buffer), version);
    }

    static {
        DESCRIBE_GROUPS_REQUEST_V1 = DESCRIBE_GROUPS_REQUEST_V0 = new Schema(new Field(GROUP_IDS_KEY_NAME, new ArrayOf(Type.STRING), "List of groupIds to request metadata for (an empty groupId array will return empty group metadata)."));
    }

    public static class Builder
    extends AbstractRequest.Builder<DescribeGroupsRequest> {
        private final List<String> groupIds;

        public Builder(List<String> groupIds) {
            super(ApiKeys.DESCRIBE_GROUPS);
            this.groupIds = groupIds;
        }

        @Override
        public DescribeGroupsRequest build(short version) {
            return new DescribeGroupsRequest(this.groupIds, version);
        }

        public String toString() {
            return "(type=DescribeGroupsRequest, groupIds=(" + Utils.join(this.groupIds, ",") + "))";
        }
    }
}

