/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;

public class AlterConfigsResponseData
implements ApiMessage {
    private int throttleTimeMs;
    private List<AlterConfigsResourceResponse> resources;
    public static final Schema SCHEMA_0;
    public static final Schema SCHEMA_1;
    public static final Schema[] SCHEMAS;

    public AlterConfigsResponseData(Readable readable, short version) {
        this.resources = new ArrayList<AlterConfigsResourceResponse>();
        this.read(readable, version);
    }

    public AlterConfigsResponseData(Struct struct, short version) {
        this.resources = new ArrayList<AlterConfigsResourceResponse>();
        this.fromStruct(struct, version);
    }

    public AlterConfigsResponseData() {
        this.throttleTimeMs = 0;
        this.resources = new ArrayList<AlterConfigsResourceResponse>();
    }

    public short apiKey() {
        return 33;
    }

    public short lowestSupportedVersion() {
        return 0;
    }

    public short highestSupportedVersion() {
        return 1;
    }

    public void read(Readable readable, short version) {
        this.throttleTimeMs = readable.readInt();
        int arrayLength = readable.readInt();
        if (arrayLength < 0) {
            this.resources = null;
        } else {
            this.resources.clear();
            for (int i = 0; i < arrayLength; ++i) {
                this.resources.add(new AlterConfigsResourceResponse(readable, version));
            }
        }
    }

    public void write(Writable writable, short version) {
        writable.writeInt(this.throttleTimeMs);
        writable.writeInt(this.resources.size());
        for (AlterConfigsResourceResponse element : this.resources) {
            element.write(writable, version);
        }
    }

    public void fromStruct(Struct struct, short version) {
        this.throttleTimeMs = struct.getInt("throttle_time_ms");
        Object[] nestedObjects = struct.getArray("resources");
        this.resources = new ArrayList<AlterConfigsResourceResponse>(nestedObjects.length);
        for (Object nestedObject : nestedObjects) {
            this.resources.add(new AlterConfigsResourceResponse((Struct)nestedObject, version));
        }
    }

    public Struct toStruct(short version) {
        Struct struct = new Struct(SCHEMAS[version]);
        struct.set("throttle_time_ms", (Object)this.throttleTimeMs);
        Struct[] nestedObjects = new Struct[this.resources.size()];
        int i = 0;
        for (AlterConfigsResourceResponse element : this.resources) {
            nestedObjects[i++] = element.toStruct(version);
        }
        struct.set("resources", (Object)nestedObjects);
        return struct;
    }

    public int size(short version) {
        int size = 0;
        size += 4;
        size += 4;
        for (AlterConfigsResourceResponse element : this.resources) {
            size += element.size(version);
        }
        return size;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AlterConfigsResponseData)) {
            return false;
        }
        AlterConfigsResponseData other = (AlterConfigsResponseData)obj;
        if (this.throttleTimeMs != other.throttleTimeMs) {
            return false;
        }
        return !(this.resources == null ? other.resources != null : !this.resources.equals(other.resources));
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.throttleTimeMs;
        hashCode = 31 * hashCode + (this.resources == null ? 0 : this.resources.hashCode());
        return hashCode;
    }

    public String toString() {
        return "AlterConfigsResponseData(throttleTimeMs=" + this.throttleTimeMs + ", resources=" + MessageUtil.deepToString(this.resources.iterator()) + ")";
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public List<AlterConfigsResourceResponse> resources() {
        return this.resources;
    }

    public AlterConfigsResponseData setThrottleTimeMs(int v) {
        this.throttleTimeMs = v;
        return this;
    }

    public AlterConfigsResponseData setResources(List<AlterConfigsResourceResponse> v) {
        this.resources = v;
        return this;
    }

    static {
        SCHEMA_1 = SCHEMA_0 = new Schema(new Field[]{new Field("throttle_time_ms", (Type)Type.INT32, "Duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("resources", (Type)new ArrayOf((Type)AlterConfigsResourceResponse.SCHEMA_0), "The responses for each resource.")});
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};
    }

    public static class AlterConfigsResourceResponse
    implements Message {
        private short errorCode;
        private String errorMessage;
        private byte resourceType;
        private String resourceName;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema[] SCHEMAS;

        public AlterConfigsResourceResponse(Readable readable, short version) {
            this.read(readable, version);
        }

        public AlterConfigsResourceResponse(Struct struct, short version) {
            this.fromStruct(struct, version);
        }

        public AlterConfigsResourceResponse() {
            this.errorCode = 0;
            this.errorMessage = "";
            this.resourceType = 0;
            this.resourceName = "";
        }

        public short lowestSupportedVersion() {
            return 0;
        }

        public short highestSupportedVersion() {
            return 1;
        }

        public void read(Readable readable, short version) {
            this.errorCode = readable.readShort();
            this.errorMessage = readable.readNullableString();
            this.resourceType = readable.readByte();
            this.resourceName = readable.readNullableString();
        }

        public void write(Writable writable, short version) {
            writable.writeShort(this.errorCode);
            writable.writeNullableString(this.errorMessage);
            writable.writeByte(this.resourceType);
            writable.writeString(this.resourceName);
        }

        public void fromStruct(Struct struct, short version) {
            this.errorCode = struct.getShort("error_code");
            this.errorMessage = struct.getString("error_message");
            this.resourceType = struct.getByte("resource_type");
            this.resourceName = struct.getString("resource_name");
        }

        public Struct toStruct(short version) {
            Struct struct = new Struct(SCHEMAS[version]);
            struct.set("error_code", (Object)this.errorCode);
            struct.set("error_message", (Object)this.errorMessage);
            struct.set("resource_type", (Object)this.resourceType);
            struct.set("resource_name", (Object)this.resourceName);
            return struct;
        }

        public int size(short version) {
            int size = 0;
            size += 2;
            size += 2;
            if (this.errorMessage != null) {
                size += MessageUtil.serializedUtf8Length((CharSequence)this.errorMessage);
            }
            ++size;
            size += 2;
            return size += MessageUtil.serializedUtf8Length((CharSequence)this.resourceName);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof AlterConfigsResourceResponse)) {
                return false;
            }
            AlterConfigsResourceResponse other = (AlterConfigsResourceResponse)obj;
            if (this.errorCode != other.errorCode) {
                return false;
            }
            if (this.errorMessage == null ? other.errorMessage != null : !this.errorMessage.equals(other.errorMessage)) {
                return false;
            }
            if (this.resourceType != other.resourceType) {
                return false;
            }
            return !(this.resourceName == null ? other.resourceName != null : !this.resourceName.equals(other.resourceName));
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.errorCode;
            hashCode = 31 * hashCode + (this.errorMessage == null ? 0 : this.errorMessage.hashCode());
            hashCode = 31 * hashCode + this.resourceType;
            hashCode = 31 * hashCode + (this.resourceName == null ? 0 : this.resourceName.hashCode());
            return hashCode;
        }

        public String toString() {
            return "AlterConfigsResourceResponse(errorCode=" + this.errorCode + ", errorMessage='" + this.errorMessage + "', resourceType=" + this.resourceType + ", resourceName='" + this.resourceName + "')";
        }

        public short errorCode() {
            return this.errorCode;
        }

        public String errorMessage() {
            return this.errorMessage;
        }

        public byte resourceType() {
            return this.resourceType;
        }

        public String resourceName() {
            return this.resourceName;
        }

        public AlterConfigsResourceResponse setErrorCode(short v) {
            this.errorCode = v;
            return this;
        }

        public AlterConfigsResourceResponse setErrorMessage(String v) {
            this.errorMessage = v;
            return this;
        }

        public AlterConfigsResourceResponse setResourceType(byte v) {
            this.resourceType = v;
            return this;
        }

        public AlterConfigsResourceResponse setResourceName(String v) {
            this.resourceName = v;
            return this;
        }

        static {
            SCHEMA_1 = SCHEMA_0 = new Schema(new Field[]{new Field("error_code", (Type)Type.INT16, "The resource error code."), new Field("error_message", (Type)Type.NULLABLE_STRING, "The resource error message, or null if there was no error."), new Field("resource_type", (Type)Type.INT8, "The resource type."), new Field("resource_name", (Type)Type.STRING, "The resource name.")});
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};
        }
    }
}

