/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.protocol;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.kafka.common.protocol.MessageUtil;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;

public final class MessageUtilTest {
    @Rule
    public final Timeout globalTimeout = Timeout.millis((long)120000L);

    @Test
    public void testDeepToString() {
        Assert.assertEquals((Object)"[1, 2, 3]", (Object)MessageUtil.deepToString(Arrays.asList(1, 2, 3).iterator()));
        Assert.assertEquals((Object)"[foo]", (Object)MessageUtil.deepToString(Arrays.asList("foo").iterator()));
    }

    @Test
    public void testByteBufferToArray() {
        Assert.assertArrayEquals((byte[])new byte[]{1, 2, 3}, (byte[])MessageUtil.byteBufferToArray((ByteBuffer)ByteBuffer.wrap(new byte[]{1, 2, 3})));
        Assert.assertArrayEquals((byte[])new byte[0], (byte[])MessageUtil.byteBufferToArray((ByteBuffer)ByteBuffer.wrap(new byte[0])));
    }
}

