/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.producer;

import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RecordMetadataTest {
    @Test
    public void testConstructionWithMissingBatchIndex() {
        TopicPartition tp = new TopicPartition("foo", 0);
        long timestamp = 2340234L;
        int keySize = 3;
        int valueSize = 5;
        RecordMetadata metadata = new RecordMetadata(tp, -1L, -1, timestamp, keySize, valueSize);
        Assertions.assertEquals((Object)tp.topic(), (Object)metadata.topic());
        Assertions.assertEquals((int)tp.partition(), (int)metadata.partition());
        Assertions.assertEquals((long)timestamp, (long)metadata.timestamp());
        Assertions.assertFalse((boolean)metadata.hasOffset());
        Assertions.assertEquals((long)-1L, (long)metadata.offset());
        Assertions.assertEquals((int)keySize, (int)metadata.serializedKeySize());
        Assertions.assertEquals((int)valueSize, (int)metadata.serializedValueSize());
    }

    @Test
    public void testConstructionWithBatchIndexOffset() {
        TopicPartition tp = new TopicPartition("foo", 0);
        long timestamp = 2340234L;
        int keySize = 3;
        int valueSize = 5;
        long baseOffset = 15L;
        int batchIndex = 3;
        RecordMetadata metadata = new RecordMetadata(tp, baseOffset, batchIndex, timestamp, keySize, valueSize);
        Assertions.assertEquals((Object)tp.topic(), (Object)metadata.topic());
        Assertions.assertEquals((int)tp.partition(), (int)metadata.partition());
        Assertions.assertEquals((long)timestamp, (long)metadata.timestamp());
        Assertions.assertEquals((long)(baseOffset + (long)batchIndex), (long)metadata.offset());
        Assertions.assertEquals((int)keySize, (int)metadata.serializedKeySize());
        Assertions.assertEquals((int)valueSize, (int)metadata.serializedValueSize());
    }

    @Test
    @Deprecated
    public void testConstructionWithChecksum() {
        TopicPartition tp = new TopicPartition("foo", 0);
        long timestamp = 2340234L;
        long baseOffset = 15L;
        long batchIndex = 3L;
        int keySize = 3;
        int valueSize = 5;
        RecordMetadata metadata = new RecordMetadata(tp, baseOffset, batchIndex, timestamp, null, keySize, valueSize);
        Assertions.assertEquals((Object)tp.topic(), (Object)metadata.topic());
        Assertions.assertEquals((int)tp.partition(), (int)metadata.partition());
        Assertions.assertEquals((long)timestamp, (long)metadata.timestamp());
        Assertions.assertEquals((long)(baseOffset + batchIndex), (long)metadata.offset());
        Assertions.assertEquals((int)keySize, (int)metadata.serializedKeySize());
        Assertions.assertEquals((int)valueSize, (int)metadata.serializedValueSize());
        long checksum = 133424L;
        metadata = new RecordMetadata(tp, baseOffset, batchIndex, timestamp, Long.valueOf(checksum), keySize, valueSize);
        Assertions.assertEquals((Object)tp.topic(), (Object)metadata.topic());
        Assertions.assertEquals((int)tp.partition(), (int)metadata.partition());
        Assertions.assertEquals((long)timestamp, (long)metadata.timestamp());
        Assertions.assertEquals((long)(baseOffset + batchIndex), (long)metadata.offset());
        Assertions.assertEquals((int)keySize, (int)metadata.serializedKeySize());
        Assertions.assertEquals((int)valueSize, (int)metadata.serializedValueSize());
    }
}

