/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import java.util.Map;
import org.apache.kafka.clients.consumer.internals.FetchMetricsManager;
import org.apache.kafka.clients.consumer.internals.FetchMetricsRegistry;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.MetricNameTemplate;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class FetchMetricsManagerTest {
    private static final double EPSILON = 1.0E-4;
    private final Time time = new MockTime(1L, 0L, 0L);
    private static final String TOPIC_NAME = "test";
    private static final TopicPartition TP = new TopicPartition("test", 0);
    private Metrics metrics;
    private FetchMetricsRegistry metricsRegistry;
    private FetchMetricsManager metricsManager;

    @BeforeEach
    public void setup() {
        this.metrics = new Metrics(this.time);
        this.metricsRegistry = new FetchMetricsRegistry(this.metrics.config().tags().keySet(), TOPIC_NAME);
        this.metricsManager = new FetchMetricsManager(this.metrics, this.metricsRegistry);
    }

    @AfterEach
    public void tearDown() {
        if (this.metrics != null) {
            this.metrics.close();
            this.metrics = null;
        }
        this.metricsManager = null;
    }

    @Test
    public void testLatency() {
        this.metricsManager.recordLatency(123L);
        this.time.sleep(this.metrics.config().timeWindowMs() + 1L);
        this.metricsManager.recordLatency(456L);
        Assertions.assertEquals((double)289.5, (double)this.metricValue(this.metricsRegistry.fetchLatencyAvg), (double)1.0E-4);
        Assertions.assertEquals((double)456.0, (double)this.metricValue(this.metricsRegistry.fetchLatencyMax), (double)1.0E-4);
    }

    @Test
    public void testBytesFetched() {
        this.metricsManager.recordBytesFetched(2);
        this.time.sleep(this.metrics.config().timeWindowMs() + 1L);
        this.metricsManager.recordBytesFetched(10);
        Assertions.assertEquals((double)6.0, (double)this.metricValue(this.metricsRegistry.fetchSizeAvg), (double)1.0E-4);
        Assertions.assertEquals((double)10.0, (double)this.metricValue(this.metricsRegistry.fetchSizeMax), (double)1.0E-4);
    }

    @Test
    public void testBytesFetchedTopic() {
        String topicName1 = TOPIC_NAME;
        String topicName2 = "another-topic";
        Map tags1 = FetchMetricsManager.topicTags((String)topicName1);
        Map tags2 = FetchMetricsManager.topicTags((String)topicName2);
        this.metricsManager.recordBytesFetched(topicName1, 2);
        this.metricsManager.recordBytesFetched(topicName2, 1);
        this.time.sleep(this.metrics.config().timeWindowMs() + 1L);
        this.metricsManager.recordBytesFetched(topicName1, 10);
        this.metricsManager.recordBytesFetched(topicName2, 5);
        Assertions.assertEquals((double)6.0, (double)this.metricValue(this.metricsRegistry.topicFetchSizeAvg, tags1), (double)1.0E-4);
        Assertions.assertEquals((double)10.0, (double)this.metricValue(this.metricsRegistry.topicFetchSizeMax, tags1), (double)1.0E-4);
        Assertions.assertEquals((double)3.0, (double)this.metricValue(this.metricsRegistry.topicFetchSizeAvg, tags2), (double)1.0E-4);
        Assertions.assertEquals((double)5.0, (double)this.metricValue(this.metricsRegistry.topicFetchSizeMax, tags2), (double)1.0E-4);
    }

    @Test
    public void testRecordsFetched() {
        this.metricsManager.recordRecordsFetched(3);
        this.time.sleep(this.metrics.config().timeWindowMs() + 1L);
        this.metricsManager.recordRecordsFetched(15);
        Assertions.assertEquals((double)9.0, (double)this.metricValue(this.metricsRegistry.recordsPerRequestAvg), (double)1.0E-4);
    }

    @Test
    public void testRecordsFetchedTopic() {
        String topicName1 = TOPIC_NAME;
        String topicName2 = "another-topic";
        Map tags1 = FetchMetricsManager.topicTags((String)topicName1);
        Map tags2 = FetchMetricsManager.topicTags((String)topicName2);
        this.metricsManager.recordRecordsFetched(topicName1, 2);
        this.metricsManager.recordRecordsFetched(topicName2, 1);
        this.time.sleep(this.metrics.config().timeWindowMs() + 1L);
        this.metricsManager.recordRecordsFetched(topicName1, 10);
        this.metricsManager.recordRecordsFetched(topicName2, 5);
        Assertions.assertEquals((double)6.0, (double)this.metricValue(this.metricsRegistry.topicRecordsPerRequestAvg, tags1), (double)1.0E-4);
        Assertions.assertEquals((double)3.0, (double)this.metricValue(this.metricsRegistry.topicRecordsPerRequestAvg, tags2), (double)1.0E-4);
    }

    @Test
    public void testPartitionLag() {
        Map tags = FetchMetricsManager.topicPartitionTags((TopicPartition)TP);
        this.metricsManager.recordPartitionLag(TP, 14L);
        this.metricsManager.recordPartitionLag(TP, 8L);
        this.time.sleep(this.metrics.config().timeWindowMs() + 1L);
        this.metricsManager.recordPartitionLag(TP, 5L);
        Assertions.assertEquals((double)14.0, (double)this.metricValue(this.metricsRegistry.recordsLagMax), (double)1.0E-4);
        Assertions.assertEquals((double)5.0, (double)this.metricValue(this.metricsRegistry.partitionRecordsLag, tags), (double)1.0E-4);
        Assertions.assertEquals((double)14.0, (double)this.metricValue(this.metricsRegistry.partitionRecordsLagMax, tags), (double)1.0E-4);
        Assertions.assertEquals((double)9.0, (double)this.metricValue(this.metricsRegistry.partitionRecordsLagAvg, tags), (double)1.0E-4);
    }

    @Test
    public void testPartitionLead() {
        Map tags = FetchMetricsManager.topicPartitionTags((TopicPartition)TP);
        this.metricsManager.recordPartitionLead(TP, 15L);
        this.metricsManager.recordPartitionLead(TP, 11L);
        this.time.sleep(this.metrics.config().timeWindowMs() + 1L);
        this.metricsManager.recordPartitionLead(TP, 13L);
        Assertions.assertEquals((double)11.0, (double)this.metricValue(this.metricsRegistry.recordsLeadMin), (double)1.0E-4);
        Assertions.assertEquals((double)13.0, (double)this.metricValue(this.metricsRegistry.partitionRecordsLead, tags), (double)1.0E-4);
        Assertions.assertEquals((double)11.0, (double)this.metricValue(this.metricsRegistry.partitionRecordsLeadMin, tags), (double)1.0E-4);
        Assertions.assertEquals((double)13.0, (double)this.metricValue(this.metricsRegistry.partitionRecordsLeadAvg, tags), (double)1.0E-4);
    }

    private double metricValue(MetricNameTemplate name) {
        MetricName metricName = this.metrics.metricInstance(name, new String[0]);
        KafkaMetric metric = this.metrics.metric(metricName);
        return (Double)metric.metricValue();
    }

    private double metricValue(MetricNameTemplate name, Map<String, String> tags) {
        MetricName metricName = this.metrics.metricInstance(name, tags);
        KafkaMetric metric = this.metrics.metric(metricName);
        return (Double)metric.metricValue();
    }
}

