/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.telemetry.internals;

import java.time.Instant;
import java.util.Collections;
import java.util.Optional;
import org.apache.kafka.common.telemetry.internals.LastValueTracker;
import org.apache.kafka.common.telemetry.internals.MetricKey;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class LastValueTrackerTest {
    private static final MetricKey METRIC_NAME = new MetricKey("test-metric", Collections.emptyMap());
    private final Instant instant1 = Instant.now();
    private final Instant instant2 = this.instant1.plusMillis(1L);

    @Test
    public void testGetAndSetDouble() {
        LastValueTracker lastValueTracker = new LastValueTracker();
        Optional result = lastValueTracker.getAndSet(METRIC_NAME, this.instant1, (Object)1.0);
        Assertions.assertFalse((boolean)result.isPresent());
    }

    @Test
    public void testGetAndSetDoubleWithTrackedValue() {
        LastValueTracker lastValueTracker = new LastValueTracker();
        lastValueTracker.getAndSet(METRIC_NAME, this.instant1, (Object)1.0);
        Optional result = lastValueTracker.getAndSet(METRIC_NAME, this.instant2, (Object)1000.0);
        Assertions.assertTrue((boolean)result.isPresent());
        Assertions.assertEquals((Object)this.instant1, (Object)((LastValueTracker.InstantAndValue)result.get()).getIntervalStart());
        Assertions.assertEquals((double)1.0, (double)((Double)((LastValueTracker.InstantAndValue)result.get()).getValue()), (double)1.0E-6);
    }

    @Test
    public void testGetAndSetLong() {
        LastValueTracker lastValueTracker = new LastValueTracker();
        Optional result = lastValueTracker.getAndSet(METRIC_NAME, this.instant1, (Object)1L);
        Assertions.assertFalse((boolean)result.isPresent());
    }

    @Test
    public void testGetAndSetLongWithTrackedValue() {
        LastValueTracker lastValueTracker = new LastValueTracker();
        lastValueTracker.getAndSet(METRIC_NAME, this.instant1, (Object)2L);
        Optional result = lastValueTracker.getAndSet(METRIC_NAME, this.instant2, (Object)10000L);
        Assertions.assertTrue((boolean)result.isPresent());
        Assertions.assertEquals((Object)this.instant1, (Object)((LastValueTracker.InstantAndValue)result.get()).getIntervalStart());
        Assertions.assertEquals((long)2L, (long)((Long)((LastValueTracker.InstantAndValue)result.get()).getValue()));
    }

    @Test
    public void testRemove() {
        LastValueTracker lastValueTracker = new LastValueTracker();
        lastValueTracker.getAndSet(METRIC_NAME, this.instant1, (Object)1.0);
        Assertions.assertTrue((boolean)lastValueTracker.contains(METRIC_NAME));
        LastValueTracker.InstantAndValue result = lastValueTracker.remove(METRIC_NAME);
        Assertions.assertNotNull((Object)result);
        Assertions.assertEquals((Object)this.instant1, (Object)result.getIntervalStart());
        Assertions.assertEquals((double)1.0, (double)((Double)result.getValue()).longValue());
    }

    @Test
    public void testRemoveWithNullKey() {
        LastValueTracker lastValueTracker = new LastValueTracker();
        Assertions.assertThrows(NullPointerException.class, () -> lastValueTracker.remove(null));
    }

    @Test
    public void testRemoveWithInvalidKey() {
        LastValueTracker lastValueTracker = new LastValueTracker();
        Assertions.assertFalse((boolean)lastValueTracker.contains(METRIC_NAME));
        LastValueTracker.InstantAndValue result = lastValueTracker.remove(METRIC_NAME);
        Assertions.assertNull((Object)result);
    }
}

