/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.utils;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.stream.Stream;
import org.apache.kafka.common.utils.BufferSupplier;
import org.apache.kafka.common.utils.ByteBufferInputStream;
import org.apache.kafka.common.utils.ChunkedBytesStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.Mockito;

public class ChunkedBytesStreamTest {
    private static final Random RANDOM = new Random(1337L);
    private final BufferSupplier supplier = BufferSupplier.NO_CACHING;

    @Test
    public void testEofErrorForMethodReadFully() throws IOException {
        ByteBuffer input = ByteBuffer.allocate(8);
        int lengthGreaterThanInput = input.capacity() + 1;
        byte[] got = new byte[lengthGreaterThanInput];
        try (ChunkedBytesStream is = new ChunkedBytesStream((InputStream)new ByteBufferInputStream(input), this.supplier, 10, false);){
            Assertions.assertEquals((int)8, (int)is.read(got, 0, got.length), (String)"Should return 8 signifying end of input");
        }
    }

    @ParameterizedTest
    @MethodSource(value={"provideSourceBytebuffersForTest"})
    public void testCorrectnessForMethodReadFully(ByteBuffer input) throws IOException {
        byte[] got = new byte[input.array().length];
        try (ChunkedBytesStream is = new ChunkedBytesStream((InputStream)new ByteBufferInputStream(input), this.supplier, 10, false);){
            int toRead = RANDOM.nextInt(got.length);
            is.read(got, 0, toRead);
            is.read(got, toRead, got.length - toRead);
        }
        Assertions.assertArrayEquals((byte[])input.array(), (byte[])got);
    }

    @ParameterizedTest
    @MethodSource(value={"provideCasesWithInvalidInputsForMethodRead"})
    public void testInvalidInputsForMethodRead(byte[] b, int off, int len) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(16);
        try (ChunkedBytesStream is = new ChunkedBytesStream((InputStream)new ByteBufferInputStream(buffer.duplicate()), this.supplier, 10, false);){
            Assertions.assertThrows(IndexOutOfBoundsException.class, () -> ChunkedBytesStreamTest.lambda$testInvalidInputsForMethodRead$0((InputStream)is, b, off, len));
        }
    }

    @ParameterizedTest
    @MethodSource(value={"provideSourceBytebuffersForTest"})
    public void testCorrectnessForMethodReadByte(ByteBuffer input) throws IOException {
        byte[] got = new byte[input.array().length];
        try (ChunkedBytesStream is = new ChunkedBytesStream((InputStream)new ByteBufferInputStream(input), this.supplier, 10, false);){
            int i = 0;
            while (i < got.length) {
                got[i++] = (byte)is.read();
            }
        }
        Assertions.assertArrayEquals((byte[])input.array(), (byte[])got);
    }

    @ParameterizedTest
    @MethodSource(value={"provideSourceBytebuffersForTest"})
    public void testCorrectnessForMethodRead(ByteBuffer inputBuf) throws IOException {
        int[] inputArr = new int[inputBuf.capacity()];
        for (int i = 0; i < inputArr.length; ++i) {
            inputArr[i] = Byte.toUnsignedInt(inputBuf.get());
        }
        int[] got = new int[inputArr.length];
        inputBuf.rewind();
        try (ChunkedBytesStream is = new ChunkedBytesStream((InputStream)new ByteBufferInputStream(inputBuf), this.supplier, 10, false);){
            int i = 0;
            while (i < got.length) {
                got[i++] = is.read();
            }
        }
        Assertions.assertArrayEquals((int[])inputArr, (int[])got);
    }

    @Test
    public void testEndOfFileForMethodRead() throws IOException {
        ByteBuffer inputBuf = ByteBuffer.allocate(2);
        int lengthGreaterThanInput = inputBuf.capacity() + 1;
        try (ChunkedBytesStream is = new ChunkedBytesStream((InputStream)new ByteBufferInputStream(inputBuf), this.supplier, 10, false);){
            int cnt = 0;
            while (cnt++ < lengthGreaterThanInput) {
                int res = is.read();
                if (cnt <= inputBuf.capacity()) continue;
                Assertions.assertEquals((int)-1, (int)res, (String)"end of file for read should be -1");
            }
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testEndOfSourceForMethodSkip(boolean pushSkipToSourceStream) throws IOException {
        ByteBuffer inputBuf = ByteBuffer.allocate(16);
        RANDOM.nextBytes(inputBuf.array());
        inputBuf.rewind();
        InputStream sourcestream = (InputStream)Mockito.spy((Object)new ByteBufferInputStream(inputBuf));
        try (ChunkedBytesStream is = new ChunkedBytesStream(sourcestream, this.supplier, 10, pushSkipToSourceStream);){
            long res = is.skip(inputBuf.capacity() + 1);
            Assertions.assertEquals((long)inputBuf.capacity(), (long)res);
        }
    }

    @ParameterizedTest
    @MethodSource(value={"provideSourceSkipValuesForTest"})
    public void testCorrectnessForMethodSkip(int bytesToPreRead, ByteBuffer inputBuf, int numBytesToSkip, boolean pushSkipToSourceStream) throws IOException {
        int expectedInpLeftAfterSkip = inputBuf.remaining() - bytesToPreRead - numBytesToSkip;
        int expectedSkippedBytes = Math.min(inputBuf.remaining() - bytesToPreRead, numBytesToSkip);
        try (ChunkedBytesStream is = new ChunkedBytesStream((InputStream)new ByteBufferInputStream(inputBuf.duplicate()), this.supplier, 10, pushSkipToSourceStream);){
            int cnt = 0;
            while (cnt++ < bytesToPreRead) {
                int r = is.read();
                Assertions.assertNotEquals((int)-1, (int)r, (String)"Unexpected end of data.");
            }
            long res = is.skip(numBytesToSkip);
            Assertions.assertEquals((long)expectedSkippedBytes, (long)res);
            cnt = 0;
            while (cnt++ < expectedInpLeftAfterSkip) {
                int readRes = is.read();
                Assertions.assertNotEquals((int)-1, (int)readRes, (String)"Unexpected end of data.");
            }
        }
    }

    @ParameterizedTest
    @MethodSource(value={"provideEdgeCaseInputForMethodSkip"})
    public void testEdgeCaseInputForMethodSkip(int bufferLength, long toSkip, boolean delegateSkipToSourceStream, long expected) throws IOException {
        ByteBuffer inputBuf = ByteBuffer.allocate(bufferLength);
        RANDOM.nextBytes(inputBuf.array());
        inputBuf.rewind();
        try (ChunkedBytesStream is = new ChunkedBytesStream((InputStream)new ByteBufferInputStream(inputBuf.duplicate()), this.supplier, 10, delegateSkipToSourceStream);){
            Assertions.assertEquals((long)expected, (long)is.skip(toSkip));
        }
    }

    private static Stream<Arguments> provideEdgeCaseInputForMethodSkip() {
        int bufferLength = 16;
        return Stream.of(Arguments.of((Object[])new Object[]{bufferLength, 0x80000000L, true, bufferLength}), Arguments.of((Object[])new Object[]{bufferLength, -1, true, 0}), Arguments.of((Object[])new Object[]{bufferLength, 0x80000000L, false, bufferLength}), Arguments.of((Object[])new Object[]{bufferLength, -1, false, 0}));
    }

    private static Stream<Arguments> provideCasesWithInvalidInputsForMethodRead() {
        byte[] b = new byte[16];
        return Stream.of(Arguments.of((Object[])new Object[]{b, -1, b.length}), Arguments.of((Object[])new Object[]{b, 0, -1}), Arguments.of((Object[])new Object[]{b, Integer.MAX_VALUE, 10}), Arguments.of((Object[])new Object[]{b, 0, b.length + 1}), Arguments.of((Object[])new Object[]{b, b.length - 1, 2}));
    }

    private static List<Arguments> provideSourceSkipValuesForTest() {
        ByteBuffer bufGreaterThanIntermediateBuf = ByteBuffer.allocate(16);
        RANDOM.nextBytes(bufGreaterThanIntermediateBuf.array());
        bufGreaterThanIntermediateBuf.position(bufGreaterThanIntermediateBuf.capacity());
        bufGreaterThanIntermediateBuf.flip();
        ByteBuffer bufMuchGreaterThanIntermediateBuf = ByteBuffer.allocate(100);
        RANDOM.nextBytes(bufMuchGreaterThanIntermediateBuf.array());
        bufMuchGreaterThanIntermediateBuf.position(bufMuchGreaterThanIntermediateBuf.capacity());
        bufMuchGreaterThanIntermediateBuf.flip();
        ByteBuffer emptyBuffer = ByteBuffer.allocate(2);
        ByteBuffer oneByteBuf = ByteBuffer.allocate(1).put((byte)1);
        oneByteBuf.flip();
        List<List> testInputs = Arrays.asList(Arrays.asList(0, emptyBuffer, 0), Arrays.asList(0, emptyBuffer, 1), Arrays.asList(1, emptyBuffer, 1), Arrays.asList(1, emptyBuffer, 0), Arrays.asList(0, oneByteBuf, 0), Arrays.asList(0, oneByteBuf, 1), Arrays.asList(1, oneByteBuf, 0), Arrays.asList(1, oneByteBuf, 1), Arrays.asList(0, bufGreaterThanIntermediateBuf.duplicate(), bufGreaterThanIntermediateBuf.capacity()), Arrays.asList(bufGreaterThanIntermediateBuf.capacity(), bufGreaterThanIntermediateBuf.duplicate(), 0), Arrays.asList(2, bufGreaterThanIntermediateBuf.duplicate(), 10), Arrays.asList(2, bufGreaterThanIntermediateBuf.duplicate(), 8));
        Boolean[] tailArgs = new Boolean[]{true, false};
        ArrayList<Arguments> finalArguments = new ArrayList<Arguments>(2 * testInputs.size());
        for (List args : testInputs) {
            for (Boolean aBoolean : tailArgs) {
                ArrayList<Boolean> expandedArgs = new ArrayList<Boolean>(args);
                expandedArgs.add(aBoolean);
                finalArguments.add(Arguments.of((Object[])expandedArgs.toArray()));
            }
        }
        return finalArguments;
    }

    private static Stream<Arguments> provideSourceBytebuffersForTest() {
        ByteBuffer bufGreaterThanIntermediateBuf = ByteBuffer.allocate(16);
        RANDOM.nextBytes(bufGreaterThanIntermediateBuf.array());
        bufGreaterThanIntermediateBuf.position(bufGreaterThanIntermediateBuf.capacity());
        ByteBuffer bufMuchGreaterThanIntermediateBuf = ByteBuffer.allocate(100);
        RANDOM.nextBytes(bufMuchGreaterThanIntermediateBuf.array());
        bufMuchGreaterThanIntermediateBuf.position(bufMuchGreaterThanIntermediateBuf.capacity());
        return Stream.of(Arguments.of((Object[])new Object[]{ByteBuffer.allocate(2)}), Arguments.of((Object[])new Object[]{ByteBuffer.allocate(1).put((byte)1).flip()}), Arguments.of((Object[])new Object[]{ByteBuffer.allocate(8).put("12345678".getBytes()).flip()}), Arguments.of((Object[])new Object[]{bufGreaterThanIntermediateBuf.flip()}), Arguments.of((Object[])new Object[]{bufMuchGreaterThanIntermediateBuf.flip()}));
    }

    private static /* synthetic */ void lambda$testInvalidInputsForMethodRead$0(InputStream is, byte[] b, int off, int len) throws Throwable {
        is.read(b, off, len);
    }
}

