/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.config.internals;

import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.kafka.clients.admin.AdminClientConfig;
import org.apache.kafka.clients.consumer.ConsumerConfig;
import org.apache.kafka.clients.producer.ProducerConfig;
import org.apache.kafka.common.Configurable;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.Mode;
import org.apache.kafka.common.requests.SamplingRequestLogFilter;
import org.apache.kafka.common.security.JaasContext;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.interceptor.BrokerInterceptor;
import org.apache.kafka.server.interceptor.DefaultBrokerInterceptor;
import org.apache.kafka.server.license.LicenseValidator;
import org.apache.kafka.server.multitenant.MultiTenantMetadata;

public class ConfluentConfigs {
    private static final String CONFLUENT_PREFIX = "confluent.";
    public static final String BROKER_INTERCEPTOR_CLASS_CONFIG = "broker.interceptor.class";
    public static final Class<?> BROKER_INTERCEPTOR_CLASS_DEFAULT = DefaultBrokerInterceptor.class;
    public static final String MULTITENANT_METADATA_CLASS_CONFIG = "multitenant.metadata.class";
    public static final String MULTITENANT_METADATA_CLASS_DEFAULT = null;
    public static final String MULTITENANT_METADATA_DIR_CONFIG = "multitenant.metadata.dir";
    public static final String MULTITENANT_METADATA_DIR_DEFAULT = null;
    public static final String MULTITENANT_METADATA_SSL_CERTS_SPEC_CONFIG = "multitenant.metadata.ssl.certs.path";
    public static final String MULTITENANT_METADATA_SSL_CERTS_SPEC_DEFAULT = null;
    public static final String MULTITENANT_METADATA_RELOAD_DELAY_MS_CONFIG = "multitenant.metadata.reload.delay.ms";
    public static final Long MULTITENANT_METADATA_RELOAD_DELAY_MS_DEFAULT = TimeUnit.MINUTES.toMillis(10L);
    public static final String MULTITENANT_METADATA_RELOAD_DELAY_MS_DOC = "Interval (in ms) between full reloads of logical cluster metadata. Defaults to 10 minutes.";
    public static final String MULTITENANT_TENANT_DELETE_DELAY_MS_CONFIG = "multitenant.tenant.delete.delay";
    public static final Long MULTITENANT_TENANT_DELETE_DELAY_MS_DEFAULT = TimeUnit.DAYS.toMillis(7L);
    public static final String MULTITENANT_TENANT_DELETE_DELAY_MS_DOC = "Delay between the time the tenant is marked as deactivated in JSON file, until we actually start deleting topics. This defaults to 7 days to allow plenty of times for operators and users to regret their decisions and do something about it";
    public static final String MULTITENANT_TENANT_DELETE_BATCH_SIZE_CONFIG = "multitenant.tenant.delete.batch.size";
    public static final Integer MULTITENANT_TENANT_DELETE_BATCH_SIZE_DEFAULT = 10;
    public static final String MULTITENANT_TENANT_DELETE_BATCH_SIZE_DOC = "Batch size for topic deletion of deactivated tenants. We wait for each batch to complete before sending another";
    private static final String SCHEMA_REGISTRY_URL = "schema.registry.url";
    private static final String KEY_SUBJECT_NAME_STRATEGY = "key.subject.name.strategy";
    private static final String VALUE_SUBJECT_NAME_STRATEGY = "value.subject.name.strategy";
    public static final String SCHEMA_REGISTRY_URL_CONFIG = "confluent.schema.registry.url";
    public static final String SCHEMA_REGISTRY_URL_DOC = "Comma-separated list of URLs for schema registry instances that can be used to look up schemas.";
    public static final String KEY_SUBJECT_NAME_STRATEGY_CONFIG = "confluent.key.subject.name.strategy";
    public static final String KEY_SUBJECT_NAME_STRATEGY_DOC = "Determines how to construct the subject name under which the key schema is registered with the schema registry. By default, <topic>-key is used as subject.";
    public static final String VALUE_SUBJECT_NAME_STRATEGY_CONFIG = "confluent.value.subject.name.strategy";
    public static final String VALUE_SUBJECT_NAME_STRATEGY_DOC = "Determines how to construct the subject name under which the value schema is registered with the schema registry. By default, <topic>-value is used as subject.";
    public static final String MAX_CACHE_SIZE_CONFIG = "confluent.schema.registry.max.cache.size";
    public static final String MAX_CACHE_SIZE_DOC = "Maximum size of each LRU cache used to cache responses from the schema registry. There is one cache to hold the ID to schema mappings and another to hold the schemas that are registered to a subject.";
    public static final int MAX_CACHE_SIZE_DEFAULT = 10000;
    public static final String MAX_RETRIES_CONFIG = "confluent.schema.registry.max.retries";
    public static final String MAX_RETRIES_DOC = "Maximum number of times to retry schema registry read operations.";
    public static final int MAX_RETRIES_DEFAULT = 1;
    public static final String RETRIES_WAIT_MS_CONFIG = "confluent.schema.registry.retries.wait.ms";
    public static final String RETRIES_WAIT_MS_DOC = "Time in milliseconds to wait before each retry.";
    public static final int RETRIES_WAIT_MS_DEFAULT = 0;
    public static final String MISSING_ID_QUERY_RANGE_CONFIG = "confluent.missing.id.query.range";
    public static final String MISSING_ID_QUERY_RANGE_DOC = "The range above max schema ID to make calls to Schema Registry";
    public static final int MISSING_ID_QUERY_RANGE_DEFAULT = 200;
    public static final String MISSING_ID_CACHE_TTL_CONFIG = "confluent.missing.id.cache.ttl.sec";
    public static final String MISSING_ID_CACHE_TTL_DOC = "The TTL in seconds for caching missing schema IDs";
    public static final long MISSING_ID_CACHE_TTL_DEFAULT = 60L;
    public static final String MISSING_SCHEMA_CACHE_TTL_CONFIG = "confluent.missing.schema.cache.ttl.sec";
    public static final String MISSING_SCHEMA_CACHE_TTL_DOC = "The TTL in seconds for caching missing schemas";
    public static final long MISSING_SCHEMA_CACHE_TTL_DEFAULT = 60L;
    public static final String BASIC_AUTH_CREDENTIALS_SOURCE_CONFIG = "confluent.basic.auth.credentials.source";
    public static final String BASIC_AUTH_CREDENTIALS_SOURCE_DEFAULT = null;
    public static final String BASIC_AUTH_CREDENTIALS_SOURCE_DOC = "Specify how to pick the credentials for Basic Auth header. The supported values are URL, USER_INFO and SASL_INHERIT";
    public static final String USER_INFO_CONFIG = "confluent.basic.auth.user.info";
    public static final String USER_INFO_DEFAULT = null;
    public static final String USER_INFO_DOC = "Specify the user info for Basic Auth in the form of {username}:{password}";
    public static final String BEARER_AUTH_CREDENTIALS_SOURCE_CONFIG = "confluent.bearer.auth.credentials.source";
    public static final String BEARER_AUTH_CREDENTIALS_SOURCE_DEFAULT = null;
    public static final String BEARER_AUTH_CREDENTIALS_SOURCE_DOC = "Specify how to pick the credentials for Bearer Auth header. ";
    public static final String BEARER_AUTH_TOKEN_CONFIG = "confluent.bearer.auth.token";
    public static final String BEARER_AUTH_TOKEN_DEFAULT = null;
    public static final String BEARER_AUTH_TOKEN_DOC = "Specify the Bearer token to be used for authentication";
    public static final String SSL_PROTOCOL_CONFIG = "confluent.ssl.protocol";
    public static final String SSL_PROTOCOL_DOC = "The SSL protocol used to generate the SSLContext. Default setting is TLSv1.2, which is fine for most cases. Allowed values in recent JVMs are TLSv1.2 and TLSv1.3. TLS, TLSv1.1, SSL, SSLv2 and SSLv3 may be supported in older JVMs, but their usage is discouraged due to known security vulnerabilities.";
    public static final String SSL_KEYSTORE_TYPE_CONFIG = "confluent.ssl.keystore.type";
    public static final String SSL_KEYSTORE_TYPE_DOC = "The file format of the key store file. This is optional for client.";
    public static final String SSL_KEYSTORE_LOCATION_CONFIG = "confluent.ssl.keystore.location";
    public static final String SSL_KEYSTORE_LOCATION_DOC = "The location of the key store file. This is optional for client and can be used for two-way authentication for client.";
    public static final String SSL_KEYSTORE_PASSWORD_CONFIG = "confluent.ssl.keystore.password";
    public static final String SSL_KEYSTORE_PASSWORD_DOC = "The store password for the key store file. This is optional for client and only needed if ssl.keystore.location is configured. ";
    public static final String SSL_KEY_PASSWORD_CONFIG = "confluent.ssl.key.password";
    public static final String SSL_KEY_PASSWORD_DOC = "The password of the private key in the key store file. This is optional for client.";
    public static final String SSL_TRUSTSTORE_TYPE_CONFIG = "confluent.ssl.truststore.type";
    public static final String SSL_TRUSTSTORE_TYPE_DOC = "The file format of the trust store file.";
    public static final String SSL_TRUSTSTORE_LOCATION_CONFIG = "confluent.ssl.truststore.location";
    public static final String SSL_TRUSTSTORE_LOCATION_DOC = "The location of the trust store file. ";
    public static final String SSL_TRUSTSTORE_PASSWORD_CONFIG = "confluent.ssl.truststore.password";
    public static final String SSL_TRUSTSTORE_PASSWORD_DOC = "The password for the trust store file. If a password is not set access to the truststore is still available, but integrity checking is disabled.";
    public static final String TENANT_QUOTA_CALLBACK_CLASS = "io.confluent.kafka.multitenant.quota.TenantQuotaCallback";
    public static final String BACKPRESSURE_TYPES_CONFIG = "confluent.backpressure.types";
    public static final String BACKPRESSURE_TYPES_DEFAULT = null;
    public static final String BACKPRESSURE_TYPES_DOC = "Comma separated list of resource types for which broker back-pressure is enabled. Backpressure is not enabled by default. Accepted values: 'request', 'produce', 'fetch'.Invalid values are ignored. This config is ignored if client.quota.callback.class is not set, or set to class other than TenantQuotaCallback. In other words, broker back-pressure can be enabled for multi-tenant clusters only.";
    public static final String MULTITENANT_LISTENER_NAMES_CONFIG = "confluent.multitenant.listener.names";
    public static final String MULTITENANT_LISTENER_NAMES_DEFAULT = null;
    public static final String MULTITENANT_LISTENER_NAMES_DOC = "Comma separated list of listener names used for communications with tenants. If this is unset, broker request (time on network and IO threads) backpressure will not be applied.";
    public static final String REQUEST_LOG_FILTER_CLASS_CONFIG = "confluent.request.log.filter.class";
    public static final String REQUEST_LOG_FILTER_DEFAULT = SamplingRequestLogFilter.class.getName();
    public static final String REQUEST_LOG_FILTER_CLASS_DOC = "Class of request log filter which can be used to select a subset of requests for logging. Every request handler thread will get a separate instance of this class and is only consulted if the request log level is set to INFO or higher.";
    public static final String APPLY_CREATE_TOPIC_POLICY_TO_CREATE_PARTITIONS = "confluent.apply.create.topic.policy.to.create.partitions";
    public static final boolean APPLY_CREATE_TOPIC_POLICY_TO_CREATE_PARTITIONS_DEFAULT = false;
    public static final String APPLY_CREATE_TOPIC_POLICY_TO_CREATE_PARTITIONS_DOC = "If this is set, CreateTopicsPolicy will also apply to CreatePartitions.";
    public static final String VERIFY_GROUP_SUBSCRIPTION_PREFIX = "confluent.verify.group.subscription.prefix";
    public static final boolean VERIFY_GROUP_SUBSCRIPTION_PREFIX_DEFAULT = false;
    public static final String VERIFY_GROUP_SUBSCRIPTION_PREFIX_DOC = "If this is set, the group coordinator will verify that the subscriptions are prefixed with the tenant.";

    public static BrokerInterceptor buildBrokerInterceptor(Mode mode, Map<String, ?> configs) {
        if (mode == Mode.CLIENT) {
            return null;
        }
        BrokerInterceptor interceptor = new DefaultBrokerInterceptor();
        if (configs.containsKey(BROKER_INTERCEPTOR_CLASS_CONFIG)) {
            Class interceptorClass = (Class)configs.get(BROKER_INTERCEPTOR_CLASS_CONFIG);
            interceptor = (BrokerInterceptor)Utils.newInstance(interceptorClass);
        }
        interceptor.configure(configs);
        return interceptor;
    }

    public static MultiTenantMetadata buildMultitenantMetadata(Map<String, ?> configs) {
        MultiTenantMetadata meta = null;
        if (configs.get(MULTITENANT_METADATA_CLASS_CONFIG) != null) {
            Class multitenantMetadataClass = (Class)configs.get(MULTITENANT_METADATA_CLASS_CONFIG);
            meta = (MultiTenantMetadata)Utils.newInstance(multitenantMetadataClass);
            meta.configure(configs);
        }
        return meta;
    }

    public static LicenseValidator buildLicenseValidator(AbstractConfig config, Endpoint interBrokerEndpoint) {
        Configurable licenseValidator = null;
        ServiceLoader<LicenseValidator> validators = ServiceLoader.load(LicenseValidator.class);
        for (LicenseValidator validator : validators) {
            if (!validator.enabled()) continue;
            licenseValidator = validator;
            break;
        }
        if (licenseValidator == null) {
            throw new IllegalStateException("License validator not found");
        }
        licenseValidator.configure(ConfluentConfigs.interBrokerClientConfigs(config, interBrokerEndpoint));
        return licenseValidator;
    }

    public static Map<String, Object> interBrokerClientConfigs(AbstractConfig brokerConfig, Endpoint interBrokerEndpoint) {
        Map<String, Object> configs = brokerConfig.originals();
        HashMap<String, Object> clientConfigs = new HashMap<String, Object>(configs);
        Set<String> brokerConfigNames = brokerConfig.values().keySet();
        clientConfigs.keySet().removeIf(n -> brokerConfigNames.contains(n) && !AdminClientConfig.configNames().contains(n) || n.startsWith("listener.name."));
        ListenerName listenerName = new ListenerName(interBrokerEndpoint.listenerName().get());
        String listenerPrefix = listenerName.configPrefix();
        SecurityProtocol securityProtocol = interBrokerEndpoint.securityProtocol();
        if (securityProtocol == SecurityProtocol.SASL_PLAINTEXT || securityProtocol == SecurityProtocol.SASL_SSL) {
            String saslMechanism = (String)brokerConfig.originals().get("sasl.mechanism.inter.broker.protocol");
            saslMechanism = saslMechanism != null ? saslMechanism : "GSSAPI";
            clientConfigs.put("sasl.mechanism", saslMechanism);
            String mechanismPrefix = listenerName.saslMechanismConfigPrefix(saslMechanism);
            ConfluentConfigs.updatePrefixedConfigs(configs, clientConfigs, mechanismPrefix);
            if (!clientConfigs.containsKey("sasl.jaas.config")) {
                String jaasConfig = JaasContext.listenerSaslJaasConfig(listenerName, saslMechanism);
                clientConfigs.put("sasl.jaas.config", jaasConfig);
            }
        }
        ConfluentConfigs.updatePrefixedConfigs(configs, clientConfigs, listenerPrefix);
        clientConfigs.put("bootstrap.servers", interBrokerEndpoint.host() + ":" + interBrokerEndpoint.port());
        clientConfigs.put("security.protocol", securityProtocol.name);
        return clientConfigs;
    }

    public static Map<String, Object> clientConfigs(AbstractConfig config, String configPrefix, ClientType clientType, String topicPrefix, String componentId) {
        Map<String, Object> srcConfigs = config.originals();
        srcConfigs.keySet().removeAll(config.values().keySet());
        HashMap<String, Object> clientConfigs = new HashMap<String, Object>(srcConfigs);
        clientConfigs.remove("metric.reporters");
        clientConfigs.put("client.id", String.format("%s-%s-%s", topicPrefix, clientType.type, componentId));
        ConfluentConfigs.updatePrefixedConfigs(srcConfigs, clientConfigs, configPrefix + clientType.type + ".");
        ConfluentConfigs.updatePrefixedConfigs(srcConfigs, clientConfigs, configPrefix);
        return clientConfigs;
    }

    private static void updatePrefixedConfigs(Map<String, Object> configs, Map<String, Object> dstConfigs, String prefix) {
        Set<String> prefixed = configs.keySet().stream().filter(n -> n.startsWith(prefix)).collect(Collectors.toSet());
        prefixed.forEach(name -> {
            dstConfigs.remove(name);
            dstConfigs.put(name.substring(prefix.length()), configs.get(name));
        });
        configs.keySet().removeAll(prefixed);
    }

    public static enum ClientType {
        PRODUCER("producer", ProducerConfig.configNames()),
        CONSUMER("consumer", ConsumerConfig.configNames()),
        ADMIN("admin", AdminClientConfig.configNames()),
        COORDINATOR("coordinator", ConsumerConfig.configNames());

        final String type;
        final Set<String> configNames;

        private ClientType(String type, Set<String> configNames) {
            this.type = type;
            this.configNames = configNames;
        }
    }
}

