/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.CreateAclsRequestData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.requests.CreateAclsResponse;
import org.apache.kafka.common.requests.RequestUtils;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.utils.Utils;

public class CreateAclsRequest
extends AbstractRequest {
    private final List<AclCreation> aclCreations;
    private final CreateAclsRequestData data;

    CreateAclsRequest(short version, List<AclCreation> aclCreations) {
        super(ApiKeys.CREATE_ACLS, version);
        this.aclCreations = aclCreations;
        this.data = CreateAclsRequest.createAclsRequestData(aclCreations);
        this.validate(aclCreations);
    }

    private CreateAclsRequest(short version, CreateAclsRequestData data) {
        super(ApiKeys.CREATE_ACLS, version);
        this.data = data;
        this.aclCreations = new ArrayList<AclCreation>(data.creations().size());
        for (CreateAclsRequestData.CreatableAcl creation : data.creations()) {
            ResourcePattern pattern = new ResourcePattern(ResourceType.fromCode(creation.resourceType()), creation.resourceName(), PatternType.fromCode(creation.resourcePatternType()));
            AccessControlEntry entry = new AccessControlEntry(creation.principal(), creation.host(), AclOperation.fromCode(creation.operation()), AclPermissionType.fromCode(creation.permissionType()));
            this.aclCreations.add(new AclCreation(new AclBinding(pattern, entry)));
        }
    }

    public CreateAclsRequest(Struct struct, short version) {
        this(version, new CreateAclsRequestData(struct, version));
    }

    @Override
    protected Struct toStruct() {
        return this.data.toStruct(this.version());
    }

    public List<AclCreation> aclCreations() {
        return this.aclCreations;
    }

    public Optional<String> clusterId() {
        String clusterId = this.data.clusterId();
        return clusterId == null || clusterId.isEmpty() ? Optional.empty() : Optional.of(clusterId);
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable throwable) {
        short versionId = this.version();
        switch (versionId) {
            case 0: 
            case 1: 
            case 2: {
                ArrayList<CreateAclsResponse.AclCreationResponse> responses = new ArrayList<CreateAclsResponse.AclCreationResponse>();
                for (int i = 0; i < this.aclCreations.size(); ++i) {
                    responses.add(new CreateAclsResponse.AclCreationResponse(ApiError.fromThrowable(throwable)));
                }
                return new CreateAclsResponse(throttleTimeMs, responses);
            }
        }
        throw new IllegalArgumentException(String.format("Version %d is not valid. Valid versions for %s are 0 to %d", versionId, this.getClass().getSimpleName(), ApiKeys.CREATE_ACLS.latestVersion()));
    }

    public static CreateAclsRequest parse(ByteBuffer buffer, short version) {
        return new CreateAclsRequest(ApiKeys.CREATE_ACLS.parseRequest(version, buffer), version);
    }

    private void validate(List<AclCreation> aclCreations) {
        boolean unsupported;
        if (this.version() == 0 && (unsupported = aclCreations.stream().map(AclCreation::acl).map(AclBinding::pattern).map(ResourcePattern::patternType).anyMatch(patternType -> patternType != PatternType.LITERAL))) {
            throw new UnsupportedVersionException("Version 0 only supports literal resource pattern types");
        }
        boolean unknown = aclCreations.stream().map(AclCreation::acl).anyMatch(AclBinding::isUnknown);
        if (unknown) {
            throw new IllegalArgumentException("You can not create ACL bindings with unknown elements");
        }
    }

    private static CreateAclsRequestData createAclsRequestData(List<AclCreation> aclCreations) {
        CreateAclsRequestData data = new CreateAclsRequestData();
        for (AclCreation creation : aclCreations) {
            data.creations().add(new CreateAclsRequestData.CreatableAcl().setHost(creation.acl().entry().host()).setOperation(creation.acl.entry().operation().code()).setPermissionType(creation.acl.entry().permissionType().code()).setPrincipal(creation.acl.entry().principal()).setResourceName(creation.acl.pattern().name()).setResourceType(creation.acl.pattern().resourceType().code()).setResourcePatternType(creation.acl.pattern().patternType().code()));
        }
        return data;
    }

    public static class Builder
    extends AbstractRequest.Builder<CreateAclsRequest> {
        private final CreateAclsRequestData data;

        public Builder(List<AclCreation> creations) {
            this(CreateAclsRequest.createAclsRequestData(creations));
        }

        public Builder(CreateAclsRequestData data) {
            super(ApiKeys.CREATE_ACLS);
            this.data = data;
        }

        public Builder setClusterId(String clusterId) {
            this.data.setClusterId(clusterId);
            return this;
        }

        @Override
        public CreateAclsRequest build(short version) {
            return new CreateAclsRequest(version, this.data);
        }

        public String toString() {
            return "(type=CreateAclsRequest, creations=" + Utils.join(this.data.creations(), ", ") + ")";
        }
    }

    public static class AclCreation {
        private final AclBinding acl;

        public AclCreation(AclBinding acl) {
            this.acl = acl;
        }

        static AclCreation fromStruct(Struct struct) {
            ResourcePattern pattern = RequestUtils.resourcePatternromStructFields(struct);
            AccessControlEntry entry = RequestUtils.aceFromStructFields(struct);
            return new AclCreation(new AclBinding(pattern, entry));
        }

        public AclBinding acl() {
            return this.acl;
        }

        void setStructFields(Struct struct) {
            RequestUtils.resourcePatternSetStructFields(this.acl.pattern(), struct);
            RequestUtils.aceSetStructFields(this.acl.entry(), struct);
        }

        public String toString() {
            return "(acl=" + this.acl + ")";
        }
    }
}

