/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.kafka.common.message.ConfluentLeaderAndIsrResponseData;
import org.apache.kafka.common.message.LeaderAndIsrResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.AbstractResponse;

public class LeaderAndIsrResponse
extends AbstractResponse {
    private final Message data;

    public LeaderAndIsrResponse(LeaderAndIsrResponseData data, boolean useConfluentResponse) {
        this.data = useConfluentResponse ? new ConfluentLeaderAndIsrResponseData().setErrorCode(data.errorCode()).setPartitionErrors(data.partitionErrors().stream().map(pe -> new ConfluentLeaderAndIsrResponseData.LeaderAndIsrPartitionError().setTopicName(pe.topicName()).setPartitionIndex(pe.partitionIndex()).setErrorCode(pe.errorCode())).collect(Collectors.toList())) : data;
    }

    public LeaderAndIsrResponse(Struct struct, short version, boolean useConfluentResponse) {
        this.data = useConfluentResponse ? new ConfluentLeaderAndIsrResponseData(struct, version) : new LeaderAndIsrResponseData(struct, version);
    }

    public List<LeaderAndIsrResponseData.LeaderAndIsrPartitionError> partitions() {
        if (this.data instanceof ConfluentLeaderAndIsrResponseData) {
            return ((ConfluentLeaderAndIsrResponseData)this.data).partitionErrors().stream().map(pe -> new LeaderAndIsrResponseData.LeaderAndIsrPartitionError().setErrorCode(pe.errorCode()).setTopicName(pe.topicName()).setPartitionIndex(pe.partitionIndex())).collect(Collectors.toList());
        }
        return ((LeaderAndIsrResponseData)this.data).partitionErrors();
    }

    public Errors error() {
        if (this.data instanceof ConfluentLeaderAndIsrResponseData) {
            return Errors.forCode(((ConfluentLeaderAndIsrResponseData)this.data).errorCode());
        }
        return Errors.forCode(((LeaderAndIsrResponseData)this.data).errorCode());
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        Errors error = this.error();
        if (error != Errors.NONE) {
            return Collections.singletonMap(error, this.partitions().size());
        }
        return this.errorCounts(this.partitions().stream().map(l -> Errors.forCode(l.errorCode())).collect(Collectors.toList()));
    }

    public static LeaderAndIsrResponse parse(ByteBuffer buffer, short version) {
        return new LeaderAndIsrResponse(ApiKeys.LEADER_AND_ISR.parseResponse(version, buffer), version, false);
    }

    @Override
    protected Struct toStruct(short version) {
        return this.data.toStruct(version);
    }

    public String toString() {
        return this.data.toString();
    }
}

