/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.http;

import java.util.ArrayList;
import java.util.Map;
import java.util.ServiceLoader;
import org.apache.kafka.common.ClusterResource;
import org.apache.kafka.common.ClusterResourceListener;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.server.http.MetadataServer;
import org.apache.kafka.server.http.MetadataServerConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MetadataServerFactory {
    protected static final Logger log = LoggerFactory.getLogger(MetadataServerFactory.class);

    public static MetadataServer create(String clusterId, Map<String, ?> configurations) {
        MetadataServerConfig metadataServerConfig = new MetadataServerConfig(configurations);
        if (!metadataServerConfig.isServerEnabled()) {
            log.info("MetadataServer is disabled on this broker");
            return MetadataServerFactory.none();
        }
        ServiceLoader<MetadataServer> serviceLoader = ServiceLoader.load(MetadataServer.class);
        ArrayList<MetadataServer> implementations = new ArrayList<MetadataServer>();
        for (MetadataServer implementation : serviceLoader) {
            if (!implementation.providerConfigured(configurations)) continue;
            implementations.add(implementation);
        }
        if (implementations.isEmpty()) {
            log.warn("Could not find suitable MetadataServer implementation.");
            return MetadataServerFactory.none();
        }
        if (implementations.size() > 1) {
            throw new ConfigException(String.format("Found multiple MetadataServer implementations : %s.", implementations));
        }
        MetadataServer metadataServer = (MetadataServer)implementations.get(0);
        if (metadataServer instanceof ClusterResourceListener) {
            ((ClusterResourceListener)((Object)metadataServer)).onUpdate(new ClusterResource(clusterId));
        }
        metadataServer.configure(metadataServerConfig.serverConfigs());
        return metadataServer;
    }

    public static MetadataServer none() {
        return NoneMetadataServer.INSTANCE;
    }

    private static class NoneMetadataServer
    implements MetadataServer {
        private static final NoneMetadataServer INSTANCE = new NoneMetadataServer();

        private NoneMetadataServer() {
        }

        @Override
        public void configure(Map<String, ?> configs) {
        }

        @Override
        public boolean providerConfigured(Map<String, ?> configs) {
            return true;
        }

        @Override
        public void registerMetadataProvider(String providerName, MetadataServer.Injector injector) {
        }

        @Override
        public void start() {
        }

        @Override
        public void close() {
        }
    }
}

