/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.time.Duration;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestLogFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SamplingRequestLogFilter
implements RequestLogFilter {
    private static final Logger log = LoggerFactory.getLogger(SamplingRequestLogFilter.class);
    public static final String DEFAULT_SAMPLES_PER_MIN = "confluent.request.log.samples.per.min";
    public static final String OVERRIDE_API_SAMPLES_PER_MIN = "confluent.request.log.api.samples.per.min";
    private static final Set<String> RECONFIGURABLE_CONFIGS = new HashSet<String>();
    private volatile TimeBasedSampler defaultSampler = null;
    private volatile EnumMap<ApiKeys, TimeBasedSampler> apiSamplers = new EnumMap(ApiKeys.class);

    @Override
    public boolean shouldLogRequest(RequestContext ctx, long requestTimeNanos) {
        TimeBasedSampler apiSampler = this.apiSamplers.get((Object)ctx.header.apiKey());
        if (apiSampler != null) {
            return apiSampler.maybeSample(requestTimeNanos);
        }
        if (this.defaultSampler != null) {
            return this.defaultSampler.maybeSample(requestTimeNanos);
        }
        return false;
    }

    @Override
    public Set<String> reconfigurableConfigs() {
        return RECONFIGURABLE_CONFIGS;
    }

    @Override
    public void reconfigure(Map<String, ?> configs) {
        this.configure(configs);
    }

    @Override
    public void configure(Map<String, ?> configs) {
        log.debug("Received configuration: {}", configs);
        this.defaultSampler = this.maybeParseDefaultSampler(configs).orElse(null);
        this.apiSamplers = this.parseApiSamplers(configs);
    }

    @Override
    public void validateReconfiguration(Map<String, ?> configs) throws ConfigException {
        this.maybeParseDefaultSampler(configs);
        this.parseApiSamplers(configs);
    }

    private EnumMap<ApiKeys, TimeBasedSampler> parseApiSamplers(Map<String, ?> configs) {
        EnumMap<ApiKeys, TimeBasedSampler> apiIntervals = new EnumMap<ApiKeys, TimeBasedSampler>(ApiKeys.class);
        Object configValue = configs.get(OVERRIDE_API_SAMPLES_PER_MIN);
        if (configValue == null) {
            return apiIntervals;
        }
        if (!(configValue instanceof String)) {
            throw new ConfigException("Invalid value `" + configValue + "` found for " + OVERRIDE_API_SAMPLES_PER_MIN + " (should be a string)");
        }
        String apiSampleRates = (String)configValue;
        for (String apiSamplePairString : apiSampleRates.split(",")) {
            String[] apiSamplePair = apiSamplePairString.split("=");
            if (apiSamplePair.length != 2) {
                throw new ConfigException("Invalid value `" + apiSamplePairString + "` found in " + OVERRIDE_API_SAMPLES_PER_MIN + "=`" + configValue + "`");
            }
            ApiKeys apiKey = ApiKeys.findByName(apiSamplePair[0]);
            if (apiKey == null) {
                throw new ConfigException("Invalid value `" + apiSamplePair[0] + "` found in " + OVERRIDE_API_SAMPLES_PER_MIN + "=`" + configValue + "`");
            }
            try {
                long samplesPerMin = Long.valueOf(apiSamplePair[1]);
                apiIntervals.put(apiKey, SamplingRequestLogFilter.perMinuteSampler(samplesPerMin));
            }
            catch (NumberFormatException e) {
                throw new ConfigException("Invalid value `" + apiSamplePair[1] + "` found in " + OVERRIDE_API_SAMPLES_PER_MIN + "=`" + configValue + "`");
            }
        }
        return apiIntervals;
    }

    private Optional<TimeBasedSampler> maybeParseDefaultSampler(Map<String, ?> configs) {
        Object samplesPerMin = configs.get(DEFAULT_SAMPLES_PER_MIN);
        if (samplesPerMin == null) {
            return Optional.empty();
        }
        if (samplesPerMin instanceof Number) {
            return Optional.of(SamplingRequestLogFilter.perMinuteSampler(((Number)samplesPerMin).longValue()));
        }
        if (samplesPerMin instanceof String) {
            try {
                String samplesPerMinString = (String)samplesPerMin;
                if (samplesPerMinString.isEmpty()) {
                    return Optional.empty();
                }
                return Optional.of(SamplingRequestLogFilter.perMinuteSampler(Long.valueOf(samplesPerMinString)));
            }
            catch (NumberFormatException e) {
                throw new ConfigException("Invalid value `" + samplesPerMin + "` found in " + OVERRIDE_API_SAMPLES_PER_MIN);
            }
        }
        throw new ConfigException("Invalid default interval value `" + samplesPerMin + "`");
    }

    private static TimeBasedSampler perMinuteSampler(long samplesPerMin) {
        if (samplesPerMin == 0L) {
            return new NoOpSampler();
        }
        return new AdaptiveSampler(Duration.ofMinutes(1L), samplesPerMin);
    }

    static {
        RECONFIGURABLE_CONFIGS.add(DEFAULT_SAMPLES_PER_MIN);
        RECONFIGURABLE_CONFIGS.add(OVERRIDE_API_SAMPLES_PER_MIN);
    }

    private static class AdaptiveSampler
    implements TimeBasedSampler {
        private final long intervalDurationNanos;
        private final long samplesPerInterval;
        private long intervalStartNanos = 0L;
        private long numIntervalRequests = 0L;
        private long numIntervalSamples = 0L;
        private long estimatedRequestsPerSample = 1L;

        AdaptiveSampler(Duration interval, long samplesPerInterval) {
            if (samplesPerInterval <= 0L) {
                throw new IllegalArgumentException("The number of samples per interval must be greater than 0");
            }
            this.intervalDurationNanos = interval.toNanos();
            this.samplesPerInterval = samplesPerInterval;
        }

        @Override
        public boolean maybeSample(long requestTimeNanos) {
            if (requestTimeNanos - this.intervalStartNanos > this.intervalDurationNanos) {
                this.estimatedRequestsPerSample = Math.max(this.numIntervalRequests / this.samplesPerInterval, 1L);
                this.numIntervalRequests = 0L;
                this.numIntervalSamples = 0L;
                this.intervalStartNanos = requestTimeNanos;
            }
            ++this.numIntervalRequests;
            if (this.numIntervalSamples < this.samplesPerInterval && this.numIntervalRequests % this.estimatedRequestsPerSample == 0L) {
                ++this.numIntervalSamples;
                return true;
            }
            return false;
        }
    }

    private static class NoOpSampler
    implements TimeBasedSampler {
        private NoOpSampler() {
        }

        @Override
        public boolean maybeSample(long requestTimeMs) {
            return false;
        }
    }

    private static interface TimeBasedSampler {
        public boolean maybeSample(long var1);
    }
}

