/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class ListClusterLinksRequestData
implements ApiMessage {
    private List<String> linkNames;
    private boolean includeTopics;
    private int timeoutMs;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field("link_names", CompactArrayOf.nullable(Type.COMPACT_STRING), "Names of the cluster links to include in the response, otherwise if null, then all cluster links are listed."), new Field("include_topics", Type.BOOLEAN, "Whether to include the topics that are linked for the cluster link."), new Field("timeout_ms", Type.INT32, "The time, in milliseconds, to allow for request completion."), Field.TaggedFieldsSection.of(new Object[0]));
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};

    public ListClusterLinksRequestData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public ListClusterLinksRequestData(Struct _struct, short _version) {
        this.fromStruct(_struct, _version);
    }

    public ListClusterLinksRequestData() {
        this.linkNames = null;
        this.includeTopics = false;
        this.timeoutMs = 0;
    }

    @Override
    public short apiKey() {
        return 10003;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 0;
    }

    @Override
    public void read(Readable _readable, short _version) {
        int arrayLength = _readable.readUnsignedVarint() - 1;
        if (arrayLength < 0) {
            this.linkNames = null;
        } else {
            ArrayList<String> newCollection = new ArrayList<String>(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                int length = _readable.readUnsignedVarint() - 1;
                if (length < 0) {
                    throw new RuntimeException("non-nullable field linkNames element was serialized as null");
                }
                if (length > Short.MAX_VALUE) {
                    throw new RuntimeException("string field linkNames element had invalid length " + length);
                }
                newCollection.add(_readable.readString(length));
            }
            this.linkNames = newCollection;
        }
        this.includeTopics = _readable.readByte() != 0;
        this.timeoutMs = _readable.readInt();
        this._unknownTaggedFields = null;
        int _numTaggedFields = _readable.readUnsignedVarint();
        for (int _i = 0; _i < _numTaggedFields; ++_i) {
            int _tag = _readable.readUnsignedVarint();
            int _size = _readable.readUnsignedVarint();
            switch (_tag) {
                default: 
            }
            this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        if (this.linkNames == null) {
            _writable.writeUnsignedVarint(0);
        } else {
            _writable.writeUnsignedVarint(this.linkNames.size() + 1);
            for (String linkNamesElement : this.linkNames) {
                byte[] _stringBytes = _cache.getSerializedValue(linkNamesElement);
                _writable.writeUnsignedVarint(_stringBytes.length + 1);
                _writable.writeByteArray(_stringBytes);
            }
        }
        _writable.writeByte(this.includeTopics ? (byte)1 : 0);
        _writable.writeInt(this.timeoutMs);
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
        _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
    }

    @Override
    public void fromStruct(Struct struct, short _version) {
        NavigableMap _taggedFields = null;
        this._unknownTaggedFields = null;
        _taggedFields = (NavigableMap)struct.get("_tagged_fields");
        Object[] _nestedObjects = struct.getArray("link_names");
        if (_nestedObjects == null) {
            this.linkNames = null;
        } else {
            this.linkNames = new ArrayList<String>(_nestedObjects.length);
            for (Object nestedObject : _nestedObjects) {
                this.linkNames.add((String)nestedObject);
            }
        }
        this.includeTopics = struct.getBoolean("include_topics");
        this.timeoutMs = struct.getInt("timeout_ms");
        if (!_taggedFields.isEmpty()) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(_taggedFields.size());
            for (Map.Entry entry : _taggedFields.entrySet()) {
                this._unknownTaggedFields.add((RawTaggedField)entry.getValue());
            }
        }
    }

    @Override
    public Struct toStruct(short _version) {
        TreeMap _taggedFields = null;
        _taggedFields = new TreeMap();
        Struct struct = new Struct(SCHEMAS[_version]);
        if (this.linkNames == null) {
            struct.set("link_names", null);
        } else {
            String[] _nestedObjects = new String[this.linkNames.size()];
            int i = 0;
            for (String element : this.linkNames) {
                _nestedObjects[i++] = element;
            }
            struct.set("link_names", (Object)_nestedObjects);
        }
        struct.set("include_topics", (Object)this.includeTopics);
        struct.set("timeout_ms", (Object)this.timeoutMs);
        struct.set("_tagged_fields", _taggedFields);
        return struct;
    }

    @Override
    public int size(ObjectSerializationCache _cache, short _version) {
        int _size = 0;
        int _numTaggedFields = 0;
        if (this.linkNames == null) {
            ++_size;
        } else {
            int _arraySize = 0;
            _arraySize += ByteUtils.sizeOfUnsignedVarint(this.linkNames.size() + 1);
            for (String linkNamesElement : this.linkNames) {
                byte[] _stringBytes = linkNamesElement.getBytes(StandardCharsets.UTF_8);
                if (_stringBytes.length > Short.MAX_VALUE) {
                    throw new RuntimeException("'linkNamesElement' field is too long to be serialized");
                }
                _cache.cacheSerializedValue(linkNamesElement, _stringBytes);
                _arraySize += _stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1);
            }
            _size += _arraySize;
        }
        ++_size;
        _size += 4;
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                _size += _field.size();
            }
        }
        return _size += ByteUtils.sizeOfUnsignedVarint(_numTaggedFields);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ListClusterLinksRequestData)) {
            return false;
        }
        ListClusterLinksRequestData other = (ListClusterLinksRequestData)obj;
        if (this.linkNames == null ? other.linkNames != null : !this.linkNames.equals(other.linkNames)) {
            return false;
        }
        if (this.includeTopics != other.includeTopics) {
            return false;
        }
        return this.timeoutMs == other.timeoutMs;
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (this.linkNames == null ? 0 : this.linkNames.hashCode());
        hashCode = 31 * hashCode + (this.includeTopics ? 1231 : 1237);
        hashCode = 31 * hashCode + this.timeoutMs;
        return hashCode;
    }

    @Override
    public ListClusterLinksRequestData duplicate() {
        ListClusterLinksRequestData _duplicate = new ListClusterLinksRequestData();
        if (this.linkNames == null) {
            _duplicate.linkNames = null;
        } else {
            ArrayList<String> newLinkNames = new ArrayList<String>(this.linkNames.size());
            for (String _element : this.linkNames) {
                newLinkNames.add(_element);
            }
            _duplicate.linkNames = newLinkNames;
        }
        _duplicate.includeTopics = this.includeTopics;
        _duplicate.timeoutMs = this.timeoutMs;
        return _duplicate;
    }

    public String toString() {
        return "ListClusterLinksRequestData(linkNames=" + (this.linkNames == null ? "null" : MessageUtil.deepToString(this.linkNames.iterator())) + ", includeTopics=" + (this.includeTopics ? "true" : "false") + ", timeoutMs=" + this.timeoutMs + ")";
    }

    public List<String> linkNames() {
        return this.linkNames;
    }

    public boolean includeTopics() {
        return this.includeTopics;
    }

    public int timeoutMs() {
        return this.timeoutMs;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public ListClusterLinksRequestData setLinkNames(List<String> v) {
        this.linkNames = v;
        return this;
    }

    public ListClusterLinksRequestData setIncludeTopics(boolean v) {
        this.includeTopics = v;
        return this;
    }

    public ListClusterLinksRequestData setTimeoutMs(int v) {
        this.timeoutMs = v;
        return this;
    }
}

