/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class OffsetForLeaderEpochResponseData
implements ApiMessage {
    private int throttleTimeMs;
    private List<OffsetForLeaderTopicResult> topics;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field("topics", new ArrayOf(OffsetForLeaderTopicResult.SCHEMA_0), "Each topic we fetched offsets for."));
    public static final Schema SCHEMA_1 = new Schema(new Field("topics", new ArrayOf(OffsetForLeaderTopicResult.SCHEMA_1), "Each topic we fetched offsets for."));
    public static final Schema SCHEMA_2;
    public static final Schema SCHEMA_3;
    public static final Schema[] SCHEMAS;

    public OffsetForLeaderEpochResponseData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public OffsetForLeaderEpochResponseData(Struct _struct, short _version) {
        this.fromStruct(_struct, _version);
    }

    public OffsetForLeaderEpochResponseData() {
        this.throttleTimeMs = 0;
        this.topics = new ArrayList<OffsetForLeaderTopicResult>(0);
    }

    @Override
    public short apiKey() {
        return 23;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 3;
    }

    @Override
    public void read(Readable _readable, short _version) {
        this.throttleTimeMs = _version >= 2 ? _readable.readInt() : 0;
        int arrayLength = _readable.readInt();
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field topics was serialized as null");
        }
        if (arrayLength > _readable.remaining()) {
            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
        }
        ArrayList<OffsetForLeaderTopicResult> newCollection = new ArrayList<OffsetForLeaderTopicResult>(arrayLength);
        for (int i = 0; i < arrayLength; ++i) {
            newCollection.add(new OffsetForLeaderTopicResult(_readable, _version));
        }
        this.topics = newCollection;
        this._unknownTaggedFields = null;
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        if (_version >= 2) {
            _writable.writeInt(this.throttleTimeMs);
        }
        _writable.writeInt(this.topics.size());
        for (OffsetForLeaderTopicResult topicsElement : this.topics) {
            topicsElement.write(_writable, _cache, _version);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        if ((_numTaggedFields += _rawWriter.numFields()) > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    @Override
    public void fromStruct(Struct struct, short _version) {
        this._unknownTaggedFields = null;
        this.throttleTimeMs = _version >= 2 ? struct.getInt("throttle_time_ms") : 0;
        Object[] _nestedObjects = struct.getArray("topics");
        this.topics = new ArrayList<OffsetForLeaderTopicResult>(_nestedObjects.length);
        for (Object nestedObject : _nestedObjects) {
            this.topics.add(new OffsetForLeaderTopicResult((Struct)nestedObject, _version));
        }
    }

    @Override
    public Struct toStruct(short _version) {
        Object _taggedFields = null;
        Struct struct = new Struct(SCHEMAS[_version]);
        if (_version >= 2) {
            struct.set("throttle_time_ms", (Object)this.throttleTimeMs);
        }
        Struct[] _nestedObjects = new Struct[this.topics.size()];
        int i = 0;
        for (OffsetForLeaderTopicResult element : this.topics) {
            _nestedObjects[i++] = element.toStruct(_version);
        }
        struct.set("topics", (Object)_nestedObjects);
        return struct;
    }

    @Override
    public int size(ObjectSerializationCache _cache, short _version) {
        int _size = 0;
        int _numTaggedFields = 0;
        if (_version >= 2) {
            _size += 4;
        }
        int _arraySize = 0;
        _arraySize += 4;
        for (OffsetForLeaderTopicResult topicsElement : this.topics) {
            _arraySize += topicsElement.size(_cache, _version);
        }
        _size += _arraySize;
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                _size += _field.size();
            }
        }
        if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
        return _size;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof OffsetForLeaderEpochResponseData)) {
            return false;
        }
        OffsetForLeaderEpochResponseData other = (OffsetForLeaderEpochResponseData)obj;
        if (this.throttleTimeMs != other.throttleTimeMs) {
            return false;
        }
        return !(this.topics == null ? other.topics != null : !this.topics.equals(other.topics));
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.throttleTimeMs;
        hashCode = 31 * hashCode + (this.topics == null ? 0 : this.topics.hashCode());
        return hashCode;
    }

    @Override
    public OffsetForLeaderEpochResponseData duplicate() {
        OffsetForLeaderEpochResponseData _duplicate = new OffsetForLeaderEpochResponseData();
        _duplicate.throttleTimeMs = this.throttleTimeMs;
        ArrayList<OffsetForLeaderTopicResult> newTopics = new ArrayList<OffsetForLeaderTopicResult>(this.topics.size());
        for (OffsetForLeaderTopicResult _element : this.topics) {
            newTopics.add(_element.duplicate());
        }
        _duplicate.topics = newTopics;
        return _duplicate;
    }

    public String toString() {
        return "OffsetForLeaderEpochResponseData(throttleTimeMs=" + this.throttleTimeMs + ", topics=" + MessageUtil.deepToString(this.topics.iterator()) + ")";
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public List<OffsetForLeaderTopicResult> topics() {
        return this.topics;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public OffsetForLeaderEpochResponseData setThrottleTimeMs(int v) {
        this.throttleTimeMs = v;
        return this;
    }

    public OffsetForLeaderEpochResponseData setTopics(List<OffsetForLeaderTopicResult> v) {
        this.topics = v;
        return this;
    }

    static {
        SCHEMA_3 = SCHEMA_2 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("topics", new ArrayOf(OffsetForLeaderTopicResult.SCHEMA_1), "Each topic we fetched offsets for."));
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3};
    }

    public static class OffsetForLeaderPartitionResult
    implements Message {
        private short errorCode;
        private int partitionIndex;
        private int leaderEpoch;
        private long endOffset;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("error_code", Type.INT16, "The error code 0, or if there was no error."), new Field("partition_index", Type.INT32, "The partition index."), new Field("end_offset", Type.INT64, "The end offset of the epoch."));
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema[] SCHEMAS;

        public OffsetForLeaderPartitionResult(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public OffsetForLeaderPartitionResult(Struct _struct, short _version) {
            this.fromStruct(_struct, _version);
        }

        public OffsetForLeaderPartitionResult() {
            this.errorCode = 0;
            this.partitionIndex = 0;
            this.leaderEpoch = -1;
            this.endOffset = 0L;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 3;
        }

        @Override
        public void read(Readable _readable, short _version) {
            if (_version > 3) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of OffsetForLeaderPartitionResult");
            }
            this.errorCode = _readable.readShort();
            this.partitionIndex = _readable.readInt();
            this.leaderEpoch = _version >= 1 ? _readable.readInt() : -1;
            this.endOffset = _readable.readLong();
            this._unknownTaggedFields = null;
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            _writable.writeShort(this.errorCode);
            _writable.writeInt(this.partitionIndex);
            if (_version >= 1) {
                _writable.writeInt(this.leaderEpoch);
            }
            _writable.writeLong(this.endOffset);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            if ((_numTaggedFields += _rawWriter.numFields()) > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void fromStruct(Struct struct, short _version) {
            if (_version > 3) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of OffsetForLeaderPartitionResult");
            }
            this._unknownTaggedFields = null;
            this.errorCode = struct.getShort("error_code");
            this.partitionIndex = struct.getInt("partition_index");
            this.leaderEpoch = _version >= 1 ? struct.getInt("leader_epoch") : -1;
            this.endOffset = struct.getLong("end_offset");
        }

        @Override
        public Struct toStruct(short _version) {
            if (_version > 3) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of OffsetForLeaderPartitionResult");
            }
            Object _taggedFields = null;
            Struct struct = new Struct(SCHEMAS[_version]);
            struct.set("error_code", (Object)this.errorCode);
            struct.set("partition_index", (Object)this.partitionIndex);
            if (_version >= 1) {
                struct.set("leader_epoch", (Object)this.leaderEpoch);
            }
            struct.set("end_offset", (Object)this.endOffset);
            return struct;
        }

        @Override
        public int size(ObjectSerializationCache _cache, short _version) {
            int _size = 0;
            int _numTaggedFields = 0;
            if (_version > 3) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of OffsetForLeaderPartitionResult");
            }
            _size += 2;
            _size += 4;
            if (_version >= 1) {
                _size += 4;
            }
            _size += 8;
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                    _size += _field.size();
                }
            }
            if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
            return _size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof OffsetForLeaderPartitionResult)) {
                return false;
            }
            OffsetForLeaderPartitionResult other = (OffsetForLeaderPartitionResult)obj;
            if (this.errorCode != other.errorCode) {
                return false;
            }
            if (this.partitionIndex != other.partitionIndex) {
                return false;
            }
            if (this.leaderEpoch != other.leaderEpoch) {
                return false;
            }
            return this.endOffset == other.endOffset;
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.errorCode;
            hashCode = 31 * hashCode + this.partitionIndex;
            hashCode = 31 * hashCode + this.leaderEpoch;
            hashCode = 31 * hashCode + ((int)(this.endOffset >> 32) ^ (int)this.endOffset);
            return hashCode;
        }

        @Override
        public OffsetForLeaderPartitionResult duplicate() {
            OffsetForLeaderPartitionResult _duplicate = new OffsetForLeaderPartitionResult();
            _duplicate.errorCode = this.errorCode;
            _duplicate.partitionIndex = this.partitionIndex;
            _duplicate.leaderEpoch = this.leaderEpoch;
            _duplicate.endOffset = this.endOffset;
            return _duplicate;
        }

        public String toString() {
            return "OffsetForLeaderPartitionResult(errorCode=" + this.errorCode + ", partitionIndex=" + this.partitionIndex + ", leaderEpoch=" + this.leaderEpoch + ", endOffset=" + this.endOffset + ")";
        }

        public short errorCode() {
            return this.errorCode;
        }

        public int partitionIndex() {
            return this.partitionIndex;
        }

        public int leaderEpoch() {
            return this.leaderEpoch;
        }

        public long endOffset() {
            return this.endOffset;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public OffsetForLeaderPartitionResult setErrorCode(short v) {
            this.errorCode = v;
            return this;
        }

        public OffsetForLeaderPartitionResult setPartitionIndex(int v) {
            this.partitionIndex = v;
            return this;
        }

        public OffsetForLeaderPartitionResult setLeaderEpoch(int v) {
            this.leaderEpoch = v;
            return this;
        }

        public OffsetForLeaderPartitionResult setEndOffset(long v) {
            this.endOffset = v;
            return this;
        }

        static {
            SCHEMA_3 = SCHEMA_2 = (SCHEMA_1 = new Schema(new Field("error_code", Type.INT16, "The error code 0, or if there was no error."), new Field("partition_index", Type.INT32, "The partition index."), new Field("leader_epoch", Type.INT32, "The leader epoch of the partition."), new Field("end_offset", Type.INT64, "The end offset of the epoch.")));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3};
        }
    }

    public static class OffsetForLeaderTopicResult
    implements Message {
        private String name;
        private List<OffsetForLeaderPartitionResult> partitions;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("name", Type.STRING, "The topic name."), new Field("partitions", new ArrayOf(OffsetForLeaderPartitionResult.SCHEMA_0), "Each partition in the topic we fetched offsets for."));
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema[] SCHEMAS;

        public OffsetForLeaderTopicResult(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public OffsetForLeaderTopicResult(Struct _struct, short _version) {
            this.fromStruct(_struct, _version);
        }

        public OffsetForLeaderTopicResult() {
            this.name = "";
            this.partitions = new ArrayList<OffsetForLeaderPartitionResult>(0);
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 3;
        }

        @Override
        public void read(Readable _readable, short _version) {
            if (_version > 3) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of OffsetForLeaderTopicResult");
            }
            short length = _readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field name was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field name had invalid length " + length);
            }
            this.name = _readable.readString(length);
            int arrayLength = _readable.readInt();
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field partitions was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            ArrayList<OffsetForLeaderPartitionResult> newCollection = new ArrayList<OffsetForLeaderPartitionResult>(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                newCollection.add(new OffsetForLeaderPartitionResult(_readable, _version));
            }
            this.partitions = newCollection;
            this._unknownTaggedFields = null;
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            Object _stringBytes = _cache.getSerializedValue(this.name);
            _writable.writeShort((short)((byte[])_stringBytes).length);
            _writable.writeByteArray((byte[])_stringBytes);
            _writable.writeInt(this.partitions.size());
            _stringBytes = this.partitions.iterator();
            while (_stringBytes.hasNext()) {
                OffsetForLeaderPartitionResult partitionsElement = (OffsetForLeaderPartitionResult)_stringBytes.next();
                partitionsElement.write(_writable, _cache, _version);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            if ((_numTaggedFields += _rawWriter.numFields()) > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void fromStruct(Struct struct, short _version) {
            if (_version > 3) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of OffsetForLeaderTopicResult");
            }
            this._unknownTaggedFields = null;
            this.name = struct.getString("name");
            Object[] _nestedObjects = struct.getArray("partitions");
            this.partitions = new ArrayList<OffsetForLeaderPartitionResult>(_nestedObjects.length);
            for (Object nestedObject : _nestedObjects) {
                this.partitions.add(new OffsetForLeaderPartitionResult((Struct)nestedObject, _version));
            }
        }

        @Override
        public Struct toStruct(short _version) {
            if (_version > 3) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of OffsetForLeaderTopicResult");
            }
            Object _taggedFields = null;
            Struct struct = new Struct(SCHEMAS[_version]);
            struct.set("name", (Object)this.name);
            Struct[] _nestedObjects = new Struct[this.partitions.size()];
            int i = 0;
            for (OffsetForLeaderPartitionResult element : this.partitions) {
                _nestedObjects[i++] = element.toStruct(_version);
            }
            struct.set("partitions", (Object)_nestedObjects);
            return struct;
        }

        @Override
        public int size(ObjectSerializationCache _cache, short _version) {
            int _size = 0;
            int _numTaggedFields = 0;
            if (_version > 3) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of OffsetForLeaderTopicResult");
            }
            byte[] _stringBytes = this.name.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'name' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.name, _stringBytes);
            _size += _stringBytes.length + 2;
            int _arraySize = 0;
            _arraySize += 4;
            for (OffsetForLeaderPartitionResult partitionsElement : this.partitions) {
                _arraySize += partitionsElement.size(_cache, _version);
            }
            _size += _arraySize;
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                    _size += _field.size();
                }
            }
            if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
            return _size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof OffsetForLeaderTopicResult)) {
                return false;
            }
            OffsetForLeaderTopicResult other = (OffsetForLeaderTopicResult)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return !(this.partitions == null ? other.partitions != null : !this.partitions.equals(other.partitions));
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
            hashCode = 31 * hashCode + (this.partitions == null ? 0 : this.partitions.hashCode());
            return hashCode;
        }

        @Override
        public OffsetForLeaderTopicResult duplicate() {
            OffsetForLeaderTopicResult _duplicate = new OffsetForLeaderTopicResult();
            _duplicate.name = this.name;
            ArrayList<OffsetForLeaderPartitionResult> newPartitions = new ArrayList<OffsetForLeaderPartitionResult>(this.partitions.size());
            for (OffsetForLeaderPartitionResult _element : this.partitions) {
                newPartitions.add(_element.duplicate());
            }
            _duplicate.partitions = newPartitions;
            return _duplicate;
        }

        public String toString() {
            return "OffsetForLeaderTopicResult(name=" + (this.name == null ? "null" : "'" + this.name.toString() + "'") + ", partitions=" + MessageUtil.deepToString(this.partitions.iterator()) + ")";
        }

        public String name() {
            return this.name;
        }

        public List<OffsetForLeaderPartitionResult> partitions() {
            return this.partitions;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public OffsetForLeaderTopicResult setName(String v) {
            this.name = v;
            return this;
        }

        public OffsetForLeaderTopicResult setPartitions(List<OffsetForLeaderPartitionResult> v) {
            this.partitions = v;
            return this;
        }

        static {
            SCHEMA_3 = SCHEMA_2 = (SCHEMA_1 = new Schema(new Field("name", Type.STRING, "The topic name."), new Field("partitions", new ArrayOf(OffsetForLeaderPartitionResult.SCHEMA_1), "Each partition in the topic we fetched offsets for.")));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3};
        }
    }
}

