/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;

public class ClusterLinkListing {
    private final String linkName;
    private final UUID linkId;
    private final String clusterId;
    private final Optional<Collection<String>> topics;

    public ClusterLinkListing(String linkName, UUID linkId, String clusterId, Optional<Collection<String>> topics) {
        this.linkName = Objects.requireNonNull(linkName, "linkName");
        this.linkId = Objects.requireNonNull(linkId, "linkId");
        this.clusterId = clusterId;
        this.topics = Objects.requireNonNull(topics, "topics");
    }

    public String linkName() {
        return this.linkName;
    }

    public UUID linkId() {
        return this.linkId;
    }

    public String clusterId() {
        return this.clusterId;
    }

    public Optional<Collection<String>> topics() {
        return this.topics;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterLinkListing that = (ClusterLinkListing)o;
        return Objects.equals(this.linkName, that.linkName) && Objects.equals(this.linkId, that.linkId) && Objects.equals(this.clusterId, that.clusterId) && Objects.equals(this.topics, that.topics);
    }

    public int hashCode() {
        return Objects.hash(this.linkName, this.linkId, this.clusterId, this.topics);
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("ClusterLinkListing(linkName=").append(this.linkName).append(", linkId=").append(this.linkId).append(", clusterId=").append(this.clusterId);
        if (this.topics.isPresent()) {
            str.append(", topics=").append(this.topics.get());
        }
        return str.toString();
    }
}

