/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.message.LeaderAndIsrRequestData;
import org.apache.kafka.common.message.LeaderAndIsrResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.AbstractControlRequest;
import org.apache.kafka.common.requests.LeaderAndIsrResponse;
import org.apache.kafka.common.utils.FlattenedIterator;
import org.apache.kafka.common.utils.Utils;

public class LeaderAndIsrRequest
extends AbstractControlRequest {
    private final LeaderAndIsrRequestData data;

    LeaderAndIsrRequest(LeaderAndIsrRequestData data, short version) {
        super(ApiKeys.LEADER_AND_ISR, version);
        this.data = data;
        this.normalize();
    }

    private void normalize() {
        if (this.version() >= 2) {
            for (LeaderAndIsrRequestData.LeaderAndIsrTopicState topicState : this.data.topicStates()) {
                for (LeaderAndIsrRequestData.LeaderAndIsrPartitionState partitionState : topicState.partitionStates()) {
                    partitionState.setTopicName(topicState.topicName());
                }
            }
        }
    }

    public LeaderAndIsrRequest(Struct struct, short version) {
        this(new LeaderAndIsrRequestData(struct, version), version);
    }

    @Override
    protected Struct toStruct() {
        return this.data.toStruct(this.version());
    }

    @Override
    public LeaderAndIsrResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        LeaderAndIsrResponseData responseData = new LeaderAndIsrResponseData();
        Errors error = Errors.forException(e);
        responseData.setErrorCode(error.code());
        ArrayList<LeaderAndIsrResponseData.LeaderAndIsrPartitionError> partitions = new ArrayList<LeaderAndIsrResponseData.LeaderAndIsrPartitionError>();
        for (LeaderAndIsrRequestData.LeaderAndIsrPartitionState partition : this.partitionStates()) {
            partitions.add(new LeaderAndIsrResponseData.LeaderAndIsrPartitionError().setTopicName(partition.topicName()).setPartitionIndex(partition.partitionIndex()).setErrorCode(error.code()));
        }
        responseData.setPartitionErrors(partitions);
        return new LeaderAndIsrResponse(responseData);
    }

    @Override
    public int controllerId() {
        return this.data.controllerId();
    }

    @Override
    public int controllerEpoch() {
        return this.data.controllerEpoch();
    }

    @Override
    public long brokerEpoch() {
        return this.data.brokerEpoch();
    }

    public boolean containsAllReplicas() {
        return this.data.containsAllReplicas();
    }

    public Iterable<LeaderAndIsrRequestData.LeaderAndIsrPartitionState> partitionStates() {
        if (this.version() >= 2) {
            return () -> new FlattenedIterator(this.data.topicStates().iterator(), topicState -> topicState.partitionStates().iterator());
        }
        return this.data.ungroupedPartitionStates();
    }

    public List<LeaderAndIsrRequestData.LeaderAndIsrLiveLeader> liveLeaders() {
        return Collections.unmodifiableList(this.data.liveLeaders());
    }

    protected LeaderAndIsrRequestData data() {
        return this.data;
    }

    public static LeaderAndIsrRequest parse(ByteBuffer buffer, short version) {
        return new LeaderAndIsrRequest(ApiKeys.LEADER_AND_ISR.parseRequest(version, buffer), version);
    }

    public static class Builder
    extends AbstractControlRequest.Builder<LeaderAndIsrRequest> {
        private final List<LeaderAndIsrRequestData.LeaderAndIsrPartitionState> partitionStates;
        private final Collection<Node> liveLeaders;
        private final boolean containsAllReplicas;

        public Builder(short version, int controllerId, int controllerEpoch, long brokerEpoch, List<LeaderAndIsrRequestData.LeaderAndIsrPartitionState> partitionStates, Collection<Node> liveLeaders, boolean containsAllReplicas) {
            super(ApiKeys.LEADER_AND_ISR, version, controllerId, controllerEpoch, brokerEpoch);
            this.partitionStates = partitionStates;
            this.liveLeaders = liveLeaders;
            this.containsAllReplicas = containsAllReplicas;
        }

        @Override
        public LeaderAndIsrRequest build(short version) {
            List<LeaderAndIsrRequestData.LeaderAndIsrLiveLeader> leaders = this.liveLeaders.stream().map(n -> new LeaderAndIsrRequestData.LeaderAndIsrLiveLeader().setBrokerId(n.id()).setHostName(n.host()).setPort(n.port())).collect(Collectors.toList());
            LeaderAndIsrRequestData data = new LeaderAndIsrRequestData().setControllerId(this.controllerId).setControllerEpoch(this.controllerEpoch).setBrokerEpoch(this.brokerEpoch).setLiveLeaders(leaders).setContainsAllReplicas(this.containsAllReplicas);
            if (version >= 2) {
                Map<String, LeaderAndIsrRequestData.LeaderAndIsrTopicState> topicStatesMap = Builder.groupByTopic(this.partitionStates);
                data.setTopicStates(new ArrayList<LeaderAndIsrRequestData.LeaderAndIsrTopicState>(topicStatesMap.values()));
            } else {
                data.setUngroupedPartitionStates(this.partitionStates);
            }
            return new LeaderAndIsrRequest(data, version);
        }

        private static Map<String, LeaderAndIsrRequestData.LeaderAndIsrTopicState> groupByTopic(List<LeaderAndIsrRequestData.LeaderAndIsrPartitionState> partitionStates) {
            HashMap<String, LeaderAndIsrRequestData.LeaderAndIsrTopicState> topicStates = new HashMap<String, LeaderAndIsrRequestData.LeaderAndIsrTopicState>();
            for (LeaderAndIsrRequestData.LeaderAndIsrPartitionState partition : partitionStates) {
                LeaderAndIsrRequestData.LeaderAndIsrTopicState topicState = topicStates.computeIfAbsent(partition.topicName(), t -> new LeaderAndIsrRequestData.LeaderAndIsrTopicState().setTopicName(partition.topicName()).setTopicId(partition.topicId()).setClusterLinkId(partition.clusterLinkId()).setClusterLinkTopicState(partition.clusterLinkTopicState()));
                topicState.partitionStates().add(partition);
            }
            return topicStates;
        }

        public String toString() {
            StringBuilder bld = new StringBuilder();
            bld.append("(type=LeaderAndIsRequest").append(", controllerId=").append(this.controllerId).append(", controllerEpoch=").append(this.controllerEpoch).append(", brokerEpoch=").append(this.brokerEpoch).append(", containsAllReplicas=").append(this.containsAllReplicas).append(", partitionStates=").append(this.partitionStates).append(", liveLeaders=(").append(Utils.join(this.liveLeaders, ", ")).append(")").append(")");
            return bld.toString();
        }
    }
}

