/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class DescribeBrokerRemovalsResponseData
implements ApiMessage {
    private int throttleTimeMs;
    private short errorCode;
    private String errorMessage;
    private List<BrokerRemovalResponse> removedBrokers;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("error_code", Type.INT16, "The error code"), new Field("error_message", Type.NULLABLE_STRING, "The error message, or null if there was no error."), new Field("removed_brokers", new ArrayOf(BrokerRemovalResponse.SCHEMA_0), "Broker IDs that are being or have been removed."));
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};

    public DescribeBrokerRemovalsResponseData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public DescribeBrokerRemovalsResponseData(Struct _struct, short _version) {
        this.fromStruct(_struct, _version);
    }

    public DescribeBrokerRemovalsResponseData() {
        this.throttleTimeMs = 0;
        this.errorCode = 0;
        this.errorMessage = "";
        this.removedBrokers = new ArrayList<BrokerRemovalResponse>(0);
    }

    @Override
    public short apiKey() {
        return 10007;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 0;
    }

    @Override
    public void read(Readable _readable, short _version) {
        this.throttleTimeMs = _readable.readInt();
        this.errorCode = _readable.readShort();
        short length = _readable.readShort();
        if (length < 0) {
            this.errorMessage = null;
        } else {
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field errorMessage had invalid length " + length);
            }
            this.errorMessage = _readable.readString(length);
        }
        int arrayLength = _readable.readInt();
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field removedBrokers was serialized as null");
        }
        if (arrayLength > _readable.remaining()) {
            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
        }
        ArrayList<BrokerRemovalResponse> newCollection = new ArrayList<BrokerRemovalResponse>(arrayLength);
        for (int i = 0; i < arrayLength; ++i) {
            newCollection.add(new BrokerRemovalResponse(_readable, _version));
        }
        this.removedBrokers = newCollection;
        this._unknownTaggedFields = null;
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        Object _stringBytes;
        int _numTaggedFields = 0;
        _writable.writeInt(this.throttleTimeMs);
        _writable.writeShort(this.errorCode);
        if (this.errorMessage == null) {
            _writable.writeShort((short)-1);
        } else {
            _stringBytes = _cache.getSerializedValue(this.errorMessage);
            _writable.writeShort((short)((byte[])_stringBytes).length);
            _writable.writeByteArray((byte[])_stringBytes);
        }
        _writable.writeInt(this.removedBrokers.size());
        _stringBytes = this.removedBrokers.iterator();
        while (_stringBytes.hasNext()) {
            BrokerRemovalResponse removedBrokersElement = (BrokerRemovalResponse)_stringBytes.next();
            removedBrokersElement.write(_writable, _cache, _version);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        if ((_numTaggedFields += _rawWriter.numFields()) > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    @Override
    public void fromStruct(Struct struct, short _version) {
        this._unknownTaggedFields = null;
        this.throttleTimeMs = struct.getInt("throttle_time_ms");
        this.errorCode = struct.getShort("error_code");
        this.errorMessage = struct.getString("error_message");
        Object[] _nestedObjects = struct.getArray("removed_brokers");
        this.removedBrokers = new ArrayList<BrokerRemovalResponse>(_nestedObjects.length);
        for (Object nestedObject : _nestedObjects) {
            this.removedBrokers.add(new BrokerRemovalResponse((Struct)nestedObject, _version));
        }
    }

    @Override
    public Struct toStruct(short _version) {
        Object _taggedFields = null;
        Struct struct = new Struct(SCHEMAS[_version]);
        struct.set("throttle_time_ms", (Object)this.throttleTimeMs);
        struct.set("error_code", (Object)this.errorCode);
        struct.set("error_message", (Object)this.errorMessage);
        Struct[] _nestedObjects = new Struct[this.removedBrokers.size()];
        int i = 0;
        for (BrokerRemovalResponse element : this.removedBrokers) {
            _nestedObjects[i++] = element.toStruct(_version);
        }
        struct.set("removed_brokers", (Object)_nestedObjects);
        return struct;
    }

    @Override
    public int size(ObjectSerializationCache _cache, short _version) {
        int _size = 0;
        int _numTaggedFields = 0;
        _size += 4;
        _size += 2;
        if (this.errorMessage == null) {
            _size += 2;
        } else {
            byte[] _stringBytes = this.errorMessage.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'errorMessage' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.errorMessage, _stringBytes);
            _size += _stringBytes.length + 2;
        }
        int _arraySize = 0;
        _arraySize += 4;
        for (BrokerRemovalResponse removedBrokersElement : this.removedBrokers) {
            _arraySize += removedBrokersElement.size(_cache, _version);
        }
        _size += _arraySize;
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                _size += _field.size();
            }
        }
        if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
        return _size;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DescribeBrokerRemovalsResponseData)) {
            return false;
        }
        DescribeBrokerRemovalsResponseData other = (DescribeBrokerRemovalsResponseData)obj;
        if (this.throttleTimeMs != other.throttleTimeMs) {
            return false;
        }
        if (this.errorCode != other.errorCode) {
            return false;
        }
        if (this.errorMessage == null ? other.errorMessage != null : !this.errorMessage.equals(other.errorMessage)) {
            return false;
        }
        return !(this.removedBrokers == null ? other.removedBrokers != null : !this.removedBrokers.equals(other.removedBrokers));
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.throttleTimeMs;
        hashCode = 31 * hashCode + this.errorCode;
        hashCode = 31 * hashCode + (this.errorMessage == null ? 0 : this.errorMessage.hashCode());
        hashCode = 31 * hashCode + (this.removedBrokers == null ? 0 : this.removedBrokers.hashCode());
        return hashCode;
    }

    @Override
    public DescribeBrokerRemovalsResponseData duplicate() {
        DescribeBrokerRemovalsResponseData _duplicate = new DescribeBrokerRemovalsResponseData();
        _duplicate.throttleTimeMs = this.throttleTimeMs;
        _duplicate.errorCode = this.errorCode;
        _duplicate.errorMessage = this.errorMessage == null ? null : this.errorMessage;
        ArrayList<BrokerRemovalResponse> newRemovedBrokers = new ArrayList<BrokerRemovalResponse>(this.removedBrokers.size());
        for (BrokerRemovalResponse _element : this.removedBrokers) {
            newRemovedBrokers.add(_element.duplicate());
        }
        _duplicate.removedBrokers = newRemovedBrokers;
        return _duplicate;
    }

    public String toString() {
        return "DescribeBrokerRemovalsResponseData(throttleTimeMs=" + this.throttleTimeMs + ", errorCode=" + this.errorCode + ", errorMessage=" + (this.errorMessage == null ? "null" : "'" + this.errorMessage.toString() + "'") + ", removedBrokers=" + MessageUtil.deepToString(this.removedBrokers.iterator()) + ")";
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public short errorCode() {
        return this.errorCode;
    }

    public String errorMessage() {
        return this.errorMessage;
    }

    public List<BrokerRemovalResponse> removedBrokers() {
        return this.removedBrokers;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public DescribeBrokerRemovalsResponseData setThrottleTimeMs(int v) {
        this.throttleTimeMs = v;
        return this;
    }

    public DescribeBrokerRemovalsResponseData setErrorCode(short v) {
        this.errorCode = v;
        return this;
    }

    public DescribeBrokerRemovalsResponseData setErrorMessage(String v) {
        this.errorMessage = v;
        return this;
    }

    public DescribeBrokerRemovalsResponseData setRemovedBrokers(List<BrokerRemovalResponse> v) {
        this.removedBrokers = v;
        return this;
    }

    public static class BrokerRemovalResponse
    implements Message {
        private int brokerId;
        private String partitionReassignmentsStatus;
        private String brokerShutdownStatus;
        private short removalErrorCode;
        private String removalErrorMessage;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("broker_id", Type.INT32, "The Broker ID to remove"), new Field("partition_reassignments_status", Type.STRING, "The status of the partition reassignments operation that drains replicas out of the removed broker"), new Field("broker_shutdown_status", Type.STRING, "The status of the broker shutdown, part of the removal operation"), new Field("removal_error_code", Type.INT16, "The error code for the broker removal operation"), new Field("removal_error_message", Type.NULLABLE_STRING, "The error message for the broker removal operation, or null if there was no error."));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};

        public BrokerRemovalResponse(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public BrokerRemovalResponse(Struct _struct, short _version) {
            this.fromStruct(_struct, _version);
        }

        public BrokerRemovalResponse() {
            this.brokerId = 0;
            this.partitionReassignmentsStatus = "";
            this.brokerShutdownStatus = "";
            this.removalErrorCode = 0;
            this.removalErrorMessage = "";
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 0;
        }

        @Override
        public void read(Readable _readable, short _version) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of BrokerRemovalResponse");
            }
            this.brokerId = _readable.readInt();
            short length = _readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field partitionReassignmentsStatus was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field partitionReassignmentsStatus had invalid length " + length);
            }
            this.partitionReassignmentsStatus = _readable.readString(length);
            length = _readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field brokerShutdownStatus was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field brokerShutdownStatus had invalid length " + length);
            }
            this.brokerShutdownStatus = _readable.readString(length);
            this.removalErrorCode = _readable.readShort();
            length = _readable.readShort();
            if (length < 0) {
                this.removalErrorMessage = null;
            } else {
                if (length > Short.MAX_VALUE) {
                    throw new RuntimeException("string field removalErrorMessage had invalid length " + length);
                }
                this.removalErrorMessage = _readable.readString(length);
            }
            this._unknownTaggedFields = null;
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            _writable.writeInt(this.brokerId);
            byte[] _stringBytes = _cache.getSerializedValue(this.partitionReassignmentsStatus);
            _writable.writeShort((short)_stringBytes.length);
            _writable.writeByteArray(_stringBytes);
            _stringBytes = _cache.getSerializedValue(this.brokerShutdownStatus);
            _writable.writeShort((short)_stringBytes.length);
            _writable.writeByteArray(_stringBytes);
            _writable.writeShort(this.removalErrorCode);
            if (this.removalErrorMessage == null) {
                _writable.writeShort((short)-1);
            } else {
                _stringBytes = _cache.getSerializedValue(this.removalErrorMessage);
                _writable.writeShort((short)_stringBytes.length);
                _writable.writeByteArray(_stringBytes);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            if ((_numTaggedFields += _rawWriter.numFields()) > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void fromStruct(Struct struct, short _version) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of BrokerRemovalResponse");
            }
            this._unknownTaggedFields = null;
            this.brokerId = struct.getInt("broker_id");
            this.partitionReassignmentsStatus = struct.getString("partition_reassignments_status");
            this.brokerShutdownStatus = struct.getString("broker_shutdown_status");
            this.removalErrorCode = struct.getShort("removal_error_code");
            this.removalErrorMessage = struct.getString("removal_error_message");
        }

        @Override
        public Struct toStruct(short _version) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of BrokerRemovalResponse");
            }
            Object _taggedFields = null;
            Struct struct = new Struct(SCHEMAS[_version]);
            struct.set("broker_id", (Object)this.brokerId);
            struct.set("partition_reassignments_status", (Object)this.partitionReassignmentsStatus);
            struct.set("broker_shutdown_status", (Object)this.brokerShutdownStatus);
            struct.set("removal_error_code", (Object)this.removalErrorCode);
            struct.set("removal_error_message", (Object)this.removalErrorMessage);
            return struct;
        }

        @Override
        public int size(ObjectSerializationCache _cache, short _version) {
            int _size = 0;
            int _numTaggedFields = 0;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of BrokerRemovalResponse");
            }
            _size += 4;
            byte[] _stringBytes = this.partitionReassignmentsStatus.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'partitionReassignmentsStatus' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.partitionReassignmentsStatus, _stringBytes);
            _size += _stringBytes.length + 2;
            _stringBytes = this.brokerShutdownStatus.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'brokerShutdownStatus' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.brokerShutdownStatus, _stringBytes);
            _size += _stringBytes.length + 2;
            _size += 2;
            if (this.removalErrorMessage == null) {
                _size += 2;
            } else {
                _stringBytes = this.removalErrorMessage.getBytes(StandardCharsets.UTF_8);
                if (_stringBytes.length > Short.MAX_VALUE) {
                    throw new RuntimeException("'removalErrorMessage' field is too long to be serialized");
                }
                _cache.cacheSerializedValue(this.removalErrorMessage, _stringBytes);
                _size += _stringBytes.length + 2;
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                    _size += _field.size();
                }
            }
            if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
            return _size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof BrokerRemovalResponse)) {
                return false;
            }
            BrokerRemovalResponse other = (BrokerRemovalResponse)obj;
            if (this.brokerId != other.brokerId) {
                return false;
            }
            if (this.partitionReassignmentsStatus == null ? other.partitionReassignmentsStatus != null : !this.partitionReassignmentsStatus.equals(other.partitionReassignmentsStatus)) {
                return false;
            }
            if (this.brokerShutdownStatus == null ? other.brokerShutdownStatus != null : !this.brokerShutdownStatus.equals(other.brokerShutdownStatus)) {
                return false;
            }
            if (this.removalErrorCode != other.removalErrorCode) {
                return false;
            }
            return !(this.removalErrorMessage == null ? other.removalErrorMessage != null : !this.removalErrorMessage.equals(other.removalErrorMessage));
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.brokerId;
            hashCode = 31 * hashCode + (this.partitionReassignmentsStatus == null ? 0 : this.partitionReassignmentsStatus.hashCode());
            hashCode = 31 * hashCode + (this.brokerShutdownStatus == null ? 0 : this.brokerShutdownStatus.hashCode());
            hashCode = 31 * hashCode + this.removalErrorCode;
            hashCode = 31 * hashCode + (this.removalErrorMessage == null ? 0 : this.removalErrorMessage.hashCode());
            return hashCode;
        }

        @Override
        public BrokerRemovalResponse duplicate() {
            BrokerRemovalResponse _duplicate = new BrokerRemovalResponse();
            _duplicate.brokerId = this.brokerId;
            _duplicate.partitionReassignmentsStatus = this.partitionReassignmentsStatus;
            _duplicate.brokerShutdownStatus = this.brokerShutdownStatus;
            _duplicate.removalErrorCode = this.removalErrorCode;
            _duplicate.removalErrorMessage = this.removalErrorMessage == null ? null : this.removalErrorMessage;
            return _duplicate;
        }

        public String toString() {
            return "BrokerRemovalResponse(brokerId=" + this.brokerId + ", partitionReassignmentsStatus=" + (this.partitionReassignmentsStatus == null ? "null" : "'" + this.partitionReassignmentsStatus.toString() + "'") + ", brokerShutdownStatus=" + (this.brokerShutdownStatus == null ? "null" : "'" + this.brokerShutdownStatus.toString() + "'") + ", removalErrorCode=" + this.removalErrorCode + ", removalErrorMessage=" + (this.removalErrorMessage == null ? "null" : "'" + this.removalErrorMessage.toString() + "'") + ")";
        }

        public int brokerId() {
            return this.brokerId;
        }

        public String partitionReassignmentsStatus() {
            return this.partitionReassignmentsStatus;
        }

        public String brokerShutdownStatus() {
            return this.brokerShutdownStatus;
        }

        public short removalErrorCode() {
            return this.removalErrorCode;
        }

        public String removalErrorMessage() {
            return this.removalErrorMessage;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public BrokerRemovalResponse setBrokerId(int v) {
            this.brokerId = v;
            return this;
        }

        public BrokerRemovalResponse setPartitionReassignmentsStatus(String v) {
            this.partitionReassignmentsStatus = v;
            return this;
        }

        public BrokerRemovalResponse setBrokerShutdownStatus(String v) {
            this.brokerShutdownStatus = v;
            return this;
        }

        public BrokerRemovalResponse setRemovalErrorCode(short v) {
            this.removalErrorCode = v;
            return this;
        }

        public BrokerRemovalResponse setRemovalErrorMessage(String v) {
            this.removalErrorMessage = v;
            return this;
        }
    }
}

