/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.LeaderAndIsrResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.AbstractControlResponse;

public class LeaderAndIsrResponse
extends AbstractControlResponse {
    private final LeaderAndIsrResponseData data;

    public LeaderAndIsrResponse(LeaderAndIsrResponseData data) {
        this.data = data;
    }

    public LeaderAndIsrResponse(Struct struct, short version) {
        this.data = new LeaderAndIsrResponseData(struct, version);
    }

    public List<LeaderAndIsrResponseData.LeaderAndIsrPartitionError> partitions() {
        return this.data.partitionErrors();
    }

    @Override
    public Errors error() {
        return Errors.forCode(this.data.errorCode());
    }

    @Override
    public Map<TopicPartition, Errors> partitionErrors() {
        HashMap<TopicPartition, Errors> partitionsErrors = new HashMap<TopicPartition, Errors>();
        this.data.partitionErrors().forEach(partitionError -> partitionsErrors.put(new TopicPartition(partitionError.topicName(), partitionError.partitionIndex()), Errors.forCode(partitionError.errorCode())));
        return partitionsErrors;
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        Errors error = this.error();
        if (error != Errors.NONE) {
            return Collections.singletonMap(error, this.partitions().size());
        }
        return this.errorCounts(this.partitions().stream().map(l -> Errors.forCode(l.errorCode())));
    }

    public static LeaderAndIsrResponse parse(ByteBuffer buffer, short version) {
        return new LeaderAndIsrResponse(ApiKeys.LEADER_AND_ISR.parseResponse(version, buffer), version);
    }

    @Override
    protected Struct toStruct(short version) {
        return this.data.toStruct(version);
    }

    public String toString() {
        return this.data.toString();
    }
}

