/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.kafka.common.message.RemoveBrokersResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.AbstractResponse;

public class RemoveBrokersResponse
extends AbstractResponse {
    private final RemoveBrokersResponseData data;

    public RemoveBrokersResponse(Struct struct) {
        this(struct, ApiKeys.REMOVE_BROKERS.latestVersion());
    }

    public RemoveBrokersResponse(RemoveBrokersResponseData responseData) {
        this.data = responseData;
    }

    RemoveBrokersResponse(Struct struct, short version) {
        this.data = new RemoveBrokersResponseData(struct, version);
    }

    public static RemoveBrokersResponse parse(ByteBuffer buffer, short version) {
        return new RemoveBrokersResponse(ApiKeys.REMOVE_BROKERS.parseResponse(version, buffer), version);
    }

    public RemoveBrokersResponseData data() {
        return this.data;
    }

    @Override
    public boolean shouldClientThrottle(short version) {
        return true;
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        if (this.data.errorCode() != Errors.NONE.code()) {
            return Collections.singletonMap(Errors.forCode(this.data.errorCode()), this.data.brokersToRemove().size());
        }
        return this.errorCounts(this.data.brokersToRemove().stream().map(p -> Errors.forCode(p.errorCode())).collect(Collectors.toList()));
    }

    @Override
    protected Struct toStruct(short version) {
        return this.data.toStruct(version);
    }

    public String toString() {
        return this.data.toString();
    }
}

