/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.ssl;

import io.netty.buffer.ByteBufAllocator;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.ReferenceCountedOpenSslEngine;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import io.netty.util.internal.logging.InternalLoggerFactory;
import io.netty.util.internal.logging.Log4JLoggerFactory;
import java.io.Closeable;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableEntryException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Map;
import javax.net.ssl.SSLEngine;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.network.Mode;
import org.apache.kafka.common.security.auth.SslEngineFactory;
import org.apache.kafka.common.security.ssl.CloseableSslEngineFactory;
import org.apache.kafka.common.security.ssl.DefaultSslEngineFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettySslEngineFactory
extends DefaultSslEngineFactory
implements SslEngineFactory,
CloseableSslEngineFactory {
    private static final Logger log = LoggerFactory.getLogger(NettySslEngineFactory.class);
    private SslContext nettySslContext;
    private boolean configured = false;

    @Override
    public SSLEngine createServerSslEngine(String peerHost, int peerPort) {
        if (!this.configured) {
            throw new RuntimeException("Cannot create SSLEngine since this factory has not yet been configured");
        }
        if (this.nettySslContext == null) {
            throw new RuntimeException("Cannot create SSLEngine since this factory could not be configured");
        }
        return this.nettySslContext.newEngine(ByteBufAllocator.DEFAULT, peerHost, peerPort);
    }

    @Override
    public void configure(Map<String, ?> configs) {
        super.configure(configs);
        this.nettySslContext = !OpenSsl.isAvailable() ? null : this.createNettySslServerContext();
        this.configured = true;
    }

    static boolean isConfigurable(Map<String, ?> configs, Mode mode) {
        if (mode != Mode.SERVER) {
            log.warn("Cannot configure Netty because the SSL mode is {} instead of {}", (Object)mode, (Object)Mode.SERVER);
            return false;
        }
        if (!(configs.containsKey("ssl.keystore.type") && configs.containsKey("ssl.keystore.location") && configs.containsKey("ssl.keystore.password"))) {
            log.warn("Cannot configure Netty because keystore is not configured.");
            return false;
        }
        if (!OpenSsl.isAvailable()) {
            log.warn("Cannot configure Netty because no OpenSSL is available.");
            return false;
        }
        return true;
    }

    @Override
    public Closeable sslEngineCloser(SSLEngine engine) {
        return new CloseableSslEngine(engine);
    }

    DefaultSslEngineFactory.PrivateKeyData loadPrivateKeyData() {
        DefaultSslEngineFactory.SecurityStore keyStore = this.securityKeyStore();
        KeyStore store = keyStore.load();
        KeyStore.PasswordProtection keyProtection = keyStore.keyPassword() == null ? null : new KeyStore.PasswordProtection(keyStore.keyPassword().value().toCharArray());
        try {
            Enumeration<String> aliases = store.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                if (!store.isKeyEntry(alias)) continue;
                try {
                    KeyStore.Entry entry = store.getEntry(alias, keyProtection);
                    if (!(entry instanceof KeyStore.PrivateKeyEntry)) continue;
                    KeyStore.PrivateKeyEntry privateKeyEntry = (KeyStore.PrivateKeyEntry)entry;
                    PrivateKey privateKey = privateKeyEntry.getPrivateKey();
                    Certificate[] certs = privateKeyEntry.getCertificateChain();
                    if (!(certs instanceof X509Certificate[])) {
                        throw new RuntimeException("Expected a certificate chain of type X509Certificate for alias " + alias);
                    }
                    return new DefaultSslEngineFactory.PrivateKeyData(privateKey, (X509Certificate[])certs);
                }
                catch (NoSuchAlgorithmException e) {
                    log.info("can't find the algorithm for recovering the {} entry.", (Object)alias);
                }
                catch (UnrecoverableEntryException e) {
                    log.trace("ignoring alias {}, since the password doesn't match.", (Object)alias);
                }
            }
        }
        catch (KeyStoreException e) {
            throw new KafkaException(e);
        }
        throw new RuntimeException("No private key found protected with the given password in " + keyStore.path());
    }

    X509Certificate[] loadAllCertificates() {
        KeyStore store = this.securityTrustStore().load();
        ArrayList<X509Certificate> all = new ArrayList<X509Certificate>();
        try {
            Enumeration<String> aliases = store.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                if (!store.isCertificateEntry(alias)) continue;
                Certificate cert = store.getCertificate(alias);
                if (!(cert instanceof X509Certificate)) {
                    throw new RuntimeException("Expected a certificate of type X509Certificate for alias " + alias);
                }
                all.add((X509Certificate)cert);
            }
        }
        catch (KeyStoreException e) {
            throw new KafkaException(e);
        }
        return all.toArray(new X509Certificate[0]);
    }

    private SslContext createNettySslServerContext() {
        try {
            if (this.keystore() == null) {
                throw new KafkaException("When using Netty in server mode, a keystore must be configured.");
            }
            DefaultSslEngineFactory.PrivateKeyData keystorePrivateKeyData = this.loadPrivateKeyData();
            X509Certificate[] truststoreCerts = this.truststore() == null ? null : this.loadAllCertificates();
            SslContextBuilder builder = SslContextBuilder.forServer((PrivateKey)keystorePrivateKeyData.key(), (X509Certificate[])keystorePrivateKeyData.certificateChain()).applicationProtocolConfig(ApplicationProtocolConfig.DISABLED).sslProvider(SslProvider.OPENSSL_REFCNT).trustManager(truststoreCerts);
            if (this.enabledProtocols() != null) {
                builder.protocols(this.enabledProtocols());
            }
            if (this.cipherSuites() != null) {
                builder.ciphers(Arrays.asList(this.cipherSuites()));
            }
            switch (this.sslClientAuth()) {
                case NONE: {
                    builder.clientAuth(ClientAuth.NONE);
                    break;
                }
                case REQUIRED: {
                    builder.clientAuth(ClientAuth.REQUIRE);
                    break;
                }
                case REQUESTED: {
                    builder.clientAuth(ClientAuth.OPTIONAL);
                }
            }
            log.info("Netty is enabled for SSL context with keystore {}, truststore {}.", (Object)this.keystore(), (Object)this.truststore());
            return builder.build();
        }
        catch (Exception e) {
            throw new KafkaException(e);
        }
    }

    static {
        InternalLoggerFactory.setDefaultFactory((InternalLoggerFactory)Log4JLoggerFactory.INSTANCE);
        System.setProperty("io.netty.handler.ssl.openssl.useTasks", "false");
    }

    class CloseableSslEngine
    implements Closeable {
        private final SSLEngine engine;

        CloseableSslEngine(SSLEngine engine) {
            this.engine = engine;
        }

        @Override
        public void close() throws IOException {
            if (this.engine instanceof ReferenceCountedOpenSslEngine) {
                ((ReferenceCountedOpenSslEngine)this.engine).release();
            }
        }
    }
}

