/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.audit;

import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.apache.kafka.common.security.auth.AuthenticationContext;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.utils.Lazy;
import org.apache.kafka.server.audit.AuditEventStatus;
import org.apache.kafka.server.audit.AuditEventType;
import org.apache.kafka.server.audit.AuthenticationEvent;

public class AuthenticationEventImpl
implements AuthenticationEvent {
    private final Instant timestamp;
    private final Lazy<UUID> lazyUUID;
    private final Optional<KafkaPrincipal> principal;
    private final AuthenticationContext authenticationContext;
    private final AuditEventStatus auditEventStatus;
    private Map<String, Object> data = new HashMap<String, Object>();

    public AuthenticationEventImpl(KafkaPrincipal principal, AuthenticationContext authenticationContext, AuditEventStatus auditEventStatus, Instant timestamp) {
        this.principal = Optional.of(principal);
        this.authenticationContext = authenticationContext;
        this.auditEventStatus = auditEventStatus;
        this.timestamp = timestamp;
        this.lazyUUID = new Lazy();
    }

    public AuthenticationEventImpl(KafkaPrincipal principal, AuthenticationContext authenticationContext, AuditEventStatus auditEventStatus) {
        this(principal, authenticationContext, auditEventStatus, Instant.now());
    }

    @Override
    public UUID uuid() {
        return this.lazyUUID.getOrCompute(UUID::randomUUID);
    }

    @Override
    public Instant timestamp() {
        return this.timestamp;
    }

    @Override
    public AuditEventType type() {
        return AuditEventType.AUTHENTICATION;
    }

    @Override
    public AuditEventStatus status() {
        return this.auditEventStatus;
    }

    @Override
    public Map<String, Object> data() {
        return this.data;
    }

    public void setData(Map<String, Object> data) {
        this.data = data;
    }

    @Override
    public Optional<KafkaPrincipal> principal() {
        return this.principal;
    }

    @Override
    public AuthenticationContext authenticationContext() {
        return this.authenticationContext;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthenticationEventImpl that = (AuthenticationEventImpl)o;
        return Objects.equals(this.timestamp, that.timestamp) && Objects.equals(this.lazyUUID, that.lazyUUID) && Objects.equals(this.principal, that.principal) && Objects.equals(this.authenticationContext, that.authenticationContext) && this.auditEventStatus == that.auditEventStatus && Objects.equals(this.data, that.data);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.timestamp, this.lazyUUID, this.principal, this.authenticationContext, this.auditEventStatus, this.data});
    }

    public String toString() {
        return "AuthenticationEventImpl{timestamp=" + this.timestamp + ", lazyUUID=" + this.lazyUUID + ", principal=" + this.principal + ", authenticationContext=" + this.authenticationContext + ", auditEventStatus=" + (Object)((Object)this.auditEventStatus) + ", data=" + this.data + '}';
    }
}

