/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.security.auth.plain;

import io.confluent.kafka.security.auth.plain.DynamicPlainCredential;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.AppConfigurationEntry;
import org.apache.kafka.common.Reconfigurable;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.security.auth.AuthenticateCallbackHandler;
import org.apache.kafka.common.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicPlainLoginCallbackHandler
implements AuthenticateCallbackHandler,
Reconfigurable {
    public static final String USERNAME_CONFIG = "username_config";
    public static final String PASSWORD_CONFIG = "password_config";
    static final DynamicPlainCredential EMPTY_CREDENTIAL = new DynamicPlainCredential(null, null);
    private static final Logger log = LoggerFactory.getLogger(DynamicPlainLoginCallbackHandler.class);
    protected String usernameConfig;
    protected String passwordConfig;
    private volatile DynamicPlainCredential currentCredential = EMPTY_CREDENTIAL;

    @Override
    public void configure(Map<String, ?> configs, String saslMechanism, List<AppConfigurationEntry> jaasConfigEntries) {
        log.debug("Configuring SASL/PLAIN login callback handler");
        if (!"PLAIN".equals(saslMechanism)) {
            throw new InvalidConfigurationException("Unexpected configuration with SASL mechanism " + saslMechanism);
        }
        if (jaasConfigEntries.size() != 1) {
            throw new InvalidConfigurationException("Only one JAAS configuration entry supported by this callback handler");
        }
        AppConfigurationEntry entry = jaasConfigEntries.get(0);
        this.usernameConfig = (String)entry.getOptions().get(USERNAME_CONFIG);
        this.passwordConfig = (String)entry.getOptions().get(PASSWORD_CONFIG);
        this.validateReconfiguration(configs);
        this.configureCredential(configs);
    }

    @Override
    public void configure(Map<String, ?> configs) {
    }

    @Override
    public Set<String> reconfigurableConfigs() {
        if (this.usernameConfig == null || this.passwordConfig == null) {
            return Collections.emptySet();
        }
        return Utils.mkSet(this.usernameConfig, this.passwordConfig);
    }

    @Override
    public void validateReconfiguration(Map<String, ?> configs) {
        if (configs.get(this.usernameConfig) == null) {
            throw new InvalidConfigurationException("User name not specified");
        }
        if (configs.get(this.passwordConfig) == null) {
            throw new InvalidConfigurationException("Password not specified");
        }
    }

    @Override
    public void reconfigure(Map<String, ?> configs) {
        log.debug("Reconfiguring SASL/PLAIN login callback handler");
        this.configureCredential(configs);
    }

    @Override
    public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
        for (Callback callback : callbacks) {
            if (callback instanceof NameCallback) {
                ((NameCallback)callback).setName(this.currentCredential.username());
                continue;
            }
            if (callback instanceof PasswordCallback) {
                ((PasswordCallback)callback).setPassword(this.currentCredential.password());
                continue;
            }
            log.error("Unexpected callback {}", (Object)callback);
            throw new UnsupportedCallbackException(callback);
        }
    }

    @Override
    public void close() {
        this.currentCredential = EMPTY_CREDENTIAL;
        log.debug("Closing SASL/PLAIN login callback handler");
    }

    protected void configureCredential(Map<String, ?> configs) {
        String name = (String)configs.get(this.usernameConfig);
        Object passwordObj = configs.get(this.passwordConfig);
        String password = passwordObj instanceof Password ? ((Password)passwordObj).value() : (String)passwordObj;
        this.currentCredential = new DynamicPlainCredential(name, password == null ? null : password.toCharArray());
    }
}

