/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.EntityType;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class DeleteClusterLinksRequestData
implements ApiMessage {
    List<String> linkNames;
    boolean validateOnly;
    boolean force;
    int timeoutMs;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0;
    public static final Schema SCHEMA_1;
    public static final Schema[] SCHEMAS;
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 1;

    public DeleteClusterLinksRequestData(Readable _readable, short _version, MessageContext _context) {
        this.read(_readable, _version, _context);
    }

    public DeleteClusterLinksRequestData() {
        this.linkNames = new ArrayList<String>(0);
        this.validateOnly = false;
        this.force = false;
        this.timeoutMs = 0;
    }

    @Override
    public short apiKey() {
        return 10004;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 1;
    }

    @Override
    public void read(Readable _readable, short _version, MessageContext _context) {
        int arrayLength = _readable.readUnsignedVarint() - 1;
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field linkNames was serialized as null");
        }
        ArrayList<String> newCollection = new ArrayList<String>(arrayLength);
        for (int i = 0; i < arrayLength; ++i) {
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field linkNames element was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field linkNames element had invalid length " + length);
            }
            newCollection.add(_context.read(EntityType.LINK_NAME, _readable.readString(length)));
        }
        this.linkNames = newCollection;
        this.validateOnly = _readable.readByte() != 0;
        this.force = _readable.readByte() != 0;
        this.timeoutMs = _readable.readInt();
        this._unknownTaggedFields = null;
        int _numTaggedFields = _readable.readUnsignedVarint();
        for (int _i = 0; _i < _numTaggedFields; ++_i) {
            int _tag = _readable.readUnsignedVarint();
            int _size = _readable.readUnsignedVarint();
            switch (_tag) {
                default: 
            }
            this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        _writable.writeUnsignedVarint(this.linkNames.size() + 1);
        for (String linkNamesElement : this.linkNames) {
            byte[] _stringBytes = _cache.getSerializedValue(linkNamesElement);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
        }
        _writable.writeByte(this.validateOnly ? (byte)1 : 0);
        _writable.writeByte(this.force ? (byte)1 : 0);
        _writable.writeInt(this.timeoutMs);
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
        _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
    }

    @Override
    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.linkNames.size() + 1));
        for (String linkNamesElement : this.linkNames) {
            byte[] _stringBytes = _context.write(EntityType.LINK_NAME, linkNamesElement).getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'linkNamesElement' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(linkNamesElement, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
        }
        _size.addBytes(1);
        _size.addBytes(1);
        _size.addBytes(4);
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                _size.addBytes(_field.size());
            }
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DeleteClusterLinksRequestData)) {
            return false;
        }
        DeleteClusterLinksRequestData other = (DeleteClusterLinksRequestData)obj;
        if (this.linkNames == null ? other.linkNames != null : !this.linkNames.equals(other.linkNames)) {
            return false;
        }
        if (this.validateOnly != other.validateOnly) {
            return false;
        }
        if (this.force != other.force) {
            return false;
        }
        if (this.timeoutMs != other.timeoutMs) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (this.linkNames == null ? 0 : this.linkNames.hashCode());
        hashCode = 31 * hashCode + (this.validateOnly ? 1231 : 1237);
        hashCode = 31 * hashCode + (this.force ? 1231 : 1237);
        hashCode = 31 * hashCode + this.timeoutMs;
        return hashCode;
    }

    @Override
    public DeleteClusterLinksRequestData duplicate() {
        DeleteClusterLinksRequestData _duplicate = new DeleteClusterLinksRequestData();
        ArrayList<String> newLinkNames = new ArrayList<String>(this.linkNames.size());
        for (String _element : this.linkNames) {
            newLinkNames.add(_element);
        }
        _duplicate.linkNames = newLinkNames;
        _duplicate.validateOnly = this.validateOnly;
        _duplicate.force = this.force;
        _duplicate.timeoutMs = this.timeoutMs;
        return _duplicate;
    }

    public String toString() {
        return "DeleteClusterLinksRequestData(linkNames=" + MessageUtil.deepToString(this.linkNames.iterator()) + ", validateOnly=" + (this.validateOnly ? "true" : "false") + ", force=" + (this.force ? "true" : "false") + ", timeoutMs=" + this.timeoutMs + ")";
    }

    public List<String> linkNames() {
        return this.linkNames;
    }

    public boolean validateOnly() {
        return this.validateOnly;
    }

    public boolean force() {
        return this.force;
    }

    public int timeoutMs() {
        return this.timeoutMs;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public DeleteClusterLinksRequestData setLinkNames(List<String> v) {
        this.linkNames = v;
        return this;
    }

    public DeleteClusterLinksRequestData setValidateOnly(boolean v) {
        this.validateOnly = v;
        return this;
    }

    public DeleteClusterLinksRequestData setForce(boolean v) {
        this.force = v;
        return this;
    }

    public DeleteClusterLinksRequestData setTimeoutMs(int v) {
        this.timeoutMs = v;
        return this;
    }

    static {
        SCHEMA_1 = SCHEMA_0 = new Schema(new Field("link_names", new CompactArrayOf(Type.COMPACT_STRING), "The names of the cluster links to delete."), new Field("validate_only", Type.BOOLEAN, "Whether to validate that the cluster links can be created, but not actually create them."), new Field("force", Type.BOOLEAN, "Whether to force deletion of the cluster link even if it's in use."), new Field("timeout_ms", Type.INT32, "The time, in milliseconds, to allow for request completion."), Field.TaggedFieldsSection.of(new Object[0]));
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};
    }
}

