/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.EntityType;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.ImplicitLinkedHashMultiCollection;

public class OffsetForLeaderEpochRequestData
implements ApiMessage {
    int replicaId;
    OffsetForLeaderTopicCollection topics;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0;
    public static final Schema SCHEMA_1;
    public static final Schema SCHEMA_2;
    public static final Schema SCHEMA_3;
    public static final Schema SCHEMA_4;
    public static final Schema[] SCHEMAS;
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 4;

    public OffsetForLeaderEpochRequestData(Readable _readable, short _version, MessageContext _context) {
        this.read(_readable, _version, _context);
    }

    public OffsetForLeaderEpochRequestData() {
        this.replicaId = -2;
        this.topics = new OffsetForLeaderTopicCollection(0);
    }

    @Override
    public short apiKey() {
        return 23;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 4;
    }

    @Override
    public void read(Readable _readable, short _version, MessageContext _context) {
        int i;
        OffsetForLeaderTopicCollection newCollection;
        int arrayLength;
        this.replicaId = _version >= 3 ? _readable.readInt() : -2;
        if (_version >= 4) {
            arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field topics was serialized as null");
            }
            newCollection = new OffsetForLeaderTopicCollection(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(new OffsetForLeaderTopic(_readable, _version, _context));
            }
            this.topics = newCollection;
        } else {
            arrayLength = _readable.readInt();
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field topics was serialized as null");
            }
            newCollection = new OffsetForLeaderTopicCollection(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(new OffsetForLeaderTopic(_readable, _version, _context));
            }
            this.topics = newCollection;
        }
        this._unknownTaggedFields = null;
        if (_version >= 4) {
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        if (_version >= 3) {
            _writable.writeInt(this.replicaId);
        }
        if (_version >= 4) {
            _writable.writeUnsignedVarint(this.topics.size() + 1);
            for (OffsetForLeaderTopic topicsElement : this.topics) {
                topicsElement.write(_writable, _cache, _version, _context);
            }
        } else {
            _writable.writeInt(this.topics.size());
            for (OffsetForLeaderTopic topicsElement : this.topics) {
                topicsElement.write(_writable, _cache, _version, _context);
            }
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _numTaggedFields += _rawWriter.numFields();
        if (_version >= 4) {
            _writable.writeUnsignedVarint(_numTaggedFields);
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    @Override
    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        if (_version >= 3) {
            _size.addBytes(4);
        }
        if (_version >= 4) {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.topics.size() + 1));
        } else {
            _size.addBytes(4);
        }
        for (OffsetForLeaderTopic topicsElement : this.topics) {
            topicsElement.addSize(_size, _cache, _version, _context);
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                _size.addBytes(_field.size());
            }
        }
        if (_version >= 4) {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof OffsetForLeaderEpochRequestData)) {
            return false;
        }
        OffsetForLeaderEpochRequestData other = (OffsetForLeaderEpochRequestData)obj;
        if (this.replicaId != other.replicaId) {
            return false;
        }
        if (this.topics == null ? other.topics != null : !this.topics.equals(other.topics)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.replicaId;
        hashCode = 31 * hashCode + (this.topics == null ? 0 : this.topics.hashCode());
        return hashCode;
    }

    @Override
    public OffsetForLeaderEpochRequestData duplicate() {
        OffsetForLeaderEpochRequestData _duplicate = new OffsetForLeaderEpochRequestData();
        _duplicate.replicaId = this.replicaId;
        OffsetForLeaderTopicCollection newTopics = new OffsetForLeaderTopicCollection(this.topics.size());
        for (OffsetForLeaderTopic _element : this.topics) {
            newTopics.add(_element.duplicate());
        }
        _duplicate.topics = newTopics;
        return _duplicate;
    }

    public String toString() {
        return "OffsetForLeaderEpochRequestData(replicaId=" + this.replicaId + ", topics=" + MessageUtil.deepToString(this.topics.iterator()) + ")";
    }

    public int replicaId() {
        return this.replicaId;
    }

    public OffsetForLeaderTopicCollection topics() {
        return this.topics;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public OffsetForLeaderEpochRequestData setReplicaId(int v) {
        this.replicaId = v;
        return this;
    }

    public OffsetForLeaderEpochRequestData setTopics(OffsetForLeaderTopicCollection v) {
        this.topics = v;
        return this;
    }

    static {
        SCHEMA_1 = SCHEMA_0 = new Schema(new Field("topics", new ArrayOf(OffsetForLeaderTopic.SCHEMA_0), "Each topic to get offsets for."));
        SCHEMA_2 = new Schema(new Field("topics", new ArrayOf(OffsetForLeaderTopic.SCHEMA_2), "Each topic to get offsets for."));
        SCHEMA_3 = new Schema(new Field("replica_id", Type.INT32, "The broker ID of the follower, of -1 if this request is from a consumer."), new Field("topics", new ArrayOf(OffsetForLeaderTopic.SCHEMA_2), "Each topic to get offsets for."));
        SCHEMA_4 = new Schema(new Field("replica_id", Type.INT32, "The broker ID of the follower, of -1 if this request is from a consumer."), new Field("topics", new CompactArrayOf(OffsetForLeaderTopic.SCHEMA_4), "Each topic to get offsets for."), Field.TaggedFieldsSection.of(new Object[0]));
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4};
    }

    public static class OffsetForLeaderTopicCollection
    extends ImplicitLinkedHashMultiCollection<OffsetForLeaderTopic> {
        public OffsetForLeaderTopicCollection() {
        }

        public OffsetForLeaderTopicCollection(int expectedNumElements) {
            super(expectedNumElements);
        }

        public OffsetForLeaderTopicCollection(Iterator<OffsetForLeaderTopic> iterator) {
            super(iterator);
        }

        @Override
        public OffsetForLeaderTopic find(String topic) {
            OffsetForLeaderTopic _key = new OffsetForLeaderTopic();
            _key.setTopic(topic);
            return this.find(_key);
        }

        @Override
        public List<OffsetForLeaderTopic> findAll(String topic) {
            OffsetForLeaderTopic _key = new OffsetForLeaderTopic();
            _key.setTopic(topic);
            return this.findAll(_key);
        }

        public OffsetForLeaderTopicCollection duplicate() {
            OffsetForLeaderTopicCollection _duplicate = new OffsetForLeaderTopicCollection(this.size());
            for (OffsetForLeaderTopic _element : this) {
                _duplicate.add(_element.duplicate());
            }
            return _duplicate;
        }
    }

    public static class OffsetForLeaderPartition
    implements Message {
        int partition;
        int currentLeaderEpoch;
        int leaderEpoch;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema SCHEMA_4;
        public static final Schema[] SCHEMAS;
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 4;

        public OffsetForLeaderPartition(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public OffsetForLeaderPartition() {
            this.partition = 0;
            this.currentLeaderEpoch = -1;
            this.leaderEpoch = 0;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 4;
        }

        @Override
        public void read(Readable _readable, short _version, MessageContext _context) {
            if (_version > 4) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of OffsetForLeaderPartition");
            }
            this.partition = _readable.readInt();
            this.currentLeaderEpoch = _version >= 2 ? _readable.readInt() : -1;
            this.leaderEpoch = _readable.readInt();
            this._unknownTaggedFields = null;
            if (_version >= 4) {
                int _numTaggedFields = _readable.readUnsignedVarint();
                for (int _i = 0; _i < _numTaggedFields; ++_i) {
                    int _tag = _readable.readUnsignedVarint();
                    int _size = _readable.readUnsignedVarint();
                    switch (_tag) {
                        default: 
                    }
                    this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                }
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            _writable.writeInt(this.partition);
            if (_version >= 2) {
                _writable.writeInt(this.currentLeaderEpoch);
            }
            _writable.writeInt(this.leaderEpoch);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _numTaggedFields += _rawWriter.numFields();
            if (_version >= 4) {
                _writable.writeUnsignedVarint(_numTaggedFields);
                _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (_version > 4) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of OffsetForLeaderPartition");
            }
            _size.addBytes(4);
            if (_version >= 2) {
                _size.addBytes(4);
            }
            _size.addBytes(4);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            if (_version >= 4) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof OffsetForLeaderPartition)) {
                return false;
            }
            OffsetForLeaderPartition other = (OffsetForLeaderPartition)obj;
            if (this.partition != other.partition) {
                return false;
            }
            if (this.currentLeaderEpoch != other.currentLeaderEpoch) {
                return false;
            }
            if (this.leaderEpoch != other.leaderEpoch) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.partition;
            hashCode = 31 * hashCode + this.currentLeaderEpoch;
            hashCode = 31 * hashCode + this.leaderEpoch;
            return hashCode;
        }

        @Override
        public OffsetForLeaderPartition duplicate() {
            OffsetForLeaderPartition _duplicate = new OffsetForLeaderPartition();
            _duplicate.partition = this.partition;
            _duplicate.currentLeaderEpoch = this.currentLeaderEpoch;
            _duplicate.leaderEpoch = this.leaderEpoch;
            return _duplicate;
        }

        public String toString() {
            return "OffsetForLeaderPartition(partition=" + this.partition + ", currentLeaderEpoch=" + this.currentLeaderEpoch + ", leaderEpoch=" + this.leaderEpoch + ")";
        }

        public int partition() {
            return this.partition;
        }

        public int currentLeaderEpoch() {
            return this.currentLeaderEpoch;
        }

        public int leaderEpoch() {
            return this.leaderEpoch;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public OffsetForLeaderPartition setPartition(int v) {
            this.partition = v;
            return this;
        }

        public OffsetForLeaderPartition setCurrentLeaderEpoch(int v) {
            this.currentLeaderEpoch = v;
            return this;
        }

        public OffsetForLeaderPartition setLeaderEpoch(int v) {
            this.leaderEpoch = v;
            return this;
        }

        static {
            SCHEMA_1 = SCHEMA_0 = new Schema(new Field("partition", Type.INT32, "The partition index."), new Field("leader_epoch", Type.INT32, "The epoch to look up an offset for."));
            SCHEMA_3 = SCHEMA_2 = new Schema(new Field("partition", Type.INT32, "The partition index."), new Field("current_leader_epoch", Type.INT32, "An epoch used to fence consumers/replicas with old metadata. If the epoch provided by the client is larger than the current epoch known to the broker, then the UNKNOWN_LEADER_EPOCH error code will be returned. If the provided epoch is smaller, then the FENCED_LEADER_EPOCH error code will be returned."), new Field("leader_epoch", Type.INT32, "The epoch to look up an offset for."));
            SCHEMA_4 = new Schema(new Field("partition", Type.INT32, "The partition index."), new Field("current_leader_epoch", Type.INT32, "An epoch used to fence consumers/replicas with old metadata. If the epoch provided by the client is larger than the current epoch known to the broker, then the UNKNOWN_LEADER_EPOCH error code will be returned. If the provided epoch is smaller, then the FENCED_LEADER_EPOCH error code will be returned."), new Field("leader_epoch", Type.INT32, "The epoch to look up an offset for."), Field.TaggedFieldsSection.of(new Object[0]));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4};
        }
    }

    public static class OffsetForLeaderTopic
    implements Message,
    ImplicitLinkedHashCollection.Element {
        String topic;
        List<OffsetForLeaderPartition> partitions;
        private List<RawTaggedField> _unknownTaggedFields;
        private int next;
        private int prev;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema SCHEMA_4;
        public static final Schema[] SCHEMAS;
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 4;

        public OffsetForLeaderTopic(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
            this.prev = -2;
            this.next = -2;
        }

        public OffsetForLeaderTopic() {
            this.topic = "";
            this.partitions = new ArrayList<OffsetForLeaderPartition>(0);
            this.prev = -2;
            this.next = -2;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 4;
        }

        @Override
        public void read(Readable _readable, short _version, MessageContext _context) {
            int i;
            ArrayList<OffsetForLeaderPartition> newCollection;
            int arrayLength;
            if (_version > 4) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of OffsetForLeaderTopic");
            }
            int length = _version >= 4 ? _readable.readUnsignedVarint() - 1 : _readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field topic was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field topic had invalid length " + length);
            }
            this.topic = _context.read(EntityType.TOPIC_NAME, _readable.readString(length));
            if (_version >= 4) {
                arrayLength = _readable.readUnsignedVarint() - 1;
                if (arrayLength < 0) {
                    throw new RuntimeException("non-nullable field partitions was serialized as null");
                }
                newCollection = new ArrayList(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    newCollection.add(new OffsetForLeaderPartition(_readable, _version, _context));
                }
                this.partitions = newCollection;
            } else {
                arrayLength = _readable.readInt();
                if (arrayLength < 0) {
                    throw new RuntimeException("non-nullable field partitions was serialized as null");
                }
                newCollection = new ArrayList<OffsetForLeaderPartition>(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    newCollection.add(new OffsetForLeaderPartition(_readable, _version, _context));
                }
                this.partitions = newCollection;
            }
            this._unknownTaggedFields = null;
            if (_version >= 4) {
                int _numTaggedFields = _readable.readUnsignedVarint();
                for (int _i = 0; _i < _numTaggedFields; ++_i) {
                    int _tag = _readable.readUnsignedVarint();
                    int _size = _readable.readUnsignedVarint();
                    switch (_tag) {
                        default: 
                    }
                    this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                }
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            Object _stringBytes = _cache.getSerializedValue(this.topic);
            if (_version >= 4) {
                _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            } else {
                _writable.writeShort((short)((byte[])_stringBytes).length);
            }
            _writable.writeByteArray((byte[])_stringBytes);
            if (_version >= 4) {
                _writable.writeUnsignedVarint(this.partitions.size() + 1);
                _stringBytes = this.partitions.iterator();
                while (_stringBytes.hasNext()) {
                    OffsetForLeaderPartition partitionsElement = (OffsetForLeaderPartition)_stringBytes.next();
                    partitionsElement.write(_writable, _cache, _version, _context);
                }
            } else {
                _writable.writeInt(this.partitions.size());
                _stringBytes = this.partitions.iterator();
                while (_stringBytes.hasNext()) {
                    OffsetForLeaderPartition partitionsElement = (OffsetForLeaderPartition)_stringBytes.next();
                    partitionsElement.write(_writable, _cache, _version, _context);
                }
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _numTaggedFields += _rawWriter.numFields();
            if (_version >= 4) {
                _writable.writeUnsignedVarint(_numTaggedFields);
                _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (_version > 4) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of OffsetForLeaderTopic");
            }
            byte[] _stringBytes = _context.write(EntityType.TOPIC_NAME, this.topic).getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'topic' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.topic, _stringBytes);
            if (_version >= 4) {
                _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            } else {
                _size.addBytes(_stringBytes.length + 2);
            }
            if (_version >= 4) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.partitions.size() + 1));
            } else {
                _size.addBytes(4);
            }
            for (OffsetForLeaderPartition partitionsElement : this.partitions) {
                partitionsElement.addSize(_size, _cache, _version, _context);
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            if (_version >= 4) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public boolean elementKeysAreEqual(Object obj) {
            if (!(obj instanceof OffsetForLeaderTopic)) {
                return false;
            }
            OffsetForLeaderTopic other = (OffsetForLeaderTopic)obj;
            return !(this.topic == null ? other.topic != null : !this.topic.equals(other.topic));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof OffsetForLeaderTopic)) {
                return false;
            }
            OffsetForLeaderTopic other = (OffsetForLeaderTopic)obj;
            if (this.topic == null ? other.topic != null : !this.topic.equals(other.topic)) {
                return false;
            }
            if (this.partitions == null ? other.partitions != null : !this.partitions.equals(other.partitions)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.topic == null ? 0 : this.topic.hashCode());
            return hashCode;
        }

        @Override
        public OffsetForLeaderTopic duplicate() {
            OffsetForLeaderTopic _duplicate = new OffsetForLeaderTopic();
            _duplicate.topic = this.topic;
            ArrayList<OffsetForLeaderPartition> newPartitions = new ArrayList<OffsetForLeaderPartition>(this.partitions.size());
            for (OffsetForLeaderPartition _element : this.partitions) {
                newPartitions.add(_element.duplicate());
            }
            _duplicate.partitions = newPartitions;
            return _duplicate;
        }

        public String toString() {
            return "OffsetForLeaderTopic(topic=" + (this.topic == null ? "null" : "'" + this.topic.toString() + "'") + ", partitions=" + MessageUtil.deepToString(this.partitions.iterator()) + ")";
        }

        public String topic() {
            return this.topic;
        }

        public List<OffsetForLeaderPartition> partitions() {
            return this.partitions;
        }

        @Override
        public int next() {
            return this.next;
        }

        @Override
        public int prev() {
            return this.prev;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public OffsetForLeaderTopic setTopic(String v) {
            this.topic = v;
            return this;
        }

        public OffsetForLeaderTopic setPartitions(List<OffsetForLeaderPartition> v) {
            this.partitions = v;
            return this;
        }

        @Override
        public void setNext(int v) {
            this.next = v;
        }

        @Override
        public void setPrev(int v) {
            this.prev = v;
        }

        static {
            SCHEMA_1 = SCHEMA_0 = new Schema(new Field("topic", Type.STRING, "The topic name."), new Field("partitions", new ArrayOf(OffsetForLeaderPartition.SCHEMA_0), "Each partition to get offsets for."));
            SCHEMA_3 = SCHEMA_2 = new Schema(new Field("topic", Type.STRING, "The topic name."), new Field("partitions", new ArrayOf(OffsetForLeaderPartition.SCHEMA_2), "Each partition to get offsets for."));
            SCHEMA_4 = new Schema(new Field("topic", Type.COMPACT_STRING, "The topic name."), new Field("partitions", new CompactArrayOf(OffsetForLeaderPartition.SCHEMA_4), "Each partition to get offsets for."), Field.TaggedFieldsSection.of(new Object[0]));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4};
        }
    }
}

