/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.message.OffsetForLeaderEpochResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.requests.AbstractResponse;

public class OffsetsForLeaderEpochResponse
extends AbstractResponse {
    public static final long UNDEFINED_EPOCH_OFFSET = -1L;
    public static final int UNDEFINED_EPOCH = -1;
    private final OffsetForLeaderEpochResponseData data;

    public OffsetsForLeaderEpochResponse(OffsetForLeaderEpochResponseData data) {
        super(ApiKeys.OFFSET_FOR_LEADER_EPOCH);
        this.data = data;
    }

    @Override
    public OffsetForLeaderEpochResponseData data() {
        return this.data;
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        HashMap<Errors, Integer> errorCounts = new HashMap<Errors, Integer>();
        this.data.topics().forEach(topic -> topic.partitions().forEach(partition -> this.updateErrorCounts(errorCounts, Errors.forCode(partition.errorCode()))));
        return errorCounts;
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    public static OffsetsForLeaderEpochResponse parse(ByteBuffer buffer, short version, MessageContext context) {
        return new OffsetsForLeaderEpochResponse(new OffsetForLeaderEpochResponseData(new ByteBufferAccessor(buffer), version, context));
    }

    @Override
    public String toString() {
        return this.data.toString();
    }
}

