/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.apache.kafka.clients.admin.internals.CoordinatorKey;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.annotation.InterfaceStability;

@InterfaceStability.Evolving
public class ListConsumerGroupOffsetsResult {
    final KafkaFuture<Map<TopicPartition, OffsetAndMetadata>> future;
    final Map<CoordinatorKey, KafkaFuture<Map<TopicPartition, OffsetAndMetadata>>> futures;

    ListConsumerGroupOffsetsResult(KafkaFuture<Map<TopicPartition, OffsetAndMetadata>> future) {
        this.future = future;
        this.futures = null;
    }

    ListConsumerGroupOffsetsResult(Map<CoordinatorKey, KafkaFuture<Map<TopicPartition, OffsetAndMetadata>>> futures) {
        this.futures = futures;
        this.future = null;
    }

    public KafkaFuture<Map<TopicPartition, OffsetAndMetadata>> partitionsToOffsetAndMetadata() {
        if (this.future == null) {
            throw new IllegalStateException("Requested future is null. Multiple consumer groups' offsets may have been requested. Use groupIdsToPartitionsAndOffsetAndMetadata() instead to get futures.");
        }
        return this.future;
    }

    public Map<String, KafkaFuture<Map<TopicPartition, OffsetAndMetadata>>> groupIdsToPartitionsAndOffsetAndMetadata() {
        if (this.futures == null) {
            throw new IllegalStateException("Requested futures are null. Single consumer group offsets may have been requested. Use partitionsToOffsetAndMetadata() to get future.");
        }
        HashMap<String, KafkaFuture<Map<TopicPartition, OffsetAndMetadata>>> listedConsumerGroupOffsets = new HashMap<String, KafkaFuture<Map<TopicPartition, OffsetAndMetadata>>>(this.futures.size());
        this.futures.forEach((key, future) -> listedConsumerGroupOffsets.put(key.idValue, (KafkaFuture<Map<TopicPartition, OffsetAndMetadata>>)future));
        return listedConsumerGroupOffsets;
    }

    public KafkaFuture<Map<String, Map<TopicPartition, OffsetAndMetadata>>> all() {
        if (this.futures == null) {
            throw new IllegalStateException("Requested futures are null. Single consumer group offsets may have been requested. Use partitionsToOffsetAndMetadata() to get future.");
        }
        return KafkaFuture.allOf(this.futures.values().toArray(new KafkaFuture[0])).thenApply(nil -> {
            HashMap listedConsumerGroupOffsets = new HashMap(this.futures.size());
            this.futures.forEach((key, future) -> {
                try {
                    listedConsumerGroupOffsets.put(key.idValue, future.get());
                }
                catch (InterruptedException | ExecutionException e) {
                    throw new RuntimeException(e);
                }
            });
            return listedConsumerGroupOffsets;
        });
    }
}

