/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin;

import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.annotation.InterfaceStability;
import org.apache.kafka.common.utils.Utils;

@InterfaceStability.Evolving
public class MirrorTopicDescription {
    private final String linkName;
    private final Uuid linkId;
    private final String mirrorTopic;
    private final int numPartitions;
    private final State state;
    private final long stateTimeMs;
    private final List<Long> stoppedLogEndOffsets;

    @Deprecated
    public MirrorTopicDescription(String linkName, UUID linkId, String mirrorTopic, int numPartitions, State state, long stateTimeMs, List<Long> stoppedLogEndOffsets) {
        this(linkName, Utils.toKafkaUuid(linkId), mirrorTopic, numPartitions, state, stateTimeMs, stoppedLogEndOffsets);
    }

    public MirrorTopicDescription(String linkName, Uuid linkId, String mirrorTopic, int numPartitions, State state, long stateTimeMs, List<Long> stoppedLogEndOffsets) {
        this.linkName = Objects.requireNonNull(linkName);
        this.linkId = Objects.requireNonNull(linkId);
        this.mirrorTopic = Objects.requireNonNull(mirrorTopic);
        this.numPartitions = numPartitions;
        this.state = Objects.requireNonNull(state);
        this.stateTimeMs = stateTimeMs;
        this.stoppedLogEndOffsets = Objects.requireNonNull(stoppedLogEndOffsets);
    }

    public String linkName() {
        return this.linkName;
    }

    @Deprecated
    public UUID linkId() {
        return Utils.toJavaUuid(this.linkId);
    }

    public Uuid clusterLinkId() {
        return this.linkId;
    }

    public String mirrorTopic() {
        return this.mirrorTopic;
    }

    public int numPartitions() {
        return this.numPartitions;
    }

    public State state() {
        return this.state;
    }

    public long stateTimeMs() {
        return this.stateTimeMs;
    }

    public List<Long> stoppedLogEndOffsets() {
        return this.stoppedLogEndOffsets;
    }

    public String toString() {
        return "(linkName=" + this.linkName + ", linkId=" + this.linkId + ", mirrorTopic=" + this.mirrorTopic + ", numPartitions=" + this.numPartitions + ", state=" + (Object)((Object)this.state) + ", stateTimeMs=" + this.stateTimeMs + ", stoppedLogEndOffsets=" + this.stoppedLogEndOffsets + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MirrorTopicDescription that = (MirrorTopicDescription)o;
        return Objects.equals(this.linkName, that.linkName) && Objects.equals(this.linkId, that.linkId) && Objects.equals(this.mirrorTopic, that.mirrorTopic) && Objects.equals(this.numPartitions, that.numPartitions) && Objects.equals((Object)this.state, (Object)that.state) && Objects.equals(this.stateTimeMs, that.stateTimeMs) && Objects.equals(this.stoppedLogEndOffsets, that.stoppedLogEndOffsets);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.linkName, this.linkId, this.mirrorTopic, this.numPartitions, this.state, this.stateTimeMs});
    }

    public static enum State {
        UNKNOWN,
        ACTIVE,
        PENDING_STOPPED,
        STOPPED,
        FAILED,
        PAUSED,
        SOURCE_UNAVAILABLE,
        LINK_FAILED,
        LINK_PAUSED;

    }
}

