/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common;

import java.util.Collections;
import java.util.Map;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.utils.Utils;

public class ConfluentNode
extends Node {
    private final Map<String, String> tags;

    public ConfluentNode(int id, String host, int port, String rack, Map<String, String> tags) {
        super(id, host, port, rack);
        this.tags = Collections.unmodifiableMap(tags);
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public String toString() {
        return this.host + ":" + this.port + " (id: " + this.idString + " rack: " + this.rack + " tags: " + Utils.mkString(this.tags, "[", "]", "=", ", ") + ")";
    }

    public static Map<String, String> tags(Node node) {
        if (node instanceof ConfluentNode) {
            return ((ConfluentNode)node).tags();
        }
        return Collections.emptyMap();
    }
}

