/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.resource;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.kafka.common.annotation.InterfaceStability;

@InterfaceStability.Evolving
public enum PatternType {
    UNKNOWN(0),
    ANY(1),
    MATCH(2),
    LITERAL(3),
    PREFIXED(4),
    CONFLUENT_ALL_TENANT_LITERAL(101),
    CONFLUENT_ALL_TENANT_PREFIXED(102),
    CONFLUENT_ALL_TENANT_ANY(103),
    CONFLUENT_ONLY_TENANT_MATCH(104);

    private static final Map<Byte, PatternType> CODE_TO_VALUE;
    private static final Map<String, PatternType> NAME_TO_VALUE;
    private final byte code;

    private PatternType(byte code) {
        this.code = code;
    }

    public byte code() {
        return this.code;
    }

    public boolean isUnknown() {
        return this == UNKNOWN;
    }

    public boolean isSpecific() {
        return this != UNKNOWN && this != ANY && this != MATCH && !this.isTenantPrefixed();
    }

    public boolean isTenantPrefixed() {
        return this == CONFLUENT_ALL_TENANT_LITERAL || this == CONFLUENT_ALL_TENANT_PREFIXED || this == CONFLUENT_ALL_TENANT_ANY || this == CONFLUENT_ONLY_TENANT_MATCH;
    }

    public static PatternType fromCode(byte code) {
        return CODE_TO_VALUE.getOrDefault(code, UNKNOWN);
    }

    public static PatternType fromString(String name) {
        return NAME_TO_VALUE.getOrDefault(name, UNKNOWN);
    }

    static {
        CODE_TO_VALUE = Collections.unmodifiableMap(Arrays.stream(PatternType.values()).collect(Collectors.toMap(PatternType::code, Function.identity())));
        NAME_TO_VALUE = Collections.unmodifiableMap(Arrays.stream(PatternType.values()).collect(Collectors.toMap(Enum::name, Function.identity())));
    }
}

