/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class ComputeEvenClusterLoadPlanResponseData
implements ApiMessage {
    int throttleTimeMs;
    short errorCode;
    String errorMessage;
    int interBrokerMoves;
    double interBrokerMovesMB;
    int leadershipMoves;
    int recentWindows;
    double partitionCoveragePercent;
    List<Integer> newBrokers;
    List<Integer> deadOrRemovedBrokers;
    List<String> violatedGoalsBeforeOptimization;
    List<String> violatedGoalsAfterOptimization;
    List<String> movementGeneratingGoals;
    List<String> excludedTopics;
    List<Integer> brokersExcludedForLeadership;
    List<Integer> brokersExcludedForReplicaMove;
    int totalBrokers;
    int totalReplicas;
    int totalTopics;
    double balancednessScorePreRebalance;
    double balancednessScorePostRebalance;
    List<GoalStat> goalStats;
    List<PreBrokerStat> clusterLoadPreRebalance;
    List<PostBrokerStat> clusterLoadPostRebalance;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("throttle_time_ms", (Type)Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("error_code", (Type)Type.INT16, "The error code."), new Field("error_message", (Type)Type.COMPACT_NULLABLE_STRING, "The error message, or null if there was no error."), new Field("inter_broker_moves", (Type)Type.INT32, "Total amount of inter-broker moves."), new Field("inter_broker_moves_mb", (Type)Type.FLOAT64, "Inter-broker moves in MB."), new Field("leadership_moves", (Type)Type.INT32, "Leadership moves in the plan."), new Field("recent_windows", (Type)Type.INT32, "Recent number of windows over which the plan is computed."), new Field("partition_coverage_percent", (Type)Type.FLOAT64, "Percentage of total partitions covered in the computed plan."), new Field("new_brokers", (Type)new CompactArrayOf((Type)Type.INT32), "New brokers in the cluster."), new Field("dead_or_removed_brokers", (Type)new CompactArrayOf((Type)Type.INT32), "Dead or removed brokers in the cluster."), new Field("violated_goals_before_optimization", (Type)new CompactArrayOf((Type)Type.COMPACT_STRING), "Goals violated before optimization."), new Field("violated_goals_after_optimization", (Type)new CompactArrayOf((Type)Type.COMPACT_STRING), "Goals violated after optimization."), new Field("movement_generating_goals", (Type)new CompactArrayOf((Type)Type.COMPACT_STRING), "Goals that generate partition movements as part of the optimization."), new Field("excluded_topics", (Type)new CompactArrayOf((Type)Type.COMPACT_STRING), "Topics excluded from the optimization."), new Field("brokers_excluded_for_leadership", (Type)new CompactArrayOf((Type)Type.INT32), "Brokers excluded for leadership in the optimization."), new Field("brokers_excluded_for_replica_move", (Type)new CompactArrayOf((Type)Type.INT32), "Brokers excluded for moving replicas in and out them."), new Field("total_brokers", (Type)Type.INT32, "Total brokers in the cluster."), new Field("total_replicas", (Type)Type.INT32, "Total replicas in the cluster."), new Field("total_topics", (Type)Type.INT32, "Total topics in the cluster."), new Field("balancedness_score_pre_rebalance", (Type)Type.FLOAT64, "Balancedness score before rebalance."), new Field("balancedness_score_post_rebalance", (Type)Type.FLOAT64, "Balancedness score after rebalance."), new Field("goal_stats", (Type)new CompactArrayOf((Type)GoalStat.SCHEMA_0), "Goals stats after rebalance."), new Field("cluster_load_pre_rebalance", (Type)new CompactArrayOf((Type)PreBrokerStat.SCHEMA_0), "Response for the even cluster load before a rebalance."), new Field("cluster_load_post_rebalance", (Type)new CompactArrayOf((Type)PostBrokerStat.SCHEMA_0), "Response for the even cluster load after a rebalance."), Field.TaggedFieldsSection.of((Object[])new Object[0])});
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 0;

    public ComputeEvenClusterLoadPlanResponseData(Readable _readable, short _version, MessageContext _context) {
        this.read(_readable, _version, _context);
    }

    public ComputeEvenClusterLoadPlanResponseData() {
        this.throttleTimeMs = 0;
        this.errorCode = 0;
        this.errorMessage = "";
        this.interBrokerMoves = 0;
        this.interBrokerMovesMB = 0.0;
        this.leadershipMoves = 0;
        this.recentWindows = 0;
        this.partitionCoveragePercent = 0.0;
        this.newBrokers = new ArrayList<Integer>(0);
        this.deadOrRemovedBrokers = new ArrayList<Integer>(0);
        this.violatedGoalsBeforeOptimization = new ArrayList<String>(0);
        this.violatedGoalsAfterOptimization = new ArrayList<String>(0);
        this.movementGeneratingGoals = new ArrayList<String>(0);
        this.excludedTopics = new ArrayList<String>(0);
        this.brokersExcludedForLeadership = new ArrayList<Integer>(0);
        this.brokersExcludedForReplicaMove = new ArrayList<Integer>(0);
        this.totalBrokers = 0;
        this.totalReplicas = 0;
        this.totalTopics = 0;
        this.balancednessScorePreRebalance = 0.0;
        this.balancednessScorePostRebalance = 0.0;
        this.goalStats = new ArrayList<GoalStat>(0);
        this.clusterLoadPreRebalance = new ArrayList<PreBrokerStat>(0);
        this.clusterLoadPostRebalance = new ArrayList<PostBrokerStat>(0);
    }

    public short apiKey() {
        return 10024;
    }

    public short lowestSupportedVersion() {
        return 0;
    }

    public short highestSupportedVersion() {
        return 0;
    }

    public void read(Readable _readable, short _version, MessageContext _context) {
        int length;
        int i;
        this.throttleTimeMs = _readable.readInt();
        this.errorCode = _readable.readShort();
        int length2 = _readable.readUnsignedVarint() - 1;
        if (length2 < 0) {
            this.errorMessage = null;
        } else {
            if (length2 > Short.MAX_VALUE) {
                throw new RuntimeException("string field errorMessage had invalid length " + length2);
            }
            this.errorMessage = _readable.readString(length2);
        }
        this.interBrokerMoves = _readable.readInt();
        this.interBrokerMovesMB = _readable.readDouble();
        this.leadershipMoves = _readable.readInt();
        this.recentWindows = _readable.readInt();
        this.partitionCoveragePercent = _readable.readDouble();
        int arrayLength = _readable.readUnsignedVarint() - 1;
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field newBrokers was serialized as null");
        }
        if (arrayLength > _readable.remaining()) {
            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
        }
        ArrayList<Integer> newCollection = new ArrayList<Integer>(arrayLength);
        for (i = 0; i < arrayLength; ++i) {
            newCollection.add(_readable.readInt());
        }
        this.newBrokers = newCollection;
        arrayLength = _readable.readUnsignedVarint() - 1;
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field deadOrRemovedBrokers was serialized as null");
        }
        if (arrayLength > _readable.remaining()) {
            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
        }
        newCollection = new ArrayList(arrayLength);
        for (i = 0; i < arrayLength; ++i) {
            newCollection.add(_readable.readInt());
        }
        this.deadOrRemovedBrokers = newCollection;
        arrayLength = _readable.readUnsignedVarint() - 1;
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field violatedGoalsBeforeOptimization was serialized as null");
        }
        if (arrayLength > _readable.remaining()) {
            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
        }
        newCollection = new ArrayList(arrayLength);
        for (i = 0; i < arrayLength; ++i) {
            length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field violatedGoalsBeforeOptimization element was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field violatedGoalsBeforeOptimization element had invalid length " + length);
            }
            newCollection.add((Integer)((Object)_readable.readString(length)));
        }
        this.violatedGoalsBeforeOptimization = newCollection;
        arrayLength = _readable.readUnsignedVarint() - 1;
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field violatedGoalsAfterOptimization was serialized as null");
        }
        if (arrayLength > _readable.remaining()) {
            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
        }
        newCollection = new ArrayList(arrayLength);
        for (i = 0; i < arrayLength; ++i) {
            length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field violatedGoalsAfterOptimization element was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field violatedGoalsAfterOptimization element had invalid length " + length);
            }
            newCollection.add((Integer)((Object)_readable.readString(length)));
        }
        this.violatedGoalsAfterOptimization = newCollection;
        arrayLength = _readable.readUnsignedVarint() - 1;
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field movementGeneratingGoals was serialized as null");
        }
        if (arrayLength > _readable.remaining()) {
            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
        }
        newCollection = new ArrayList(arrayLength);
        for (i = 0; i < arrayLength; ++i) {
            length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field movementGeneratingGoals element was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field movementGeneratingGoals element had invalid length " + length);
            }
            newCollection.add((Integer)((Object)_readable.readString(length)));
        }
        this.movementGeneratingGoals = newCollection;
        arrayLength = _readable.readUnsignedVarint() - 1;
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field excludedTopics was serialized as null");
        }
        if (arrayLength > _readable.remaining()) {
            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
        }
        newCollection = new ArrayList(arrayLength);
        for (i = 0; i < arrayLength; ++i) {
            length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field excludedTopics element was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field excludedTopics element had invalid length " + length);
            }
            newCollection.add((Integer)((Object)_readable.readString(length)));
        }
        this.excludedTopics = newCollection;
        arrayLength = _readable.readUnsignedVarint() - 1;
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field brokersExcludedForLeadership was serialized as null");
        }
        if (arrayLength > _readable.remaining()) {
            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
        }
        newCollection = new ArrayList(arrayLength);
        for (i = 0; i < arrayLength; ++i) {
            newCollection.add(_readable.readInt());
        }
        this.brokersExcludedForLeadership = newCollection;
        arrayLength = _readable.readUnsignedVarint() - 1;
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field brokersExcludedForReplicaMove was serialized as null");
        }
        if (arrayLength > _readable.remaining()) {
            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
        }
        newCollection = new ArrayList(arrayLength);
        for (i = 0; i < arrayLength; ++i) {
            newCollection.add(_readable.readInt());
        }
        this.brokersExcludedForReplicaMove = newCollection;
        this.totalBrokers = _readable.readInt();
        this.totalReplicas = _readable.readInt();
        this.totalTopics = _readable.readInt();
        this.balancednessScorePreRebalance = _readable.readDouble();
        this.balancednessScorePostRebalance = _readable.readDouble();
        arrayLength = _readable.readUnsignedVarint() - 1;
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field goalStats was serialized as null");
        }
        if (arrayLength > _readable.remaining()) {
            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
        }
        newCollection = new ArrayList(arrayLength);
        for (i = 0; i < arrayLength; ++i) {
            newCollection.add((Integer)((Object)new GoalStat(_readable, _version, _context)));
        }
        this.goalStats = newCollection;
        arrayLength = _readable.readUnsignedVarint() - 1;
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field clusterLoadPreRebalance was serialized as null");
        }
        if (arrayLength > _readable.remaining()) {
            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
        }
        newCollection = new ArrayList(arrayLength);
        for (i = 0; i < arrayLength; ++i) {
            newCollection.add((Integer)((Object)new PreBrokerStat(_readable, _version, _context)));
        }
        this.clusterLoadPreRebalance = newCollection;
        arrayLength = _readable.readUnsignedVarint() - 1;
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field clusterLoadPostRebalance was serialized as null");
        }
        if (arrayLength > _readable.remaining()) {
            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
        }
        newCollection = new ArrayList(arrayLength);
        for (i = 0; i < arrayLength; ++i) {
            newCollection.add((Integer)((Object)new PostBrokerStat(_readable, _version, _context)));
        }
        this.clusterLoadPostRebalance = newCollection;
        this._unknownTaggedFields = null;
        int _numTaggedFields = _readable.readUnsignedVarint();
        for (int _i = 0; _i < _numTaggedFields; ++_i) {
            int _tag = _readable.readUnsignedVarint();
            int _size = _readable.readUnsignedVarint();
            switch (_tag) {
                default: 
            }
            this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
        }
    }

    public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        byte[] _stringBytes;
        Object _stringBytes2;
        int _numTaggedFields = 0;
        _writable.writeInt(this.throttleTimeMs);
        _writable.writeShort(this.errorCode);
        if (this.errorMessage == null) {
            _writable.writeUnsignedVarint(0);
        } else {
            _stringBytes2 = _cache.getSerializedValue((Object)this.errorMessage);
            _writable.writeUnsignedVarint(((byte[])_stringBytes2).length + 1);
            _writable.writeByteArray((byte[])_stringBytes2);
        }
        _writable.writeInt(this.interBrokerMoves);
        _writable.writeDouble(this.interBrokerMovesMB);
        _writable.writeInt(this.leadershipMoves);
        _writable.writeInt(this.recentWindows);
        _writable.writeDouble(this.partitionCoveragePercent);
        _writable.writeUnsignedVarint(this.newBrokers.size() + 1);
        _stringBytes2 = this.newBrokers.iterator();
        while (_stringBytes2.hasNext()) {
            Integer newBrokersElement = (Integer)_stringBytes2.next();
            _writable.writeInt(newBrokersElement.intValue());
        }
        _writable.writeUnsignedVarint(this.deadOrRemovedBrokers.size() + 1);
        for (Integer deadOrRemovedBrokersElement : this.deadOrRemovedBrokers) {
            _writable.writeInt(deadOrRemovedBrokersElement.intValue());
        }
        _writable.writeUnsignedVarint(this.violatedGoalsBeforeOptimization.size() + 1);
        for (String violatedGoalsBeforeOptimizationElement : this.violatedGoalsBeforeOptimization) {
            _stringBytes = _cache.getSerializedValue((Object)violatedGoalsBeforeOptimizationElement);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
        }
        _writable.writeUnsignedVarint(this.violatedGoalsAfterOptimization.size() + 1);
        for (String violatedGoalsAfterOptimizationElement : this.violatedGoalsAfterOptimization) {
            _stringBytes = _cache.getSerializedValue((Object)violatedGoalsAfterOptimizationElement);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
        }
        _writable.writeUnsignedVarint(this.movementGeneratingGoals.size() + 1);
        for (String movementGeneratingGoalsElement : this.movementGeneratingGoals) {
            _stringBytes = _cache.getSerializedValue((Object)movementGeneratingGoalsElement);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
        }
        _writable.writeUnsignedVarint(this.excludedTopics.size() + 1);
        for (String excludedTopicsElement : this.excludedTopics) {
            _stringBytes = _cache.getSerializedValue((Object)excludedTopicsElement);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
        }
        _writable.writeUnsignedVarint(this.brokersExcludedForLeadership.size() + 1);
        for (Integer brokersExcludedForLeadershipElement : this.brokersExcludedForLeadership) {
            _writable.writeInt(brokersExcludedForLeadershipElement.intValue());
        }
        _writable.writeUnsignedVarint(this.brokersExcludedForReplicaMove.size() + 1);
        for (Integer brokersExcludedForReplicaMoveElement : this.brokersExcludedForReplicaMove) {
            _writable.writeInt(brokersExcludedForReplicaMoveElement.intValue());
        }
        _writable.writeInt(this.totalBrokers);
        _writable.writeInt(this.totalReplicas);
        _writable.writeInt(this.totalTopics);
        _writable.writeDouble(this.balancednessScorePreRebalance);
        _writable.writeDouble(this.balancednessScorePostRebalance);
        _writable.writeUnsignedVarint(this.goalStats.size() + 1);
        for (GoalStat goalStatsElement : this.goalStats) {
            goalStatsElement.write(_writable, _cache, _version, _context);
        }
        _writable.writeUnsignedVarint(this.clusterLoadPreRebalance.size() + 1);
        for (PreBrokerStat clusterLoadPreRebalanceElement : this.clusterLoadPreRebalance) {
            clusterLoadPreRebalanceElement.write(_writable, _cache, _version, _context);
        }
        _writable.writeUnsignedVarint(this.clusterLoadPostRebalance.size() + 1);
        for (PostBrokerStat clusterLoadPostRebalanceElement : this.clusterLoadPostRebalance) {
            clusterLoadPostRebalanceElement.write(_writable, _cache, _version, _context);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
        _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
    }

    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        byte[] _stringBytes;
        int _numTaggedFields = 0;
        _size.addBytes(4);
        _size.addBytes(2);
        if (this.errorMessage == null) {
            _size.addBytes(1);
        } else {
            byte[] _stringBytes2 = this.errorMessage.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes2.length > Short.MAX_VALUE) {
                throw new RuntimeException("'errorMessage' field is too long to be serialized");
            }
            _cache.cacheSerializedValue((Object)this.errorMessage, _stringBytes2);
            _size.addBytes(_stringBytes2.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes2.length + 1)));
        }
        _size.addBytes(4);
        _size.addBytes(8);
        _size.addBytes(4);
        _size.addBytes(4);
        _size.addBytes(8);
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)(this.newBrokers.size() + 1)));
        _size.addBytes(this.newBrokers.size() * 4);
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)(this.deadOrRemovedBrokers.size() + 1)));
        _size.addBytes(this.deadOrRemovedBrokers.size() * 4);
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)(this.violatedGoalsBeforeOptimization.size() + 1)));
        for (String violatedGoalsBeforeOptimizationElement : this.violatedGoalsBeforeOptimization) {
            _stringBytes = violatedGoalsBeforeOptimizationElement.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'violatedGoalsBeforeOptimizationElement' field is too long to be serialized");
            }
            _cache.cacheSerializedValue((Object)violatedGoalsBeforeOptimizationElement, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1)));
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)(this.violatedGoalsAfterOptimization.size() + 1)));
        for (String violatedGoalsAfterOptimizationElement : this.violatedGoalsAfterOptimization) {
            _stringBytes = violatedGoalsAfterOptimizationElement.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'violatedGoalsAfterOptimizationElement' field is too long to be serialized");
            }
            _cache.cacheSerializedValue((Object)violatedGoalsAfterOptimizationElement, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1)));
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)(this.movementGeneratingGoals.size() + 1)));
        for (String movementGeneratingGoalsElement : this.movementGeneratingGoals) {
            _stringBytes = movementGeneratingGoalsElement.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'movementGeneratingGoalsElement' field is too long to be serialized");
            }
            _cache.cacheSerializedValue((Object)movementGeneratingGoalsElement, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1)));
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)(this.excludedTopics.size() + 1)));
        for (String excludedTopicsElement : this.excludedTopics) {
            _stringBytes = excludedTopicsElement.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'excludedTopicsElement' field is too long to be serialized");
            }
            _cache.cacheSerializedValue((Object)excludedTopicsElement, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1)));
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)(this.brokersExcludedForLeadership.size() + 1)));
        _size.addBytes(this.brokersExcludedForLeadership.size() * 4);
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)(this.brokersExcludedForReplicaMove.size() + 1)));
        _size.addBytes(this.brokersExcludedForReplicaMove.size() * 4);
        _size.addBytes(4);
        _size.addBytes(4);
        _size.addBytes(4);
        _size.addBytes(8);
        _size.addBytes(8);
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)(this.goalStats.size() + 1)));
        for (GoalStat goalStatsElement : this.goalStats) {
            goalStatsElement.addSize(_size, _cache, _version, _context);
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)(this.clusterLoadPreRebalance.size() + 1)));
        for (PreBrokerStat clusterLoadPreRebalanceElement : this.clusterLoadPreRebalance) {
            clusterLoadPreRebalanceElement.addSize(_size, _cache, _version, _context);
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)(this.clusterLoadPostRebalance.size() + 1)));
        for (PostBrokerStat clusterLoadPostRebalanceElement : this.clusterLoadPostRebalance) {
            clusterLoadPostRebalanceElement.addSize(_size, _cache, _version, _context);
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                _size.addBytes(_field.size());
            }
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ComputeEvenClusterLoadPlanResponseData)) {
            return false;
        }
        ComputeEvenClusterLoadPlanResponseData other = (ComputeEvenClusterLoadPlanResponseData)obj;
        if (this.throttleTimeMs != other.throttleTimeMs) {
            return false;
        }
        if (this.errorCode != other.errorCode) {
            return false;
        }
        if (this.errorMessage == null ? other.errorMessage != null : !this.errorMessage.equals(other.errorMessage)) {
            return false;
        }
        if (this.interBrokerMoves != other.interBrokerMoves) {
            return false;
        }
        if (this.interBrokerMovesMB != other.interBrokerMovesMB) {
            return false;
        }
        if (this.leadershipMoves != other.leadershipMoves) {
            return false;
        }
        if (this.recentWindows != other.recentWindows) {
            return false;
        }
        if (this.partitionCoveragePercent != other.partitionCoveragePercent) {
            return false;
        }
        if (this.newBrokers == null ? other.newBrokers != null : !this.newBrokers.equals(other.newBrokers)) {
            return false;
        }
        if (this.deadOrRemovedBrokers == null ? other.deadOrRemovedBrokers != null : !this.deadOrRemovedBrokers.equals(other.deadOrRemovedBrokers)) {
            return false;
        }
        if (this.violatedGoalsBeforeOptimization == null ? other.violatedGoalsBeforeOptimization != null : !this.violatedGoalsBeforeOptimization.equals(other.violatedGoalsBeforeOptimization)) {
            return false;
        }
        if (this.violatedGoalsAfterOptimization == null ? other.violatedGoalsAfterOptimization != null : !this.violatedGoalsAfterOptimization.equals(other.violatedGoalsAfterOptimization)) {
            return false;
        }
        if (this.movementGeneratingGoals == null ? other.movementGeneratingGoals != null : !this.movementGeneratingGoals.equals(other.movementGeneratingGoals)) {
            return false;
        }
        if (this.excludedTopics == null ? other.excludedTopics != null : !this.excludedTopics.equals(other.excludedTopics)) {
            return false;
        }
        if (this.brokersExcludedForLeadership == null ? other.brokersExcludedForLeadership != null : !this.brokersExcludedForLeadership.equals(other.brokersExcludedForLeadership)) {
            return false;
        }
        if (this.brokersExcludedForReplicaMove == null ? other.brokersExcludedForReplicaMove != null : !this.brokersExcludedForReplicaMove.equals(other.brokersExcludedForReplicaMove)) {
            return false;
        }
        if (this.totalBrokers != other.totalBrokers) {
            return false;
        }
        if (this.totalReplicas != other.totalReplicas) {
            return false;
        }
        if (this.totalTopics != other.totalTopics) {
            return false;
        }
        if (this.balancednessScorePreRebalance != other.balancednessScorePreRebalance) {
            return false;
        }
        if (this.balancednessScorePostRebalance != other.balancednessScorePostRebalance) {
            return false;
        }
        if (this.goalStats == null ? other.goalStats != null : !this.goalStats.equals(other.goalStats)) {
            return false;
        }
        if (this.clusterLoadPreRebalance == null ? other.clusterLoadPreRebalance != null : !this.clusterLoadPreRebalance.equals(other.clusterLoadPreRebalance)) {
            return false;
        }
        if (this.clusterLoadPostRebalance == null ? other.clusterLoadPostRebalance != null : !this.clusterLoadPostRebalance.equals(other.clusterLoadPostRebalance)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.throttleTimeMs;
        hashCode = 31 * hashCode + this.errorCode;
        hashCode = 31 * hashCode + (this.errorMessage == null ? 0 : this.errorMessage.hashCode());
        hashCode = 31 * hashCode + this.interBrokerMoves;
        hashCode = 31 * hashCode + Double.hashCode(this.interBrokerMovesMB);
        hashCode = 31 * hashCode + this.leadershipMoves;
        hashCode = 31 * hashCode + this.recentWindows;
        hashCode = 31 * hashCode + Double.hashCode(this.partitionCoveragePercent);
        hashCode = 31 * hashCode + (this.newBrokers == null ? 0 : this.newBrokers.hashCode());
        hashCode = 31 * hashCode + (this.deadOrRemovedBrokers == null ? 0 : this.deadOrRemovedBrokers.hashCode());
        hashCode = 31 * hashCode + (this.violatedGoalsBeforeOptimization == null ? 0 : this.violatedGoalsBeforeOptimization.hashCode());
        hashCode = 31 * hashCode + (this.violatedGoalsAfterOptimization == null ? 0 : this.violatedGoalsAfterOptimization.hashCode());
        hashCode = 31 * hashCode + (this.movementGeneratingGoals == null ? 0 : this.movementGeneratingGoals.hashCode());
        hashCode = 31 * hashCode + (this.excludedTopics == null ? 0 : this.excludedTopics.hashCode());
        hashCode = 31 * hashCode + (this.brokersExcludedForLeadership == null ? 0 : this.brokersExcludedForLeadership.hashCode());
        hashCode = 31 * hashCode + (this.brokersExcludedForReplicaMove == null ? 0 : this.brokersExcludedForReplicaMove.hashCode());
        hashCode = 31 * hashCode + this.totalBrokers;
        hashCode = 31 * hashCode + this.totalReplicas;
        hashCode = 31 * hashCode + this.totalTopics;
        hashCode = 31 * hashCode + Double.hashCode(this.balancednessScorePreRebalance);
        hashCode = 31 * hashCode + Double.hashCode(this.balancednessScorePostRebalance);
        hashCode = 31 * hashCode + (this.goalStats == null ? 0 : this.goalStats.hashCode());
        hashCode = 31 * hashCode + (this.clusterLoadPreRebalance == null ? 0 : this.clusterLoadPreRebalance.hashCode());
        hashCode = 31 * hashCode + (this.clusterLoadPostRebalance == null ? 0 : this.clusterLoadPostRebalance.hashCode());
        return hashCode;
    }

    public ComputeEvenClusterLoadPlanResponseData duplicate() {
        ComputeEvenClusterLoadPlanResponseData _duplicate = new ComputeEvenClusterLoadPlanResponseData();
        _duplicate.throttleTimeMs = this.throttleTimeMs;
        _duplicate.errorCode = this.errorCode;
        _duplicate.errorMessage = this.errorMessage == null ? null : this.errorMessage;
        _duplicate.interBrokerMoves = this.interBrokerMoves;
        _duplicate.interBrokerMovesMB = this.interBrokerMovesMB;
        _duplicate.leadershipMoves = this.leadershipMoves;
        _duplicate.recentWindows = this.recentWindows;
        _duplicate.partitionCoveragePercent = this.partitionCoveragePercent;
        ArrayList<Integer> newNewBrokers = new ArrayList<Integer>(this.newBrokers.size());
        for (Integer n : this.newBrokers) {
            newNewBrokers.add(n);
        }
        _duplicate.newBrokers = newNewBrokers;
        ArrayList<Integer> newDeadOrRemovedBrokers = new ArrayList<Integer>(this.deadOrRemovedBrokers.size());
        for (Integer n : this.deadOrRemovedBrokers) {
            newDeadOrRemovedBrokers.add(n);
        }
        _duplicate.deadOrRemovedBrokers = newDeadOrRemovedBrokers;
        ArrayList<String> arrayList = new ArrayList<String>(this.violatedGoalsBeforeOptimization.size());
        for (String string : this.violatedGoalsBeforeOptimization) {
            arrayList.add(string);
        }
        _duplicate.violatedGoalsBeforeOptimization = arrayList;
        ArrayList<String> arrayList2 = new ArrayList<String>(this.violatedGoalsAfterOptimization.size());
        for (String string : this.violatedGoalsAfterOptimization) {
            arrayList2.add(string);
        }
        _duplicate.violatedGoalsAfterOptimization = arrayList2;
        ArrayList<String> arrayList3 = new ArrayList<String>(this.movementGeneratingGoals.size());
        for (String string : this.movementGeneratingGoals) {
            arrayList3.add(string);
        }
        _duplicate.movementGeneratingGoals = arrayList3;
        ArrayList<String> arrayList4 = new ArrayList<String>(this.excludedTopics.size());
        for (String string : this.excludedTopics) {
            arrayList4.add(string);
        }
        _duplicate.excludedTopics = arrayList4;
        ArrayList<Integer> arrayList5 = new ArrayList<Integer>(this.brokersExcludedForLeadership.size());
        for (Integer n : this.brokersExcludedForLeadership) {
            arrayList5.add(n);
        }
        _duplicate.brokersExcludedForLeadership = arrayList5;
        ArrayList<Integer> arrayList6 = new ArrayList<Integer>(this.brokersExcludedForReplicaMove.size());
        for (Integer n : this.brokersExcludedForReplicaMove) {
            arrayList6.add(n);
        }
        _duplicate.brokersExcludedForReplicaMove = arrayList6;
        _duplicate.totalBrokers = this.totalBrokers;
        _duplicate.totalReplicas = this.totalReplicas;
        _duplicate.totalTopics = this.totalTopics;
        _duplicate.balancednessScorePreRebalance = this.balancednessScorePreRebalance;
        _duplicate.balancednessScorePostRebalance = this.balancednessScorePostRebalance;
        ArrayList<GoalStat> arrayList7 = new ArrayList<GoalStat>(this.goalStats.size());
        for (GoalStat goalStat : this.goalStats) {
            arrayList7.add(goalStat.duplicate());
        }
        _duplicate.goalStats = arrayList7;
        ArrayList<PreBrokerStat> arrayList8 = new ArrayList<PreBrokerStat>(this.clusterLoadPreRebalance.size());
        for (PreBrokerStat _element : this.clusterLoadPreRebalance) {
            arrayList8.add(_element.duplicate());
        }
        _duplicate.clusterLoadPreRebalance = arrayList8;
        ArrayList<PostBrokerStat> arrayList9 = new ArrayList<PostBrokerStat>(this.clusterLoadPostRebalance.size());
        for (PostBrokerStat _element : this.clusterLoadPostRebalance) {
            arrayList9.add(_element.duplicate());
        }
        _duplicate.clusterLoadPostRebalance = arrayList9;
        return _duplicate;
    }

    public String toString() {
        return "ComputeEvenClusterLoadPlanResponseData(throttleTimeMs=" + this.throttleTimeMs + ", errorCode=" + this.errorCode + ", errorMessage=" + (this.errorMessage == null ? "null" : "'" + this.errorMessage.toString() + "'") + ", interBrokerMoves=" + this.interBrokerMoves + ", interBrokerMovesMB=" + this.interBrokerMovesMB + ", leadershipMoves=" + this.leadershipMoves + ", recentWindows=" + this.recentWindows + ", partitionCoveragePercent=" + this.partitionCoveragePercent + ", newBrokers=" + MessageUtil.deepToString(this.newBrokers.iterator()) + ", deadOrRemovedBrokers=" + MessageUtil.deepToString(this.deadOrRemovedBrokers.iterator()) + ", violatedGoalsBeforeOptimization=" + MessageUtil.deepToString(this.violatedGoalsBeforeOptimization.iterator()) + ", violatedGoalsAfterOptimization=" + MessageUtil.deepToString(this.violatedGoalsAfterOptimization.iterator()) + ", movementGeneratingGoals=" + MessageUtil.deepToString(this.movementGeneratingGoals.iterator()) + ", excludedTopics=" + MessageUtil.deepToString(this.excludedTopics.iterator()) + ", brokersExcludedForLeadership=" + MessageUtil.deepToString(this.brokersExcludedForLeadership.iterator()) + ", brokersExcludedForReplicaMove=" + MessageUtil.deepToString(this.brokersExcludedForReplicaMove.iterator()) + ", totalBrokers=" + this.totalBrokers + ", totalReplicas=" + this.totalReplicas + ", totalTopics=" + this.totalTopics + ", balancednessScorePreRebalance=" + this.balancednessScorePreRebalance + ", balancednessScorePostRebalance=" + this.balancednessScorePostRebalance + ", goalStats=" + MessageUtil.deepToString(this.goalStats.iterator()) + ", clusterLoadPreRebalance=" + MessageUtil.deepToString(this.clusterLoadPreRebalance.iterator()) + ", clusterLoadPostRebalance=" + MessageUtil.deepToString(this.clusterLoadPostRebalance.iterator()) + ")";
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public short errorCode() {
        return this.errorCode;
    }

    public String errorMessage() {
        return this.errorMessage;
    }

    public int interBrokerMoves() {
        return this.interBrokerMoves;
    }

    public double interBrokerMovesMB() {
        return this.interBrokerMovesMB;
    }

    public int leadershipMoves() {
        return this.leadershipMoves;
    }

    public int recentWindows() {
        return this.recentWindows;
    }

    public double partitionCoveragePercent() {
        return this.partitionCoveragePercent;
    }

    public List<Integer> newBrokers() {
        return this.newBrokers;
    }

    public List<Integer> deadOrRemovedBrokers() {
        return this.deadOrRemovedBrokers;
    }

    public List<String> violatedGoalsBeforeOptimization() {
        return this.violatedGoalsBeforeOptimization;
    }

    public List<String> violatedGoalsAfterOptimization() {
        return this.violatedGoalsAfterOptimization;
    }

    public List<String> movementGeneratingGoals() {
        return this.movementGeneratingGoals;
    }

    public List<String> excludedTopics() {
        return this.excludedTopics;
    }

    public List<Integer> brokersExcludedForLeadership() {
        return this.brokersExcludedForLeadership;
    }

    public List<Integer> brokersExcludedForReplicaMove() {
        return this.brokersExcludedForReplicaMove;
    }

    public int totalBrokers() {
        return this.totalBrokers;
    }

    public int totalReplicas() {
        return this.totalReplicas;
    }

    public int totalTopics() {
        return this.totalTopics;
    }

    public double balancednessScorePreRebalance() {
        return this.balancednessScorePreRebalance;
    }

    public double balancednessScorePostRebalance() {
        return this.balancednessScorePostRebalance;
    }

    public List<GoalStat> goalStats() {
        return this.goalStats;
    }

    public List<PreBrokerStat> clusterLoadPreRebalance() {
        return this.clusterLoadPreRebalance;
    }

    public List<PostBrokerStat> clusterLoadPostRebalance() {
        return this.clusterLoadPostRebalance;
    }

    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public ComputeEvenClusterLoadPlanResponseData setThrottleTimeMs(int v) {
        this.throttleTimeMs = v;
        return this;
    }

    public ComputeEvenClusterLoadPlanResponseData setErrorCode(short v) {
        this.errorCode = v;
        return this;
    }

    public ComputeEvenClusterLoadPlanResponseData setErrorMessage(String v) {
        this.errorMessage = v;
        return this;
    }

    public ComputeEvenClusterLoadPlanResponseData setInterBrokerMoves(int v) {
        this.interBrokerMoves = v;
        return this;
    }

    public ComputeEvenClusterLoadPlanResponseData setInterBrokerMovesMB(double v) {
        this.interBrokerMovesMB = v;
        return this;
    }

    public ComputeEvenClusterLoadPlanResponseData setLeadershipMoves(int v) {
        this.leadershipMoves = v;
        return this;
    }

    public ComputeEvenClusterLoadPlanResponseData setRecentWindows(int v) {
        this.recentWindows = v;
        return this;
    }

    public ComputeEvenClusterLoadPlanResponseData setPartitionCoveragePercent(double v) {
        this.partitionCoveragePercent = v;
        return this;
    }

    public ComputeEvenClusterLoadPlanResponseData setNewBrokers(List<Integer> v) {
        this.newBrokers = v;
        return this;
    }

    public ComputeEvenClusterLoadPlanResponseData setDeadOrRemovedBrokers(List<Integer> v) {
        this.deadOrRemovedBrokers = v;
        return this;
    }

    public ComputeEvenClusterLoadPlanResponseData setViolatedGoalsBeforeOptimization(List<String> v) {
        this.violatedGoalsBeforeOptimization = v;
        return this;
    }

    public ComputeEvenClusterLoadPlanResponseData setViolatedGoalsAfterOptimization(List<String> v) {
        this.violatedGoalsAfterOptimization = v;
        return this;
    }

    public ComputeEvenClusterLoadPlanResponseData setMovementGeneratingGoals(List<String> v) {
        this.movementGeneratingGoals = v;
        return this;
    }

    public ComputeEvenClusterLoadPlanResponseData setExcludedTopics(List<String> v) {
        this.excludedTopics = v;
        return this;
    }

    public ComputeEvenClusterLoadPlanResponseData setBrokersExcludedForLeadership(List<Integer> v) {
        this.brokersExcludedForLeadership = v;
        return this;
    }

    public ComputeEvenClusterLoadPlanResponseData setBrokersExcludedForReplicaMove(List<Integer> v) {
        this.brokersExcludedForReplicaMove = v;
        return this;
    }

    public ComputeEvenClusterLoadPlanResponseData setTotalBrokers(int v) {
        this.totalBrokers = v;
        return this;
    }

    public ComputeEvenClusterLoadPlanResponseData setTotalReplicas(int v) {
        this.totalReplicas = v;
        return this;
    }

    public ComputeEvenClusterLoadPlanResponseData setTotalTopics(int v) {
        this.totalTopics = v;
        return this;
    }

    public ComputeEvenClusterLoadPlanResponseData setBalancednessScorePreRebalance(double v) {
        this.balancednessScorePreRebalance = v;
        return this;
    }

    public ComputeEvenClusterLoadPlanResponseData setBalancednessScorePostRebalance(double v) {
        this.balancednessScorePostRebalance = v;
        return this;
    }

    public ComputeEvenClusterLoadPlanResponseData setGoalStats(List<GoalStat> v) {
        this.goalStats = v;
        return this;
    }

    public ComputeEvenClusterLoadPlanResponseData setClusterLoadPreRebalance(List<PreBrokerStat> v) {
        this.clusterLoadPreRebalance = v;
        return this;
    }

    public ComputeEvenClusterLoadPlanResponseData setClusterLoadPostRebalance(List<PostBrokerStat> v) {
        this.clusterLoadPostRebalance = v;
        return this;
    }

    public static class PostBrokerStat
    implements Message {
        int brokerId;
        String host;
        double diskMB;
        double diskPercent;
        double cpuPercent;
        double leaderNetworkInKBps;
        double followerNetworkInKBps;
        double networkOutKBps;
        double potentialNetworkOutKBps;
        int leaders;
        int replicas;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("broker_id", (Type)Type.INT32, "The Broker ID in the cluster."), new Field("host", (Type)Type.COMPACT_STRING, "The host corresponding to the broker id."), new Field("disk_mb", (Type)Type.FLOAT64, "The disk usage in MB."), new Field("disk_percent", (Type)Type.FLOAT64, "The disk usage percent."), new Field("cpu_percent", (Type)Type.FLOAT64, "The cpu usage percent."), new Field("leader_network_in_kbps", (Type)Type.FLOAT64, "The network inbound bytes for leaders."), new Field("follower_network_in_kbps", (Type)Type.FLOAT64, "The network inbound bytes for followers."), new Field("network_out_kbps", (Type)Type.FLOAT64, "The network outbound bytes."), new Field("potential_network_out_kbps", (Type)Type.FLOAT64, "The potential network outbound bytes."), new Field("leaders", (Type)Type.INT32, "The number of leaders on the broker."), new Field("replicas", (Type)Type.INT32, "The number of followers on the broker."), Field.TaggedFieldsSection.of((Object[])new Object[0])});
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public PostBrokerStat(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public PostBrokerStat() {
            this.brokerId = 0;
            this.host = "";
            this.diskMB = 0.0;
            this.diskPercent = 0.0;
            this.cpuPercent = 0.0;
            this.leaderNetworkInKBps = 0.0;
            this.followerNetworkInKBps = 0.0;
            this.networkOutKBps = 0.0;
            this.potentialNetworkOutKBps = 0.0;
            this.leaders = 0;
            this.replicas = 0;
        }

        public short lowestSupportedVersion() {
            return 0;
        }

        public short highestSupportedVersion() {
            return 0;
        }

        public void read(Readable _readable, short _version, MessageContext _context) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of PostBrokerStat");
            }
            this.brokerId = _readable.readInt();
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field host was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field host had invalid length " + length);
            }
            this.host = _readable.readString(length);
            this.diskMB = _readable.readDouble();
            this.diskPercent = _readable.readDouble();
            this.cpuPercent = _readable.readDouble();
            this.leaderNetworkInKBps = _readable.readDouble();
            this.followerNetworkInKBps = _readable.readDouble();
            this.networkOutKBps = _readable.readDouble();
            this.potentialNetworkOutKBps = _readable.readDouble();
            this.leaders = _readable.readInt();
            this.replicas = _readable.readInt();
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            _writable.writeInt(this.brokerId);
            byte[] _stringBytes = _cache.getSerializedValue((Object)this.host);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
            _writable.writeDouble(this.diskMB);
            _writable.writeDouble(this.diskPercent);
            _writable.writeDouble(this.cpuPercent);
            _writable.writeDouble(this.leaderNetworkInKBps);
            _writable.writeDouble(this.followerNetworkInKBps);
            _writable.writeDouble(this.networkOutKBps);
            _writable.writeDouble(this.potentialNetworkOutKBps);
            _writable.writeInt(this.leaders);
            _writable.writeInt(this.replicas);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of PostBrokerStat");
            }
            _size.addBytes(4);
            byte[] _stringBytes = this.host.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'host' field is too long to be serialized");
            }
            _cache.cacheSerializedValue((Object)this.host, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1)));
            _size.addBytes(8);
            _size.addBytes(8);
            _size.addBytes(8);
            _size.addBytes(8);
            _size.addBytes(8);
            _size.addBytes(8);
            _size.addBytes(8);
            _size.addBytes(4);
            _size.addBytes(4);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof PostBrokerStat)) {
                return false;
            }
            PostBrokerStat other = (PostBrokerStat)obj;
            if (this.brokerId != other.brokerId) {
                return false;
            }
            if (this.host == null ? other.host != null : !this.host.equals(other.host)) {
                return false;
            }
            if (this.diskMB != other.diskMB) {
                return false;
            }
            if (this.diskPercent != other.diskPercent) {
                return false;
            }
            if (this.cpuPercent != other.cpuPercent) {
                return false;
            }
            if (this.leaderNetworkInKBps != other.leaderNetworkInKBps) {
                return false;
            }
            if (this.followerNetworkInKBps != other.followerNetworkInKBps) {
                return false;
            }
            if (this.networkOutKBps != other.networkOutKBps) {
                return false;
            }
            if (this.potentialNetworkOutKBps != other.potentialNetworkOutKBps) {
                return false;
            }
            if (this.leaders != other.leaders) {
                return false;
            }
            if (this.replicas != other.replicas) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.brokerId;
            hashCode = 31 * hashCode + (this.host == null ? 0 : this.host.hashCode());
            hashCode = 31 * hashCode + Double.hashCode(this.diskMB);
            hashCode = 31 * hashCode + Double.hashCode(this.diskPercent);
            hashCode = 31 * hashCode + Double.hashCode(this.cpuPercent);
            hashCode = 31 * hashCode + Double.hashCode(this.leaderNetworkInKBps);
            hashCode = 31 * hashCode + Double.hashCode(this.followerNetworkInKBps);
            hashCode = 31 * hashCode + Double.hashCode(this.networkOutKBps);
            hashCode = 31 * hashCode + Double.hashCode(this.potentialNetworkOutKBps);
            hashCode = 31 * hashCode + this.leaders;
            hashCode = 31 * hashCode + this.replicas;
            return hashCode;
        }

        public PostBrokerStat duplicate() {
            PostBrokerStat _duplicate = new PostBrokerStat();
            _duplicate.brokerId = this.brokerId;
            _duplicate.host = this.host;
            _duplicate.diskMB = this.diskMB;
            _duplicate.diskPercent = this.diskPercent;
            _duplicate.cpuPercent = this.cpuPercent;
            _duplicate.leaderNetworkInKBps = this.leaderNetworkInKBps;
            _duplicate.followerNetworkInKBps = this.followerNetworkInKBps;
            _duplicate.networkOutKBps = this.networkOutKBps;
            _duplicate.potentialNetworkOutKBps = this.potentialNetworkOutKBps;
            _duplicate.leaders = this.leaders;
            _duplicate.replicas = this.replicas;
            return _duplicate;
        }

        public String toString() {
            return "PostBrokerStat(brokerId=" + this.brokerId + ", host=" + (this.host == null ? "null" : "'" + this.host.toString() + "'") + ", diskMB=" + this.diskMB + ", diskPercent=" + this.diskPercent + ", cpuPercent=" + this.cpuPercent + ", leaderNetworkInKBps=" + this.leaderNetworkInKBps + ", followerNetworkInKBps=" + this.followerNetworkInKBps + ", networkOutKBps=" + this.networkOutKBps + ", potentialNetworkOutKBps=" + this.potentialNetworkOutKBps + ", leaders=" + this.leaders + ", replicas=" + this.replicas + ")";
        }

        public int brokerId() {
            return this.brokerId;
        }

        public String host() {
            return this.host;
        }

        public double diskMB() {
            return this.diskMB;
        }

        public double diskPercent() {
            return this.diskPercent;
        }

        public double cpuPercent() {
            return this.cpuPercent;
        }

        public double leaderNetworkInKBps() {
            return this.leaderNetworkInKBps;
        }

        public double followerNetworkInKBps() {
            return this.followerNetworkInKBps;
        }

        public double networkOutKBps() {
            return this.networkOutKBps;
        }

        public double potentialNetworkOutKBps() {
            return this.potentialNetworkOutKBps;
        }

        public int leaders() {
            return this.leaders;
        }

        public int replicas() {
            return this.replicas;
        }

        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public PostBrokerStat setBrokerId(int v) {
            this.brokerId = v;
            return this;
        }

        public PostBrokerStat setHost(String v) {
            this.host = v;
            return this;
        }

        public PostBrokerStat setDiskMB(double v) {
            this.diskMB = v;
            return this;
        }

        public PostBrokerStat setDiskPercent(double v) {
            this.diskPercent = v;
            return this;
        }

        public PostBrokerStat setCpuPercent(double v) {
            this.cpuPercent = v;
            return this;
        }

        public PostBrokerStat setLeaderNetworkInKBps(double v) {
            this.leaderNetworkInKBps = v;
            return this;
        }

        public PostBrokerStat setFollowerNetworkInKBps(double v) {
            this.followerNetworkInKBps = v;
            return this;
        }

        public PostBrokerStat setNetworkOutKBps(double v) {
            this.networkOutKBps = v;
            return this;
        }

        public PostBrokerStat setPotentialNetworkOutKBps(double v) {
            this.potentialNetworkOutKBps = v;
            return this;
        }

        public PostBrokerStat setLeaders(int v) {
            this.leaders = v;
            return this;
        }

        public PostBrokerStat setReplicas(int v) {
            this.replicas = v;
            return this;
        }
    }

    public static class PreBrokerStat
    implements Message {
        int brokerId;
        String host;
        double diskMB;
        double diskPercent;
        double cpuPercent;
        double leaderNetworkInKBps;
        double followerNetworkInKBps;
        double networkOutKBps;
        double potentialNetworkOutKBps;
        int leaders;
        int replicas;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("broker_id", (Type)Type.INT32, "The Broker ID in the cluster."), new Field("host", (Type)Type.COMPACT_STRING, "The host corresponding to the broker id."), new Field("disk_mb", (Type)Type.FLOAT64, "The disk usage in MB."), new Field("disk_percent", (Type)Type.FLOAT64, "The disk usage percent."), new Field("cpu_percent", (Type)Type.FLOAT64, "The cpu usage percent."), new Field("leader_network_in_kbps", (Type)Type.FLOAT64, "The network inbound bytes for leaders."), new Field("follower_network_in_kbps", (Type)Type.FLOAT64, "The network inbound bytes for followers."), new Field("network_out_kbps", (Type)Type.FLOAT64, "The network outbound bytes."), new Field("potential_network_out_kbps", (Type)Type.FLOAT64, "The potential network outbound bytes."), new Field("leaders", (Type)Type.INT32, "The number of leader partitions hosted on the broker."), new Field("replicas", (Type)Type.INT32, "The number of follower partitions hosted on the broker."), Field.TaggedFieldsSection.of((Object[])new Object[0])});
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public PreBrokerStat(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public PreBrokerStat() {
            this.brokerId = 0;
            this.host = "";
            this.diskMB = 0.0;
            this.diskPercent = 0.0;
            this.cpuPercent = 0.0;
            this.leaderNetworkInKBps = 0.0;
            this.followerNetworkInKBps = 0.0;
            this.networkOutKBps = 0.0;
            this.potentialNetworkOutKBps = 0.0;
            this.leaders = 0;
            this.replicas = 0;
        }

        public short lowestSupportedVersion() {
            return 0;
        }

        public short highestSupportedVersion() {
            return 0;
        }

        public void read(Readable _readable, short _version, MessageContext _context) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of PreBrokerStat");
            }
            this.brokerId = _readable.readInt();
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field host was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field host had invalid length " + length);
            }
            this.host = _readable.readString(length);
            this.diskMB = _readable.readDouble();
            this.diskPercent = _readable.readDouble();
            this.cpuPercent = _readable.readDouble();
            this.leaderNetworkInKBps = _readable.readDouble();
            this.followerNetworkInKBps = _readable.readDouble();
            this.networkOutKBps = _readable.readDouble();
            this.potentialNetworkOutKBps = _readable.readDouble();
            this.leaders = _readable.readInt();
            this.replicas = _readable.readInt();
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            _writable.writeInt(this.brokerId);
            byte[] _stringBytes = _cache.getSerializedValue((Object)this.host);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
            _writable.writeDouble(this.diskMB);
            _writable.writeDouble(this.diskPercent);
            _writable.writeDouble(this.cpuPercent);
            _writable.writeDouble(this.leaderNetworkInKBps);
            _writable.writeDouble(this.followerNetworkInKBps);
            _writable.writeDouble(this.networkOutKBps);
            _writable.writeDouble(this.potentialNetworkOutKBps);
            _writable.writeInt(this.leaders);
            _writable.writeInt(this.replicas);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of PreBrokerStat");
            }
            _size.addBytes(4);
            byte[] _stringBytes = this.host.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'host' field is too long to be serialized");
            }
            _cache.cacheSerializedValue((Object)this.host, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1)));
            _size.addBytes(8);
            _size.addBytes(8);
            _size.addBytes(8);
            _size.addBytes(8);
            _size.addBytes(8);
            _size.addBytes(8);
            _size.addBytes(8);
            _size.addBytes(4);
            _size.addBytes(4);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof PreBrokerStat)) {
                return false;
            }
            PreBrokerStat other = (PreBrokerStat)obj;
            if (this.brokerId != other.brokerId) {
                return false;
            }
            if (this.host == null ? other.host != null : !this.host.equals(other.host)) {
                return false;
            }
            if (this.diskMB != other.diskMB) {
                return false;
            }
            if (this.diskPercent != other.diskPercent) {
                return false;
            }
            if (this.cpuPercent != other.cpuPercent) {
                return false;
            }
            if (this.leaderNetworkInKBps != other.leaderNetworkInKBps) {
                return false;
            }
            if (this.followerNetworkInKBps != other.followerNetworkInKBps) {
                return false;
            }
            if (this.networkOutKBps != other.networkOutKBps) {
                return false;
            }
            if (this.potentialNetworkOutKBps != other.potentialNetworkOutKBps) {
                return false;
            }
            if (this.leaders != other.leaders) {
                return false;
            }
            if (this.replicas != other.replicas) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.brokerId;
            hashCode = 31 * hashCode + (this.host == null ? 0 : this.host.hashCode());
            hashCode = 31 * hashCode + Double.hashCode(this.diskMB);
            hashCode = 31 * hashCode + Double.hashCode(this.diskPercent);
            hashCode = 31 * hashCode + Double.hashCode(this.cpuPercent);
            hashCode = 31 * hashCode + Double.hashCode(this.leaderNetworkInKBps);
            hashCode = 31 * hashCode + Double.hashCode(this.followerNetworkInKBps);
            hashCode = 31 * hashCode + Double.hashCode(this.networkOutKBps);
            hashCode = 31 * hashCode + Double.hashCode(this.potentialNetworkOutKBps);
            hashCode = 31 * hashCode + this.leaders;
            hashCode = 31 * hashCode + this.replicas;
            return hashCode;
        }

        public PreBrokerStat duplicate() {
            PreBrokerStat _duplicate = new PreBrokerStat();
            _duplicate.brokerId = this.brokerId;
            _duplicate.host = this.host;
            _duplicate.diskMB = this.diskMB;
            _duplicate.diskPercent = this.diskPercent;
            _duplicate.cpuPercent = this.cpuPercent;
            _duplicate.leaderNetworkInKBps = this.leaderNetworkInKBps;
            _duplicate.followerNetworkInKBps = this.followerNetworkInKBps;
            _duplicate.networkOutKBps = this.networkOutKBps;
            _duplicate.potentialNetworkOutKBps = this.potentialNetworkOutKBps;
            _duplicate.leaders = this.leaders;
            _duplicate.replicas = this.replicas;
            return _duplicate;
        }

        public String toString() {
            return "PreBrokerStat(brokerId=" + this.brokerId + ", host=" + (this.host == null ? "null" : "'" + this.host.toString() + "'") + ", diskMB=" + this.diskMB + ", diskPercent=" + this.diskPercent + ", cpuPercent=" + this.cpuPercent + ", leaderNetworkInKBps=" + this.leaderNetworkInKBps + ", followerNetworkInKBps=" + this.followerNetworkInKBps + ", networkOutKBps=" + this.networkOutKBps + ", potentialNetworkOutKBps=" + this.potentialNetworkOutKBps + ", leaders=" + this.leaders + ", replicas=" + this.replicas + ")";
        }

        public int brokerId() {
            return this.brokerId;
        }

        public String host() {
            return this.host;
        }

        public double diskMB() {
            return this.diskMB;
        }

        public double diskPercent() {
            return this.diskPercent;
        }

        public double cpuPercent() {
            return this.cpuPercent;
        }

        public double leaderNetworkInKBps() {
            return this.leaderNetworkInKBps;
        }

        public double followerNetworkInKBps() {
            return this.followerNetworkInKBps;
        }

        public double networkOutKBps() {
            return this.networkOutKBps;
        }

        public double potentialNetworkOutKBps() {
            return this.potentialNetworkOutKBps;
        }

        public int leaders() {
            return this.leaders;
        }

        public int replicas() {
            return this.replicas;
        }

        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public PreBrokerStat setBrokerId(int v) {
            this.brokerId = v;
            return this;
        }

        public PreBrokerStat setHost(String v) {
            this.host = v;
            return this;
        }

        public PreBrokerStat setDiskMB(double v) {
            this.diskMB = v;
            return this;
        }

        public PreBrokerStat setDiskPercent(double v) {
            this.diskPercent = v;
            return this;
        }

        public PreBrokerStat setCpuPercent(double v) {
            this.cpuPercent = v;
            return this;
        }

        public PreBrokerStat setLeaderNetworkInKBps(double v) {
            this.leaderNetworkInKBps = v;
            return this;
        }

        public PreBrokerStat setFollowerNetworkInKBps(double v) {
            this.followerNetworkInKBps = v;
            return this;
        }

        public PreBrokerStat setNetworkOutKBps(double v) {
            this.networkOutKBps = v;
            return this;
        }

        public PreBrokerStat setPotentialNetworkOutKBps(double v) {
            this.potentialNetworkOutKBps = v;
            return this;
        }

        public PreBrokerStat setLeaders(int v) {
            this.leaders = v;
            return this;
        }

        public PreBrokerStat setReplicas(int v) {
            this.replicas = v;
            return this;
        }
    }

    public static class RejectingGoal
    implements Message {
        String goalName;
        int proposalsRejected;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("goal_name", (Type)Type.COMPACT_STRING, "Name of the goal that rejected proposal/s."), new Field("proposals_rejected", (Type)Type.INT32, "Number of proposals rejected by this rejecting goal."), Field.TaggedFieldsSection.of((Object[])new Object[0])});
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public RejectingGoal(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public RejectingGoal() {
            this.goalName = "";
            this.proposalsRejected = 0;
        }

        public short lowestSupportedVersion() {
            return 0;
        }

        public short highestSupportedVersion() {
            return 0;
        }

        public void read(Readable _readable, short _version, MessageContext _context) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of RejectingGoal");
            }
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field goalName was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field goalName had invalid length " + length);
            }
            this.goalName = _readable.readString(length);
            this.proposalsRejected = _readable.readInt();
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            byte[] _stringBytes = _cache.getSerializedValue((Object)this.goalName);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
            _writable.writeInt(this.proposalsRejected);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of RejectingGoal");
            }
            byte[] _stringBytes = this.goalName.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'goalName' field is too long to be serialized");
            }
            _cache.cacheSerializedValue((Object)this.goalName, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1)));
            _size.addBytes(4);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof RejectingGoal)) {
                return false;
            }
            RejectingGoal other = (RejectingGoal)obj;
            if (this.goalName == null ? other.goalName != null : !this.goalName.equals(other.goalName)) {
                return false;
            }
            if (this.proposalsRejected != other.proposalsRejected) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.goalName == null ? 0 : this.goalName.hashCode());
            hashCode = 31 * hashCode + this.proposalsRejected;
            return hashCode;
        }

        public RejectingGoal duplicate() {
            RejectingGoal _duplicate = new RejectingGoal();
            _duplicate.goalName = this.goalName;
            _duplicate.proposalsRejected = this.proposalsRejected;
            return _duplicate;
        }

        public String toString() {
            return "RejectingGoal(goalName=" + (this.goalName == null ? "null" : "'" + this.goalName.toString() + "'") + ", proposalsRejected=" + this.proposalsRejected + ")";
        }

        public String goalName() {
            return this.goalName;
        }

        public int proposalsRejected() {
            return this.proposalsRejected;
        }

        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public RejectingGoal setGoalName(String v) {
            this.goalName = v;
            return this;
        }

        public RejectingGoal setProposalsRejected(int v) {
            this.proposalsRejected = v;
            return this;
        }
    }

    public static class GoalOverview
    implements Message {
        String goalStatus;
        List<RejectingGoal> rejectingGoals;
        int proposalsGenerated;
        int proposalsRejected;
        double proposalsRejectedPercent;
        int proposalsAccepted;
        double proposalsAcceptedPercent;
        int moves;
        int swaps;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("goal_status", (Type)Type.COMPACT_STRING, "Status of the given goal. It can be VIOLATED, FIXED, or NO-ACTION."), new Field("rejecting_goals", (Type)new CompactArrayOf((Type)RejectingGoal.SCHEMA_0), "Proposal rejections for the given goal by another goal."), new Field("proposals_generated", (Type)Type.INT32, "Proposals generated for the given goal."), new Field("proposals_rejected", (Type)Type.INT32, "Proposals rejected for the given goal."), new Field("proposals_rejected_percent", (Type)Type.FLOAT64, "Percentage of rejected proposals for the given goal."), new Field("proposals_accepted", (Type)Type.INT32, "Proposals accepted for the given goal."), new Field("proposals_accepted_percent", (Type)Type.FLOAT64, "Percentage of accepted proposals for the given goal."), new Field("moves", (Type)Type.INT32, "Total moves to optimize the given goal."), new Field("swaps", (Type)Type.INT32, "Total swaps to optimize the given goal."), Field.TaggedFieldsSection.of((Object[])new Object[0])});
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public GoalOverview(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public GoalOverview() {
            this.goalStatus = "";
            this.rejectingGoals = new ArrayList<RejectingGoal>(0);
            this.proposalsGenerated = 0;
            this.proposalsRejected = 0;
            this.proposalsRejectedPercent = 0.0;
            this.proposalsAccepted = 0;
            this.proposalsAcceptedPercent = 0.0;
            this.moves = 0;
            this.swaps = 0;
        }

        public short lowestSupportedVersion() {
            return 0;
        }

        public short highestSupportedVersion() {
            return 0;
        }

        public void read(Readable _readable, short _version, MessageContext _context) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of GoalOverview");
            }
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field goalStatus was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field goalStatus had invalid length " + length);
            }
            this.goalStatus = _readable.readString(length);
            int arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field rejectingGoals was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            ArrayList<RejectingGoal> newCollection = new ArrayList<RejectingGoal>(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                newCollection.add(new RejectingGoal(_readable, _version, _context));
            }
            this.rejectingGoals = newCollection;
            this.proposalsGenerated = _readable.readInt();
            this.proposalsRejected = _readable.readInt();
            this.proposalsRejectedPercent = _readable.readDouble();
            this.proposalsAccepted = _readable.readInt();
            this.proposalsAcceptedPercent = _readable.readDouble();
            this.moves = _readable.readInt();
            this.swaps = _readable.readInt();
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            Object _stringBytes = _cache.getSerializedValue((Object)this.goalStatus);
            _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            _writable.writeByteArray((byte[])_stringBytes);
            _writable.writeUnsignedVarint(this.rejectingGoals.size() + 1);
            _stringBytes = this.rejectingGoals.iterator();
            while (_stringBytes.hasNext()) {
                RejectingGoal rejectingGoalsElement = (RejectingGoal)_stringBytes.next();
                rejectingGoalsElement.write(_writable, _cache, _version, _context);
            }
            _writable.writeInt(this.proposalsGenerated);
            _writable.writeInt(this.proposalsRejected);
            _writable.writeDouble(this.proposalsRejectedPercent);
            _writable.writeInt(this.proposalsAccepted);
            _writable.writeDouble(this.proposalsAcceptedPercent);
            _writable.writeInt(this.moves);
            _writable.writeInt(this.swaps);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of GoalOverview");
            }
            byte[] _stringBytes = this.goalStatus.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'goalStatus' field is too long to be serialized");
            }
            _cache.cacheSerializedValue((Object)this.goalStatus, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1)));
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)(this.rejectingGoals.size() + 1)));
            for (RejectingGoal rejectingGoalsElement : this.rejectingGoals) {
                rejectingGoalsElement.addSize(_size, _cache, _version, _context);
            }
            _size.addBytes(4);
            _size.addBytes(4);
            _size.addBytes(8);
            _size.addBytes(4);
            _size.addBytes(8);
            _size.addBytes(4);
            _size.addBytes(4);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof GoalOverview)) {
                return false;
            }
            GoalOverview other = (GoalOverview)obj;
            if (this.goalStatus == null ? other.goalStatus != null : !this.goalStatus.equals(other.goalStatus)) {
                return false;
            }
            if (this.rejectingGoals == null ? other.rejectingGoals != null : !this.rejectingGoals.equals(other.rejectingGoals)) {
                return false;
            }
            if (this.proposalsGenerated != other.proposalsGenerated) {
                return false;
            }
            if (this.proposalsRejected != other.proposalsRejected) {
                return false;
            }
            if (this.proposalsRejectedPercent != other.proposalsRejectedPercent) {
                return false;
            }
            if (this.proposalsAccepted != other.proposalsAccepted) {
                return false;
            }
            if (this.proposalsAcceptedPercent != other.proposalsAcceptedPercent) {
                return false;
            }
            if (this.moves != other.moves) {
                return false;
            }
            if (this.swaps != other.swaps) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.goalStatus == null ? 0 : this.goalStatus.hashCode());
            hashCode = 31 * hashCode + (this.rejectingGoals == null ? 0 : this.rejectingGoals.hashCode());
            hashCode = 31 * hashCode + this.proposalsGenerated;
            hashCode = 31 * hashCode + this.proposalsRejected;
            hashCode = 31 * hashCode + Double.hashCode(this.proposalsRejectedPercent);
            hashCode = 31 * hashCode + this.proposalsAccepted;
            hashCode = 31 * hashCode + Double.hashCode(this.proposalsAcceptedPercent);
            hashCode = 31 * hashCode + this.moves;
            hashCode = 31 * hashCode + this.swaps;
            return hashCode;
        }

        public GoalOverview duplicate() {
            GoalOverview _duplicate = new GoalOverview();
            _duplicate.goalStatus = this.goalStatus;
            ArrayList<RejectingGoal> newRejectingGoals = new ArrayList<RejectingGoal>(this.rejectingGoals.size());
            for (RejectingGoal _element : this.rejectingGoals) {
                newRejectingGoals.add(_element.duplicate());
            }
            _duplicate.rejectingGoals = newRejectingGoals;
            _duplicate.proposalsGenerated = this.proposalsGenerated;
            _duplicate.proposalsRejected = this.proposalsRejected;
            _duplicate.proposalsRejectedPercent = this.proposalsRejectedPercent;
            _duplicate.proposalsAccepted = this.proposalsAccepted;
            _duplicate.proposalsAcceptedPercent = this.proposalsAcceptedPercent;
            _duplicate.moves = this.moves;
            _duplicate.swaps = this.swaps;
            return _duplicate;
        }

        public String toString() {
            return "GoalOverview(goalStatus=" + (this.goalStatus == null ? "null" : "'" + this.goalStatus.toString() + "'") + ", rejectingGoals=" + MessageUtil.deepToString(this.rejectingGoals.iterator()) + ", proposalsGenerated=" + this.proposalsGenerated + ", proposalsRejected=" + this.proposalsRejected + ", proposalsRejectedPercent=" + this.proposalsRejectedPercent + ", proposalsAccepted=" + this.proposalsAccepted + ", proposalsAcceptedPercent=" + this.proposalsAcceptedPercent + ", moves=" + this.moves + ", swaps=" + this.swaps + ")";
        }

        public String goalStatus() {
            return this.goalStatus;
        }

        public List<RejectingGoal> rejectingGoals() {
            return this.rejectingGoals;
        }

        public int proposalsGenerated() {
            return this.proposalsGenerated;
        }

        public int proposalsRejected() {
            return this.proposalsRejected;
        }

        public double proposalsRejectedPercent() {
            return this.proposalsRejectedPercent;
        }

        public int proposalsAccepted() {
            return this.proposalsAccepted;
        }

        public double proposalsAcceptedPercent() {
            return this.proposalsAcceptedPercent;
        }

        public int moves() {
            return this.moves;
        }

        public int swaps() {
            return this.swaps;
        }

        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public GoalOverview setGoalStatus(String v) {
            this.goalStatus = v;
            return this;
        }

        public GoalOverview setRejectingGoals(List<RejectingGoal> v) {
            this.rejectingGoals = v;
            return this;
        }

        public GoalOverview setProposalsGenerated(int v) {
            this.proposalsGenerated = v;
            return this;
        }

        public GoalOverview setProposalsRejected(int v) {
            this.proposalsRejected = v;
            return this;
        }

        public GoalOverview setProposalsRejectedPercent(double v) {
            this.proposalsRejectedPercent = v;
            return this;
        }

        public GoalOverview setProposalsAccepted(int v) {
            this.proposalsAccepted = v;
            return this;
        }

        public GoalOverview setProposalsAcceptedPercent(double v) {
            this.proposalsAcceptedPercent = v;
            return this;
        }

        public GoalOverview setMoves(int v) {
            this.moves = v;
            return this;
        }

        public GoalOverview setSwaps(int v) {
            this.swaps = v;
            return this;
        }
    }

    public static class StdResources
    implements Message {
        double cpuPercent;
        double networkInboundKBps;
        double networkOutboundKBps;
        double diskMB;
        double potentialNwOutKBps;
        int replicas;
        int leaderReplicas;
        int topicReplicas;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("cpu_percent", (Type)Type.FLOAT64, "CPU usage percentage for the given goal."), new Field("network_inbound_kbps", (Type)Type.FLOAT64, "Network inbound usage for the given goal in KB/s."), new Field("network_outbound_kbps", (Type)Type.FLOAT64, "Network outbound usage for the given goal in KB/s."), new Field("disk_mb", (Type)Type.FLOAT64, "Disk usage for the given goal in MB."), new Field("potential_nw_out_kbps", (Type)Type.FLOAT64, "Potential network out usage for the given goal in Kb/s."), new Field("replicas", (Type)Type.INT32, "Replicas to be moved for the given goal."), new Field("leader_replicas", (Type)Type.INT32, "Leader replicas to be moved for the given goal."), new Field("topic_replicas", (Type)Type.INT32, "Topic replicas to be moved for the given goal."), Field.TaggedFieldsSection.of((Object[])new Object[0])});
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public StdResources(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public StdResources() {
            this.cpuPercent = 0.0;
            this.networkInboundKBps = 0.0;
            this.networkOutboundKBps = 0.0;
            this.diskMB = 0.0;
            this.potentialNwOutKBps = 0.0;
            this.replicas = 0;
            this.leaderReplicas = 0;
            this.topicReplicas = 0;
        }

        public short lowestSupportedVersion() {
            return 0;
        }

        public short highestSupportedVersion() {
            return 0;
        }

        public void read(Readable _readable, short _version, MessageContext _context) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of StdResources");
            }
            this.cpuPercent = _readable.readDouble();
            this.networkInboundKBps = _readable.readDouble();
            this.networkOutboundKBps = _readable.readDouble();
            this.diskMB = _readable.readDouble();
            this.potentialNwOutKBps = _readable.readDouble();
            this.replicas = _readable.readInt();
            this.leaderReplicas = _readable.readInt();
            this.topicReplicas = _readable.readInt();
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            _writable.writeDouble(this.cpuPercent);
            _writable.writeDouble(this.networkInboundKBps);
            _writable.writeDouble(this.networkOutboundKBps);
            _writable.writeDouble(this.diskMB);
            _writable.writeDouble(this.potentialNwOutKBps);
            _writable.writeInt(this.replicas);
            _writable.writeInt(this.leaderReplicas);
            _writable.writeInt(this.topicReplicas);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of StdResources");
            }
            _size.addBytes(8);
            _size.addBytes(8);
            _size.addBytes(8);
            _size.addBytes(8);
            _size.addBytes(8);
            _size.addBytes(4);
            _size.addBytes(4);
            _size.addBytes(4);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof StdResources)) {
                return false;
            }
            StdResources other = (StdResources)obj;
            if (this.cpuPercent != other.cpuPercent) {
                return false;
            }
            if (this.networkInboundKBps != other.networkInboundKBps) {
                return false;
            }
            if (this.networkOutboundKBps != other.networkOutboundKBps) {
                return false;
            }
            if (this.diskMB != other.diskMB) {
                return false;
            }
            if (this.potentialNwOutKBps != other.potentialNwOutKBps) {
                return false;
            }
            if (this.replicas != other.replicas) {
                return false;
            }
            if (this.leaderReplicas != other.leaderReplicas) {
                return false;
            }
            if (this.topicReplicas != other.topicReplicas) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + Double.hashCode(this.cpuPercent);
            hashCode = 31 * hashCode + Double.hashCode(this.networkInboundKBps);
            hashCode = 31 * hashCode + Double.hashCode(this.networkOutboundKBps);
            hashCode = 31 * hashCode + Double.hashCode(this.diskMB);
            hashCode = 31 * hashCode + Double.hashCode(this.potentialNwOutKBps);
            hashCode = 31 * hashCode + this.replicas;
            hashCode = 31 * hashCode + this.leaderReplicas;
            hashCode = 31 * hashCode + this.topicReplicas;
            return hashCode;
        }

        public StdResources duplicate() {
            StdResources _duplicate = new StdResources();
            _duplicate.cpuPercent = this.cpuPercent;
            _duplicate.networkInboundKBps = this.networkInboundKBps;
            _duplicate.networkOutboundKBps = this.networkOutboundKBps;
            _duplicate.diskMB = this.diskMB;
            _duplicate.potentialNwOutKBps = this.potentialNwOutKBps;
            _duplicate.replicas = this.replicas;
            _duplicate.leaderReplicas = this.leaderReplicas;
            _duplicate.topicReplicas = this.topicReplicas;
            return _duplicate;
        }

        public String toString() {
            return "StdResources(cpuPercent=" + this.cpuPercent + ", networkInboundKBps=" + this.networkInboundKBps + ", networkOutboundKBps=" + this.networkOutboundKBps + ", diskMB=" + this.diskMB + ", potentialNwOutKBps=" + this.potentialNwOutKBps + ", replicas=" + this.replicas + ", leaderReplicas=" + this.leaderReplicas + ", topicReplicas=" + this.topicReplicas + ")";
        }

        public double cpuPercent() {
            return this.cpuPercent;
        }

        public double networkInboundKBps() {
            return this.networkInboundKBps;
        }

        public double networkOutboundKBps() {
            return this.networkOutboundKBps;
        }

        public double diskMB() {
            return this.diskMB;
        }

        public double potentialNwOutKBps() {
            return this.potentialNwOutKBps;
        }

        public int replicas() {
            return this.replicas;
        }

        public int leaderReplicas() {
            return this.leaderReplicas;
        }

        public int topicReplicas() {
            return this.topicReplicas;
        }

        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public StdResources setCpuPercent(double v) {
            this.cpuPercent = v;
            return this;
        }

        public StdResources setNetworkInboundKBps(double v) {
            this.networkInboundKBps = v;
            return this;
        }

        public StdResources setNetworkOutboundKBps(double v) {
            this.networkOutboundKBps = v;
            return this;
        }

        public StdResources setDiskMB(double v) {
            this.diskMB = v;
            return this;
        }

        public StdResources setPotentialNwOutKBps(double v) {
            this.potentialNwOutKBps = v;
            return this;
        }

        public StdResources setReplicas(int v) {
            this.replicas = v;
            return this;
        }

        public StdResources setLeaderReplicas(int v) {
            this.leaderReplicas = v;
            return this;
        }

        public StdResources setTopicReplicas(int v) {
            this.topicReplicas = v;
            return this;
        }
    }

    public static class MinResources
    implements Message {
        double cpuPercent;
        double networkInboundKBps;
        double networkOutboundKBps;
        double diskMB;
        double potentialNwOutKBps;
        int replicas;
        int leaderReplicas;
        int topicReplicas;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("cpu_percent", (Type)Type.FLOAT64, "CPU usage percentage for the given goal."), new Field("network_inbound_kbps", (Type)Type.FLOAT64, "Network inbound usage for the given goal in KB/s."), new Field("network_outbound_kbps", (Type)Type.FLOAT64, "Network outbound usage for the given goal in KB/s."), new Field("disk_mb", (Type)Type.FLOAT64, "Disk usage for the given goal in MB."), new Field("potential_nw_out_kbps", (Type)Type.FLOAT64, "Potential network out usage for the given goal in Kb/s."), new Field("replicas", (Type)Type.INT32, "Replicas to be moved for the given goal."), new Field("leader_replicas", (Type)Type.INT32, "Leader replicas to be moved for the given goal."), new Field("topic_replicas", (Type)Type.INT32, "Topic replicas to be moved for the given goal."), Field.TaggedFieldsSection.of((Object[])new Object[0])});
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public MinResources(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public MinResources() {
            this.cpuPercent = 0.0;
            this.networkInboundKBps = 0.0;
            this.networkOutboundKBps = 0.0;
            this.diskMB = 0.0;
            this.potentialNwOutKBps = 0.0;
            this.replicas = 0;
            this.leaderReplicas = 0;
            this.topicReplicas = 0;
        }

        public short lowestSupportedVersion() {
            return 0;
        }

        public short highestSupportedVersion() {
            return 0;
        }

        public void read(Readable _readable, short _version, MessageContext _context) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of MinResources");
            }
            this.cpuPercent = _readable.readDouble();
            this.networkInboundKBps = _readable.readDouble();
            this.networkOutboundKBps = _readable.readDouble();
            this.diskMB = _readable.readDouble();
            this.potentialNwOutKBps = _readable.readDouble();
            this.replicas = _readable.readInt();
            this.leaderReplicas = _readable.readInt();
            this.topicReplicas = _readable.readInt();
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            _writable.writeDouble(this.cpuPercent);
            _writable.writeDouble(this.networkInboundKBps);
            _writable.writeDouble(this.networkOutboundKBps);
            _writable.writeDouble(this.diskMB);
            _writable.writeDouble(this.potentialNwOutKBps);
            _writable.writeInt(this.replicas);
            _writable.writeInt(this.leaderReplicas);
            _writable.writeInt(this.topicReplicas);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of MinResources");
            }
            _size.addBytes(8);
            _size.addBytes(8);
            _size.addBytes(8);
            _size.addBytes(8);
            _size.addBytes(8);
            _size.addBytes(4);
            _size.addBytes(4);
            _size.addBytes(4);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof MinResources)) {
                return false;
            }
            MinResources other = (MinResources)obj;
            if (this.cpuPercent != other.cpuPercent) {
                return false;
            }
            if (this.networkInboundKBps != other.networkInboundKBps) {
                return false;
            }
            if (this.networkOutboundKBps != other.networkOutboundKBps) {
                return false;
            }
            if (this.diskMB != other.diskMB) {
                return false;
            }
            if (this.potentialNwOutKBps != other.potentialNwOutKBps) {
                return false;
            }
            if (this.replicas != other.replicas) {
                return false;
            }
            if (this.leaderReplicas != other.leaderReplicas) {
                return false;
            }
            if (this.topicReplicas != other.topicReplicas) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + Double.hashCode(this.cpuPercent);
            hashCode = 31 * hashCode + Double.hashCode(this.networkInboundKBps);
            hashCode = 31 * hashCode + Double.hashCode(this.networkOutboundKBps);
            hashCode = 31 * hashCode + Double.hashCode(this.diskMB);
            hashCode = 31 * hashCode + Double.hashCode(this.potentialNwOutKBps);
            hashCode = 31 * hashCode + this.replicas;
            hashCode = 31 * hashCode + this.leaderReplicas;
            hashCode = 31 * hashCode + this.topicReplicas;
            return hashCode;
        }

        public MinResources duplicate() {
            MinResources _duplicate = new MinResources();
            _duplicate.cpuPercent = this.cpuPercent;
            _duplicate.networkInboundKBps = this.networkInboundKBps;
            _duplicate.networkOutboundKBps = this.networkOutboundKBps;
            _duplicate.diskMB = this.diskMB;
            _duplicate.potentialNwOutKBps = this.potentialNwOutKBps;
            _duplicate.replicas = this.replicas;
            _duplicate.leaderReplicas = this.leaderReplicas;
            _duplicate.topicReplicas = this.topicReplicas;
            return _duplicate;
        }

        public String toString() {
            return "MinResources(cpuPercent=" + this.cpuPercent + ", networkInboundKBps=" + this.networkInboundKBps + ", networkOutboundKBps=" + this.networkOutboundKBps + ", diskMB=" + this.diskMB + ", potentialNwOutKBps=" + this.potentialNwOutKBps + ", replicas=" + this.replicas + ", leaderReplicas=" + this.leaderReplicas + ", topicReplicas=" + this.topicReplicas + ")";
        }

        public double cpuPercent() {
            return this.cpuPercent;
        }

        public double networkInboundKBps() {
            return this.networkInboundKBps;
        }

        public double networkOutboundKBps() {
            return this.networkOutboundKBps;
        }

        public double diskMB() {
            return this.diskMB;
        }

        public double potentialNwOutKBps() {
            return this.potentialNwOutKBps;
        }

        public int replicas() {
            return this.replicas;
        }

        public int leaderReplicas() {
            return this.leaderReplicas;
        }

        public int topicReplicas() {
            return this.topicReplicas;
        }

        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public MinResources setCpuPercent(double v) {
            this.cpuPercent = v;
            return this;
        }

        public MinResources setNetworkInboundKBps(double v) {
            this.networkInboundKBps = v;
            return this;
        }

        public MinResources setNetworkOutboundKBps(double v) {
            this.networkOutboundKBps = v;
            return this;
        }

        public MinResources setDiskMB(double v) {
            this.diskMB = v;
            return this;
        }

        public MinResources setPotentialNwOutKBps(double v) {
            this.potentialNwOutKBps = v;
            return this;
        }

        public MinResources setReplicas(int v) {
            this.replicas = v;
            return this;
        }

        public MinResources setLeaderReplicas(int v) {
            this.leaderReplicas = v;
            return this;
        }

        public MinResources setTopicReplicas(int v) {
            this.topicReplicas = v;
            return this;
        }
    }

    public static class MaxResources
    implements Message {
        double cpuPercent;
        double networkInboundKBps;
        double networkOutboundKBps;
        double diskMB;
        double potentialNwOutKBps;
        int replicas;
        int leaderReplicas;
        int topicReplicas;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("cpu_percent", (Type)Type.FLOAT64, "CPU usage percentage for the given goal."), new Field("network_inbound_kbps", (Type)Type.FLOAT64, "Network inbound usage for the given goal in KB/s."), new Field("network_outbound_kbps", (Type)Type.FLOAT64, "Network outbound usage for the given goal in KB/s."), new Field("disk_mb", (Type)Type.FLOAT64, "Disk usage for the given goal in MB."), new Field("potential_nw_out_kbps", (Type)Type.FLOAT64, "Potential network out usage for the given goal in Kb/s."), new Field("replicas", (Type)Type.INT32, "Replicas to be moved for the given goal."), new Field("leader_replicas", (Type)Type.INT32, "Leader replicas to be moved for the given goal."), new Field("topic_replicas", (Type)Type.INT32, "Topic replicas to be moved for the given goal."), Field.TaggedFieldsSection.of((Object[])new Object[0])});
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public MaxResources(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public MaxResources() {
            this.cpuPercent = 0.0;
            this.networkInboundKBps = 0.0;
            this.networkOutboundKBps = 0.0;
            this.diskMB = 0.0;
            this.potentialNwOutKBps = 0.0;
            this.replicas = 0;
            this.leaderReplicas = 0;
            this.topicReplicas = 0;
        }

        public short lowestSupportedVersion() {
            return 0;
        }

        public short highestSupportedVersion() {
            return 0;
        }

        public void read(Readable _readable, short _version, MessageContext _context) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of MaxResources");
            }
            this.cpuPercent = _readable.readDouble();
            this.networkInboundKBps = _readable.readDouble();
            this.networkOutboundKBps = _readable.readDouble();
            this.diskMB = _readable.readDouble();
            this.potentialNwOutKBps = _readable.readDouble();
            this.replicas = _readable.readInt();
            this.leaderReplicas = _readable.readInt();
            this.topicReplicas = _readable.readInt();
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            _writable.writeDouble(this.cpuPercent);
            _writable.writeDouble(this.networkInboundKBps);
            _writable.writeDouble(this.networkOutboundKBps);
            _writable.writeDouble(this.diskMB);
            _writable.writeDouble(this.potentialNwOutKBps);
            _writable.writeInt(this.replicas);
            _writable.writeInt(this.leaderReplicas);
            _writable.writeInt(this.topicReplicas);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of MaxResources");
            }
            _size.addBytes(8);
            _size.addBytes(8);
            _size.addBytes(8);
            _size.addBytes(8);
            _size.addBytes(8);
            _size.addBytes(4);
            _size.addBytes(4);
            _size.addBytes(4);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof MaxResources)) {
                return false;
            }
            MaxResources other = (MaxResources)obj;
            if (this.cpuPercent != other.cpuPercent) {
                return false;
            }
            if (this.networkInboundKBps != other.networkInboundKBps) {
                return false;
            }
            if (this.networkOutboundKBps != other.networkOutboundKBps) {
                return false;
            }
            if (this.diskMB != other.diskMB) {
                return false;
            }
            if (this.potentialNwOutKBps != other.potentialNwOutKBps) {
                return false;
            }
            if (this.replicas != other.replicas) {
                return false;
            }
            if (this.leaderReplicas != other.leaderReplicas) {
                return false;
            }
            if (this.topicReplicas != other.topicReplicas) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + Double.hashCode(this.cpuPercent);
            hashCode = 31 * hashCode + Double.hashCode(this.networkInboundKBps);
            hashCode = 31 * hashCode + Double.hashCode(this.networkOutboundKBps);
            hashCode = 31 * hashCode + Double.hashCode(this.diskMB);
            hashCode = 31 * hashCode + Double.hashCode(this.potentialNwOutKBps);
            hashCode = 31 * hashCode + this.replicas;
            hashCode = 31 * hashCode + this.leaderReplicas;
            hashCode = 31 * hashCode + this.topicReplicas;
            return hashCode;
        }

        public MaxResources duplicate() {
            MaxResources _duplicate = new MaxResources();
            _duplicate.cpuPercent = this.cpuPercent;
            _duplicate.networkInboundKBps = this.networkInboundKBps;
            _duplicate.networkOutboundKBps = this.networkOutboundKBps;
            _duplicate.diskMB = this.diskMB;
            _duplicate.potentialNwOutKBps = this.potentialNwOutKBps;
            _duplicate.replicas = this.replicas;
            _duplicate.leaderReplicas = this.leaderReplicas;
            _duplicate.topicReplicas = this.topicReplicas;
            return _duplicate;
        }

        public String toString() {
            return "MaxResources(cpuPercent=" + this.cpuPercent + ", networkInboundKBps=" + this.networkInboundKBps + ", networkOutboundKBps=" + this.networkOutboundKBps + ", diskMB=" + this.diskMB + ", potentialNwOutKBps=" + this.potentialNwOutKBps + ", replicas=" + this.replicas + ", leaderReplicas=" + this.leaderReplicas + ", topicReplicas=" + this.topicReplicas + ")";
        }

        public double cpuPercent() {
            return this.cpuPercent;
        }

        public double networkInboundKBps() {
            return this.networkInboundKBps;
        }

        public double networkOutboundKBps() {
            return this.networkOutboundKBps;
        }

        public double diskMB() {
            return this.diskMB;
        }

        public double potentialNwOutKBps() {
            return this.potentialNwOutKBps;
        }

        public int replicas() {
            return this.replicas;
        }

        public int leaderReplicas() {
            return this.leaderReplicas;
        }

        public int topicReplicas() {
            return this.topicReplicas;
        }

        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public MaxResources setCpuPercent(double v) {
            this.cpuPercent = v;
            return this;
        }

        public MaxResources setNetworkInboundKBps(double v) {
            this.networkInboundKBps = v;
            return this;
        }

        public MaxResources setNetworkOutboundKBps(double v) {
            this.networkOutboundKBps = v;
            return this;
        }

        public MaxResources setDiskMB(double v) {
            this.diskMB = v;
            return this;
        }

        public MaxResources setPotentialNwOutKBps(double v) {
            this.potentialNwOutKBps = v;
            return this;
        }

        public MaxResources setReplicas(int v) {
            this.replicas = v;
            return this;
        }

        public MaxResources setLeaderReplicas(int v) {
            this.leaderReplicas = v;
            return this;
        }

        public MaxResources setTopicReplicas(int v) {
            this.topicReplicas = v;
            return this;
        }
    }

    public static class AvgResources
    implements Message {
        double cpuPercent;
        double networkInboundKBps;
        double networkOutboundKBps;
        double diskMB;
        double potentialNwOutKBps;
        int replicas;
        int leaderReplicas;
        int topicReplicas;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("cpu_percent", (Type)Type.FLOAT64, "CPU usage percentage for the given goal."), new Field("network_inbound_kbps", (Type)Type.FLOAT64, "Network inbound usage for the given goal in KB/s."), new Field("network_outbound_kbps", (Type)Type.FLOAT64, "Network outbound usage for the given goal in KB/s."), new Field("disk_mb", (Type)Type.FLOAT64, "Disk usage for the given goal in MB."), new Field("potential_nw_out_kbps", (Type)Type.FLOAT64, "Potential network out usage for the given goal in Kb/s."), new Field("replicas", (Type)Type.INT32, "Replicas to be moved for the given goal."), new Field("leader_replicas", (Type)Type.INT32, "Leader replicas to be moved for the given goal."), new Field("topic_replicas", (Type)Type.INT32, "Topic replicas to be moved for the given goal."), Field.TaggedFieldsSection.of((Object[])new Object[0])});
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public AvgResources(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public AvgResources() {
            this.cpuPercent = 0.0;
            this.networkInboundKBps = 0.0;
            this.networkOutboundKBps = 0.0;
            this.diskMB = 0.0;
            this.potentialNwOutKBps = 0.0;
            this.replicas = 0;
            this.leaderReplicas = 0;
            this.topicReplicas = 0;
        }

        public short lowestSupportedVersion() {
            return 0;
        }

        public short highestSupportedVersion() {
            return 0;
        }

        public void read(Readable _readable, short _version, MessageContext _context) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of AvgResources");
            }
            this.cpuPercent = _readable.readDouble();
            this.networkInboundKBps = _readable.readDouble();
            this.networkOutboundKBps = _readable.readDouble();
            this.diskMB = _readable.readDouble();
            this.potentialNwOutKBps = _readable.readDouble();
            this.replicas = _readable.readInt();
            this.leaderReplicas = _readable.readInt();
            this.topicReplicas = _readable.readInt();
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            _writable.writeDouble(this.cpuPercent);
            _writable.writeDouble(this.networkInboundKBps);
            _writable.writeDouble(this.networkOutboundKBps);
            _writable.writeDouble(this.diskMB);
            _writable.writeDouble(this.potentialNwOutKBps);
            _writable.writeInt(this.replicas);
            _writable.writeInt(this.leaderReplicas);
            _writable.writeInt(this.topicReplicas);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of AvgResources");
            }
            _size.addBytes(8);
            _size.addBytes(8);
            _size.addBytes(8);
            _size.addBytes(8);
            _size.addBytes(8);
            _size.addBytes(4);
            _size.addBytes(4);
            _size.addBytes(4);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof AvgResources)) {
                return false;
            }
            AvgResources other = (AvgResources)obj;
            if (this.cpuPercent != other.cpuPercent) {
                return false;
            }
            if (this.networkInboundKBps != other.networkInboundKBps) {
                return false;
            }
            if (this.networkOutboundKBps != other.networkOutboundKBps) {
                return false;
            }
            if (this.diskMB != other.diskMB) {
                return false;
            }
            if (this.potentialNwOutKBps != other.potentialNwOutKBps) {
                return false;
            }
            if (this.replicas != other.replicas) {
                return false;
            }
            if (this.leaderReplicas != other.leaderReplicas) {
                return false;
            }
            if (this.topicReplicas != other.topicReplicas) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + Double.hashCode(this.cpuPercent);
            hashCode = 31 * hashCode + Double.hashCode(this.networkInboundKBps);
            hashCode = 31 * hashCode + Double.hashCode(this.networkOutboundKBps);
            hashCode = 31 * hashCode + Double.hashCode(this.diskMB);
            hashCode = 31 * hashCode + Double.hashCode(this.potentialNwOutKBps);
            hashCode = 31 * hashCode + this.replicas;
            hashCode = 31 * hashCode + this.leaderReplicas;
            hashCode = 31 * hashCode + this.topicReplicas;
            return hashCode;
        }

        public AvgResources duplicate() {
            AvgResources _duplicate = new AvgResources();
            _duplicate.cpuPercent = this.cpuPercent;
            _duplicate.networkInboundKBps = this.networkInboundKBps;
            _duplicate.networkOutboundKBps = this.networkOutboundKBps;
            _duplicate.diskMB = this.diskMB;
            _duplicate.potentialNwOutKBps = this.potentialNwOutKBps;
            _duplicate.replicas = this.replicas;
            _duplicate.leaderReplicas = this.leaderReplicas;
            _duplicate.topicReplicas = this.topicReplicas;
            return _duplicate;
        }

        public String toString() {
            return "AvgResources(cpuPercent=" + this.cpuPercent + ", networkInboundKBps=" + this.networkInboundKBps + ", networkOutboundKBps=" + this.networkOutboundKBps + ", diskMB=" + this.diskMB + ", potentialNwOutKBps=" + this.potentialNwOutKBps + ", replicas=" + this.replicas + ", leaderReplicas=" + this.leaderReplicas + ", topicReplicas=" + this.topicReplicas + ")";
        }

        public double cpuPercent() {
            return this.cpuPercent;
        }

        public double networkInboundKBps() {
            return this.networkInboundKBps;
        }

        public double networkOutboundKBps() {
            return this.networkOutboundKBps;
        }

        public double diskMB() {
            return this.diskMB;
        }

        public double potentialNwOutKBps() {
            return this.potentialNwOutKBps;
        }

        public int replicas() {
            return this.replicas;
        }

        public int leaderReplicas() {
            return this.leaderReplicas;
        }

        public int topicReplicas() {
            return this.topicReplicas;
        }

        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public AvgResources setCpuPercent(double v) {
            this.cpuPercent = v;
            return this;
        }

        public AvgResources setNetworkInboundKBps(double v) {
            this.networkInboundKBps = v;
            return this;
        }

        public AvgResources setNetworkOutboundKBps(double v) {
            this.networkOutboundKBps = v;
            return this;
        }

        public AvgResources setDiskMB(double v) {
            this.diskMB = v;
            return this;
        }

        public AvgResources setPotentialNwOutKBps(double v) {
            this.potentialNwOutKBps = v;
            return this;
        }

        public AvgResources setReplicas(int v) {
            this.replicas = v;
            return this;
        }

        public AvgResources setLeaderReplicas(int v) {
            this.leaderReplicas = v;
            return this;
        }

        public AvgResources setTopicReplicas(int v) {
            this.topicReplicas = v;
            return this;
        }
    }

    public static class GoalStat
    implements Message {
        String goalName;
        AvgResources avgResources;
        MaxResources maxResources;
        MinResources minResources;
        StdResources stdResources;
        GoalOverview goalOverview;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("goal_name", (Type)Type.COMPACT_STRING, "SBC goal name."), new Field("avg_resources", (Type)AvgResources.SCHEMA_0, "Average resource distribution for the given goal."), new Field("max_resources", (Type)MaxResources.SCHEMA_0, "Maximum resource distribution for the given goal."), new Field("min_resources", (Type)MinResources.SCHEMA_0, "Minimum resource distribution for the given goal."), new Field("std_resources", (Type)StdResources.SCHEMA_0, "Standard deviation for resource distribution for the given goal."), new Field("goal_overview", (Type)GoalOverview.SCHEMA_0, "Goal overview of the given goal."), Field.TaggedFieldsSection.of((Object[])new Object[0])});
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public GoalStat(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public GoalStat() {
            this.goalName = "";
            this.avgResources = new AvgResources();
            this.maxResources = new MaxResources();
            this.minResources = new MinResources();
            this.stdResources = new StdResources();
            this.goalOverview = new GoalOverview();
        }

        public short lowestSupportedVersion() {
            return 0;
        }

        public short highestSupportedVersion() {
            return 0;
        }

        public void read(Readable _readable, short _version, MessageContext _context) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of GoalStat");
            }
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field goalName was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field goalName had invalid length " + length);
            }
            this.goalName = _readable.readString(length);
            this.avgResources = new AvgResources(_readable, _version, _context);
            this.maxResources = new MaxResources(_readable, _version, _context);
            this.minResources = new MinResources(_readable, _version, _context);
            this.stdResources = new StdResources(_readable, _version, _context);
            this.goalOverview = new GoalOverview(_readable, _version, _context);
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            byte[] _stringBytes = _cache.getSerializedValue((Object)this.goalName);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
            this.avgResources.write(_writable, _cache, _version, _context);
            this.maxResources.write(_writable, _cache, _version, _context);
            this.minResources.write(_writable, _cache, _version, _context);
            this.stdResources.write(_writable, _cache, _version, _context);
            this.goalOverview.write(_writable, _cache, _version, _context);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of GoalStat");
            }
            byte[] _stringBytes = this.goalName.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'goalName' field is too long to be serialized");
            }
            _cache.cacheSerializedValue((Object)this.goalName, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1)));
            int _sizeBeforeStruct = _size.totalSize();
            this.avgResources.addSize(_size, _cache, _version, _context);
            int n = _size.totalSize() - _sizeBeforeStruct;
            _sizeBeforeStruct = _size.totalSize();
            this.maxResources.addSize(_size, _cache, _version, _context);
            n = _size.totalSize() - _sizeBeforeStruct;
            _sizeBeforeStruct = _size.totalSize();
            this.minResources.addSize(_size, _cache, _version, _context);
            n = _size.totalSize() - _sizeBeforeStruct;
            _sizeBeforeStruct = _size.totalSize();
            this.stdResources.addSize(_size, _cache, _version, _context);
            n = _size.totalSize() - _sizeBeforeStruct;
            _sizeBeforeStruct = _size.totalSize();
            this.goalOverview.addSize(_size, _cache, _version, _context);
            n = _size.totalSize() - _sizeBeforeStruct;
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof GoalStat)) {
                return false;
            }
            GoalStat other = (GoalStat)obj;
            if (this.goalName == null ? other.goalName != null : !this.goalName.equals(other.goalName)) {
                return false;
            }
            if (this.avgResources == null ? other.avgResources != null : !this.avgResources.equals(other.avgResources)) {
                return false;
            }
            if (this.maxResources == null ? other.maxResources != null : !this.maxResources.equals(other.maxResources)) {
                return false;
            }
            if (this.minResources == null ? other.minResources != null : !this.minResources.equals(other.minResources)) {
                return false;
            }
            if (this.stdResources == null ? other.stdResources != null : !this.stdResources.equals(other.stdResources)) {
                return false;
            }
            if (this.goalOverview == null ? other.goalOverview != null : !this.goalOverview.equals(other.goalOverview)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.goalName == null ? 0 : this.goalName.hashCode());
            hashCode = 31 * hashCode + (this.avgResources == null ? 0 : this.avgResources.hashCode());
            hashCode = 31 * hashCode + (this.maxResources == null ? 0 : this.maxResources.hashCode());
            hashCode = 31 * hashCode + (this.minResources == null ? 0 : this.minResources.hashCode());
            hashCode = 31 * hashCode + (this.stdResources == null ? 0 : this.stdResources.hashCode());
            hashCode = 31 * hashCode + (this.goalOverview == null ? 0 : this.goalOverview.hashCode());
            return hashCode;
        }

        public GoalStat duplicate() {
            GoalStat _duplicate = new GoalStat();
            _duplicate.goalName = this.goalName;
            _duplicate.avgResources = this.avgResources.duplicate();
            _duplicate.maxResources = this.maxResources.duplicate();
            _duplicate.minResources = this.minResources.duplicate();
            _duplicate.stdResources = this.stdResources.duplicate();
            _duplicate.goalOverview = this.goalOverview.duplicate();
            return _duplicate;
        }

        public String toString() {
            return "GoalStat(goalName=" + (this.goalName == null ? "null" : "'" + this.goalName.toString() + "'") + ", avgResources=" + this.avgResources.toString() + ", maxResources=" + this.maxResources.toString() + ", minResources=" + this.minResources.toString() + ", stdResources=" + this.stdResources.toString() + ", goalOverview=" + this.goalOverview.toString() + ")";
        }

        public String goalName() {
            return this.goalName;
        }

        public AvgResources avgResources() {
            return this.avgResources;
        }

        public MaxResources maxResources() {
            return this.maxResources;
        }

        public MinResources minResources() {
            return this.minResources;
        }

        public StdResources stdResources() {
            return this.stdResources;
        }

        public GoalOverview goalOverview() {
            return this.goalOverview;
        }

        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public GoalStat setGoalName(String v) {
            this.goalName = v;
            return this;
        }

        public GoalStat setAvgResources(AvgResources v) {
            this.avgResources = v;
            return this;
        }

        public GoalStat setMaxResources(MaxResources v) {
            this.maxResources = v;
            return this;
        }

        public GoalStat setMinResources(MinResources v) {
            this.minResources = v;
            return this;
        }

        public GoalStat setStdResources(StdResources v) {
            this.stdResources = v;
            return this;
        }

        public GoalStat setGoalOverview(GoalOverview v) {
            this.goalOverview = v;
            return this;
        }
    }
}

