/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.EntityType;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.ImplicitLinkedHashMultiCollection;

public class DescribeBrokerReplicaExclusionsResponseData
implements ApiMessage {
    int throttleTimeMs;
    short errorCode;
    String errorMessage;
    BrokerReplicaExclusionResponseCollection excludedBrokers;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("throttle_time_ms", (Type)Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("error_code", (Type)Type.INT16, "The error code"), new Field("error_message", (Type)Type.NULLABLE_STRING, "The error message, or null if there was no error."), new Field("excluded_brokers", (Type)new ArrayOf((Type)BrokerReplicaExclusionResponse.SCHEMA_0), "Broker IDs that are excluded from replica placement.")});
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 0;

    public DescribeBrokerReplicaExclusionsResponseData(Readable _readable, short _version, MessageContext _context) {
        this.read(_readable, _version, _context);
    }

    public DescribeBrokerReplicaExclusionsResponseData() {
        this.throttleTimeMs = 0;
        this.errorCode = 0;
        this.errorMessage = "";
        this.excludedBrokers = new BrokerReplicaExclusionResponseCollection(0);
    }

    public short apiKey() {
        return 10016;
    }

    public short lowestSupportedVersion() {
        return 0;
    }

    public short highestSupportedVersion() {
        return 0;
    }

    public void read(Readable _readable, short _version, MessageContext _context) {
        this.throttleTimeMs = _readable.readInt();
        this.errorCode = _readable.readShort();
        short length = _readable.readShort();
        if (length < 0) {
            this.errorMessage = null;
        } else {
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field errorMessage had invalid length " + length);
            }
            this.errorMessage = _context.read(EntityType.ERROR_MESSAGE, _readable.readString((int)length));
        }
        int arrayLength = _readable.readInt();
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field excludedBrokers was serialized as null");
        }
        if (arrayLength > _readable.remaining()) {
            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
        }
        BrokerReplicaExclusionResponseCollection newCollection = new BrokerReplicaExclusionResponseCollection(arrayLength);
        for (int i = 0; i < arrayLength; ++i) {
            newCollection.add(new BrokerReplicaExclusionResponse(_readable, _version, _context));
        }
        this.excludedBrokers = newCollection;
        this._unknownTaggedFields = null;
    }

    public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        Object _stringBytes;
        int _numTaggedFields = 0;
        _writable.writeInt(this.throttleTimeMs);
        _writable.writeShort(this.errorCode);
        if (this.errorMessage == null) {
            _writable.writeShort((short)-1);
        } else {
            _stringBytes = _cache.getSerializedValue((Object)this.errorMessage);
            _writable.writeShort((short)((byte[])_stringBytes).length);
            _writable.writeByteArray((byte[])_stringBytes);
        }
        _writable.writeInt(this.excludedBrokers.size());
        _stringBytes = this.excludedBrokers.iterator();
        while (_stringBytes.hasNext()) {
            BrokerReplicaExclusionResponse excludedBrokersElement = (BrokerReplicaExclusionResponse)_stringBytes.next();
            excludedBrokersElement.write(_writable, _cache, _version, _context);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        if ((_numTaggedFields += _rawWriter.numFields()) > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        _size.addBytes(4);
        _size.addBytes(2);
        if (this.errorMessage == null) {
            _size.addBytes(2);
        } else {
            byte[] _stringBytes = _context.write(EntityType.ERROR_MESSAGE, this.errorMessage).getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'errorMessage' field is too long to be serialized");
            }
            _cache.cacheSerializedValue((Object)this.errorMessage, _stringBytes);
            _size.addBytes(_stringBytes.length + 2);
        }
        _size.addBytes(4);
        Iterator<RawTaggedField> iterator = this.excludedBrokers.iterator();
        while (iterator.hasNext()) {
            BrokerReplicaExclusionResponse excludedBrokersElement = (BrokerReplicaExclusionResponse)iterator.next();
            excludedBrokersElement.addSize(_size, _cache, _version, _context);
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                _size.addBytes(_field.size());
            }
        }
        if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DescribeBrokerReplicaExclusionsResponseData)) {
            return false;
        }
        DescribeBrokerReplicaExclusionsResponseData other = (DescribeBrokerReplicaExclusionsResponseData)obj;
        if (this.throttleTimeMs != other.throttleTimeMs) {
            return false;
        }
        if (this.errorCode != other.errorCode) {
            return false;
        }
        if (this.errorMessage == null ? other.errorMessage != null : !this.errorMessage.equals(other.errorMessage)) {
            return false;
        }
        if (this.excludedBrokers == null ? other.excludedBrokers != null : !this.excludedBrokers.equals((Object)other.excludedBrokers)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.throttleTimeMs;
        hashCode = 31 * hashCode + this.errorCode;
        hashCode = 31 * hashCode + (this.errorMessage == null ? 0 : this.errorMessage.hashCode());
        hashCode = 31 * hashCode + (this.excludedBrokers == null ? 0 : this.excludedBrokers.hashCode());
        return hashCode;
    }

    public DescribeBrokerReplicaExclusionsResponseData duplicate() {
        DescribeBrokerReplicaExclusionsResponseData _duplicate = new DescribeBrokerReplicaExclusionsResponseData();
        _duplicate.throttleTimeMs = this.throttleTimeMs;
        _duplicate.errorCode = this.errorCode;
        _duplicate.errorMessage = this.errorMessage == null ? null : this.errorMessage;
        BrokerReplicaExclusionResponseCollection newExcludedBrokers = new BrokerReplicaExclusionResponseCollection(this.excludedBrokers.size());
        Iterator iterator = this.excludedBrokers.iterator();
        while (iterator.hasNext()) {
            BrokerReplicaExclusionResponse _element = (BrokerReplicaExclusionResponse)iterator.next();
            newExcludedBrokers.add(_element.duplicate());
        }
        _duplicate.excludedBrokers = newExcludedBrokers;
        return _duplicate;
    }

    public String toString() {
        return "DescribeBrokerReplicaExclusionsResponseData(throttleTimeMs=" + this.throttleTimeMs + ", errorCode=" + this.errorCode + ", errorMessage=" + (this.errorMessage == null ? "null" : "'" + this.errorMessage.toString() + "'") + ", excludedBrokers=" + MessageUtil.deepToString((Iterator)this.excludedBrokers.iterator()) + ")";
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public short errorCode() {
        return this.errorCode;
    }

    public String errorMessage() {
        return this.errorMessage;
    }

    public BrokerReplicaExclusionResponseCollection excludedBrokers() {
        return this.excludedBrokers;
    }

    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public DescribeBrokerReplicaExclusionsResponseData setThrottleTimeMs(int v) {
        this.throttleTimeMs = v;
        return this;
    }

    public DescribeBrokerReplicaExclusionsResponseData setErrorCode(short v) {
        this.errorCode = v;
        return this;
    }

    public DescribeBrokerReplicaExclusionsResponseData setErrorMessage(String v) {
        this.errorMessage = v;
        return this;
    }

    public DescribeBrokerReplicaExclusionsResponseData setExcludedBrokers(BrokerReplicaExclusionResponseCollection v) {
        this.excludedBrokers = v;
        return this;
    }

    public static class BrokerReplicaExclusionResponseCollection
    extends ImplicitLinkedHashMultiCollection<BrokerReplicaExclusionResponse> {
        public BrokerReplicaExclusionResponseCollection() {
        }

        public BrokerReplicaExclusionResponseCollection(int expectedNumElements) {
            super(expectedNumElements);
        }

        public BrokerReplicaExclusionResponseCollection(Iterator<BrokerReplicaExclusionResponse> iterator) {
            super(iterator);
        }

        public BrokerReplicaExclusionResponse find(int brokerId) {
            BrokerReplicaExclusionResponse _key = new BrokerReplicaExclusionResponse();
            _key.setBrokerId(brokerId);
            return (BrokerReplicaExclusionResponse)this.find(_key);
        }

        public List<BrokerReplicaExclusionResponse> findAll(int brokerId) {
            BrokerReplicaExclusionResponse _key = new BrokerReplicaExclusionResponse();
            _key.setBrokerId(brokerId);
            return this.findAll(_key);
        }

        public BrokerReplicaExclusionResponseCollection duplicate() {
            BrokerReplicaExclusionResponseCollection _duplicate = new BrokerReplicaExclusionResponseCollection(this.size());
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                BrokerReplicaExclusionResponse _element = (BrokerReplicaExclusionResponse)iterator.next();
                _duplicate.add(_element.duplicate());
            }
            return _duplicate;
        }
    }

    public static class BrokerReplicaExclusionResponse
    implements Message,
    ImplicitLinkedHashCollection.Element {
        int brokerId;
        String reason;
        private List<RawTaggedField> _unknownTaggedFields;
        private int next;
        private int prev;
        public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("broker_id", (Type)Type.INT32, "The Broker ID that is excluded from replica placement"), new Field("reason", (Type)Type.STRING, "The user-provided reason for excluding the broker. An empty string if no reason was provided")});
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public BrokerReplicaExclusionResponse(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
            this.prev = -2;
            this.next = -2;
        }

        public BrokerReplicaExclusionResponse() {
            this.brokerId = 0;
            this.reason = "";
            this.prev = -2;
            this.next = -2;
        }

        public short lowestSupportedVersion() {
            return 0;
        }

        public short highestSupportedVersion() {
            return 0;
        }

        public void read(Readable _readable, short _version, MessageContext _context) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of BrokerReplicaExclusionResponse");
            }
            this.brokerId = _readable.readInt();
            short length = _readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field reason was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field reason had invalid length " + length);
            }
            this.reason = _readable.readString((int)length);
            this._unknownTaggedFields = null;
        }

        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            _writable.writeInt(this.brokerId);
            byte[] _stringBytes = _cache.getSerializedValue((Object)this.reason);
            _writable.writeShort((short)_stringBytes.length);
            _writable.writeByteArray(_stringBytes);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            if ((_numTaggedFields += _rawWriter.numFields()) > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of BrokerReplicaExclusionResponse");
            }
            _size.addBytes(4);
            byte[] _stringBytes = this.reason.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'reason' field is too long to be serialized");
            }
            _cache.cacheSerializedValue((Object)this.reason, _stringBytes);
            _size.addBytes(_stringBytes.length + 2);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        public boolean elementKeysAreEqual(Object obj) {
            if (!(obj instanceof BrokerReplicaExclusionResponse)) {
                return false;
            }
            BrokerReplicaExclusionResponse other = (BrokerReplicaExclusionResponse)obj;
            return this.brokerId == other.brokerId;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof BrokerReplicaExclusionResponse)) {
                return false;
            }
            BrokerReplicaExclusionResponse other = (BrokerReplicaExclusionResponse)obj;
            if (this.brokerId != other.brokerId) {
                return false;
            }
            if (this.reason == null ? other.reason != null : !this.reason.equals(other.reason)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.brokerId;
            return hashCode;
        }

        public BrokerReplicaExclusionResponse duplicate() {
            BrokerReplicaExclusionResponse _duplicate = new BrokerReplicaExclusionResponse();
            _duplicate.brokerId = this.brokerId;
            _duplicate.reason = this.reason;
            return _duplicate;
        }

        public String toString() {
            return "BrokerReplicaExclusionResponse(brokerId=" + this.brokerId + ", reason=" + (this.reason == null ? "null" : "'" + this.reason.toString() + "'") + ")";
        }

        public int brokerId() {
            return this.brokerId;
        }

        public String reason() {
            return this.reason;
        }

        public int next() {
            return this.next;
        }

        public int prev() {
            return this.prev;
        }

        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public BrokerReplicaExclusionResponse setBrokerId(int v) {
            this.brokerId = v;
            return this;
        }

        public BrokerReplicaExclusionResponse setReason(String v) {
            this.reason = v;
            return this;
        }

        public void setNext(int v) {
            this.next = v;
        }

        public void setPrev(int v) {
            this.prev = v;
        }
    }
}

