/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class InitiateReverseConnectionsRequestData
implements ApiMessage {
    Uuid clusterLinkId;
    String sourceClusterId;
    String targetClusterId;
    boolean forwardToBroker;
    int timeoutMs;
    List<EntryData> entries;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0;
    public static final Schema SCHEMA_1;
    public static final Schema[] SCHEMAS;
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 1;

    public InitiateReverseConnectionsRequestData(Readable _readable, short _version, MessageContext _context) {
        this.read(_readable, _version, _context);
    }

    public InitiateReverseConnectionsRequestData() {
        this.clusterLinkId = Uuid.ZERO_UUID;
        this.sourceClusterId = "";
        this.targetClusterId = "";
        this.forwardToBroker = false;
        this.timeoutMs = 60000;
        this.entries = new ArrayList<EntryData>(0);
    }

    public short apiKey() {
        return 10013;
    }

    public short lowestSupportedVersion() {
        return 0;
    }

    public short highestSupportedVersion() {
        return 1;
    }

    public void read(Readable _readable, short _version, MessageContext _context) {
        this.clusterLinkId = _readable.readUuid();
        int length = _readable.readUnsignedVarint() - 1;
        if (length < 0) {
            throw new RuntimeException("non-nullable field sourceClusterId was serialized as null");
        }
        if (length > Short.MAX_VALUE) {
            throw new RuntimeException("string field sourceClusterId had invalid length " + length);
        }
        this.sourceClusterId = _readable.readString(length);
        length = _readable.readUnsignedVarint() - 1;
        if (length < 0) {
            throw new RuntimeException("non-nullable field targetClusterId was serialized as null");
        }
        if (length > Short.MAX_VALUE) {
            throw new RuntimeException("string field targetClusterId had invalid length " + length);
        }
        this.targetClusterId = _readable.readString(length);
        this.forwardToBroker = _readable.readByte() != 0;
        this.timeoutMs = _readable.readInt();
        int arrayLength = _readable.readUnsignedVarint() - 1;
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field entries was serialized as null");
        }
        if (arrayLength > _readable.remaining()) {
            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
        }
        ArrayList<EntryData> newCollection = new ArrayList<EntryData>(arrayLength);
        for (int i = 0; i < arrayLength; ++i) {
            newCollection.add(new EntryData(_readable, _version, _context));
        }
        this.entries = newCollection;
        this._unknownTaggedFields = null;
        int _numTaggedFields = _readable.readUnsignedVarint();
        for (int _i = 0; _i < _numTaggedFields; ++_i) {
            int _tag = _readable.readUnsignedVarint();
            int _size = _readable.readUnsignedVarint();
            switch (_tag) {
                default: 
            }
            this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
        }
    }

    public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        _writable.writeUuid(this.clusterLinkId);
        Object _stringBytes = _cache.getSerializedValue((Object)this.sourceClusterId);
        _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
        _writable.writeByteArray((byte[])_stringBytes);
        _stringBytes = _cache.getSerializedValue((Object)this.targetClusterId);
        _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
        _writable.writeByteArray((byte[])_stringBytes);
        _writable.writeByte(this.forwardToBroker ? (byte)1 : 0);
        _writable.writeInt(this.timeoutMs);
        _writable.writeUnsignedVarint(this.entries.size() + 1);
        _stringBytes = this.entries.iterator();
        while (_stringBytes.hasNext()) {
            EntryData entriesElement = (EntryData)_stringBytes.next();
            entriesElement.write(_writable, _cache, _version, _context);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
        _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
    }

    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        _size.addBytes(16);
        byte[] _stringBytes = this.sourceClusterId.getBytes(StandardCharsets.UTF_8);
        if (_stringBytes.length > Short.MAX_VALUE) {
            throw new RuntimeException("'sourceClusterId' field is too long to be serialized");
        }
        _cache.cacheSerializedValue((Object)this.sourceClusterId, _stringBytes);
        _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1)));
        _stringBytes = this.targetClusterId.getBytes(StandardCharsets.UTF_8);
        if (_stringBytes.length > Short.MAX_VALUE) {
            throw new RuntimeException("'targetClusterId' field is too long to be serialized");
        }
        _cache.cacheSerializedValue((Object)this.targetClusterId, _stringBytes);
        _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1)));
        _size.addBytes(1);
        _size.addBytes(4);
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)(this.entries.size() + 1)));
        for (EntryData entriesElement : this.entries) {
            entriesElement.addSize(_size, _cache, _version, _context);
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                _size.addBytes(_field.size());
            }
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof InitiateReverseConnectionsRequestData)) {
            return false;
        }
        InitiateReverseConnectionsRequestData other = (InitiateReverseConnectionsRequestData)obj;
        if (!this.clusterLinkId.equals((Object)other.clusterLinkId)) {
            return false;
        }
        if (this.sourceClusterId == null ? other.sourceClusterId != null : !this.sourceClusterId.equals(other.sourceClusterId)) {
            return false;
        }
        if (this.targetClusterId == null ? other.targetClusterId != null : !this.targetClusterId.equals(other.targetClusterId)) {
            return false;
        }
        if (this.forwardToBroker != other.forwardToBroker) {
            return false;
        }
        if (this.timeoutMs != other.timeoutMs) {
            return false;
        }
        if (this.entries == null ? other.entries != null : !this.entries.equals(other.entries)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.clusterLinkId.hashCode();
        hashCode = 31 * hashCode + (this.sourceClusterId == null ? 0 : this.sourceClusterId.hashCode());
        hashCode = 31 * hashCode + (this.targetClusterId == null ? 0 : this.targetClusterId.hashCode());
        hashCode = 31 * hashCode + (this.forwardToBroker ? 1231 : 1237);
        hashCode = 31 * hashCode + this.timeoutMs;
        hashCode = 31 * hashCode + (this.entries == null ? 0 : this.entries.hashCode());
        return hashCode;
    }

    public InitiateReverseConnectionsRequestData duplicate() {
        InitiateReverseConnectionsRequestData _duplicate = new InitiateReverseConnectionsRequestData();
        _duplicate.clusterLinkId = this.clusterLinkId;
        _duplicate.sourceClusterId = this.sourceClusterId;
        _duplicate.targetClusterId = this.targetClusterId;
        _duplicate.forwardToBroker = this.forwardToBroker;
        _duplicate.timeoutMs = this.timeoutMs;
        ArrayList<EntryData> newEntries = new ArrayList<EntryData>(this.entries.size());
        for (EntryData _element : this.entries) {
            newEntries.add(_element.duplicate());
        }
        _duplicate.entries = newEntries;
        return _duplicate;
    }

    public String toString() {
        return "InitiateReverseConnectionsRequestData(clusterLinkId=" + this.clusterLinkId.toString() + ", sourceClusterId=" + (this.sourceClusterId == null ? "null" : "'" + this.sourceClusterId.toString() + "'") + ", targetClusterId=" + (this.targetClusterId == null ? "null" : "'" + this.targetClusterId.toString() + "'") + ", forwardToBroker=" + (this.forwardToBroker ? "true" : "false") + ", timeoutMs=" + this.timeoutMs + ", entries=" + MessageUtil.deepToString(this.entries.iterator()) + ")";
    }

    public Uuid clusterLinkId() {
        return this.clusterLinkId;
    }

    public String sourceClusterId() {
        return this.sourceClusterId;
    }

    public String targetClusterId() {
        return this.targetClusterId;
    }

    public boolean forwardToBroker() {
        return this.forwardToBroker;
    }

    public int timeoutMs() {
        return this.timeoutMs;
    }

    public List<EntryData> entries() {
        return this.entries;
    }

    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public InitiateReverseConnectionsRequestData setClusterLinkId(Uuid v) {
        this.clusterLinkId = v;
        return this;
    }

    public InitiateReverseConnectionsRequestData setSourceClusterId(String v) {
        this.sourceClusterId = v;
        return this;
    }

    public InitiateReverseConnectionsRequestData setTargetClusterId(String v) {
        this.targetClusterId = v;
        return this;
    }

    public InitiateReverseConnectionsRequestData setForwardToBroker(boolean v) {
        this.forwardToBroker = v;
        return this;
    }

    public InitiateReverseConnectionsRequestData setTimeoutMs(int v) {
        this.timeoutMs = v;
        return this;
    }

    public InitiateReverseConnectionsRequestData setEntries(List<EntryData> v) {
        this.entries = v;
        return this;
    }

    static {
        SCHEMA_1 = SCHEMA_0 = new Schema(new Field[]{new Field("cluster_link_id", (Type)Type.UUID, "Cluster link ID to which this connection will be assigned"), new Field("source_cluster_id", (Type)Type.COMPACT_STRING, "The cluster ID of the source cluster from which connections originate."), new Field("target_cluster_id", (Type)Type.COMPACT_STRING, "The cluster ID of the target cluster to which connections are established."), new Field("forward_to_broker", (Type)Type.BOOLEAN, "Boolean indicating if the request should be forwarded to target broker. This is used to ensure that target broker associates link credentials with the reverse connection."), new Field("timeout_ms", (Type)Type.INT32, "The time, in milliseconds, to allow for request completion."), new Field("entries", (Type)new CompactArrayOf((Type)EntryData.SCHEMA_0), "The details of the reverse connections to create."), Field.TaggedFieldsSection.of((Object[])new Object[0])});
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};
    }

    public static class EntryData
    implements Message {
        int initiateRequestId;
        int sourceBrokerId;
        int targetBrokerId;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema[] SCHEMAS;
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 1;

        public EntryData(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public EntryData() {
            this.initiateRequestId = 0;
            this.sourceBrokerId = 0;
            this.targetBrokerId = 0;
        }

        public short lowestSupportedVersion() {
            return 0;
        }

        public short highestSupportedVersion() {
            return 1;
        }

        public void read(Readable _readable, short _version, MessageContext _context) {
            if (_version > 1) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of EntryData");
            }
            this.initiateRequestId = _readable.readInt();
            this.sourceBrokerId = _readable.readInt();
            this.targetBrokerId = _readable.readInt();
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            _writable.writeInt(this.initiateRequestId);
            _writable.writeInt(this.sourceBrokerId);
            _writable.writeInt(this.targetBrokerId);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (_version > 1) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of EntryData");
            }
            _size.addBytes(4);
            _size.addBytes(4);
            _size.addBytes(4);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof EntryData)) {
                return false;
            }
            EntryData other = (EntryData)obj;
            if (this.initiateRequestId != other.initiateRequestId) {
                return false;
            }
            if (this.sourceBrokerId != other.sourceBrokerId) {
                return false;
            }
            if (this.targetBrokerId != other.targetBrokerId) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.initiateRequestId;
            hashCode = 31 * hashCode + this.sourceBrokerId;
            hashCode = 31 * hashCode + this.targetBrokerId;
            return hashCode;
        }

        public EntryData duplicate() {
            EntryData _duplicate = new EntryData();
            _duplicate.initiateRequestId = this.initiateRequestId;
            _duplicate.sourceBrokerId = this.sourceBrokerId;
            _duplicate.targetBrokerId = this.targetBrokerId;
            return _duplicate;
        }

        public String toString() {
            return "EntryData(initiateRequestId=" + this.initiateRequestId + ", sourceBrokerId=" + this.sourceBrokerId + ", targetBrokerId=" + this.targetBrokerId + ")";
        }

        public int initiateRequestId() {
            return this.initiateRequestId;
        }

        public int sourceBrokerId() {
            return this.sourceBrokerId;
        }

        public int targetBrokerId() {
            return this.targetBrokerId;
        }

        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public EntryData setInitiateRequestId(int v) {
            this.initiateRequestId = v;
            return this;
        }

        public EntryData setSourceBrokerId(int v) {
            this.sourceBrokerId = v;
            return this;
        }

        public EntryData setTargetBrokerId(int v) {
            this.targetBrokerId = v;
            return this;
        }

        static {
            SCHEMA_1 = SCHEMA_0 = new Schema(new Field[]{new Field("initiate_request_id", (Type)Type.INT32, "Request id used by target broker to correlate reverse connection established by source to the request."), new Field("source_broker_id", (Type)Type.INT32, "The broker ID from which connection is requested."), new Field("target_broker_id", (Type)Type.INT32, "The broker ID to which connection is requested."), Field.TaggedFieldsSection.of((Object[])new Object[0])});
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};
        }
    }
}

