/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.EntityType;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class ListTransactionsResponseData
implements ApiMessage {
    int throttleTimeMs;
    short errorCode;
    List<String> unknownStateFilters;
    List<TransactionState> transactionStates;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("throttle_time_ms", (Type)Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("error_code", (Type)Type.INT16, ""), new Field("unknown_state_filters", (Type)new CompactArrayOf((Type)Type.COMPACT_STRING), "Set of state filters provided in the request which were unknown to the transaction coordinator"), new Field("transaction_states", (Type)new CompactArrayOf((Type)TransactionState.SCHEMA_0), ""), Field.TaggedFieldsSection.of((Object[])new Object[0])});
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 0;

    public ListTransactionsResponseData(Readable _readable, short _version, MessageContext _context) {
        this.read(_readable, _version, _context);
    }

    public ListTransactionsResponseData() {
        this.throttleTimeMs = 0;
        this.errorCode = 0;
        this.unknownStateFilters = new ArrayList<String>(0);
        this.transactionStates = new ArrayList<TransactionState>(0);
    }

    public short apiKey() {
        return 66;
    }

    public short lowestSupportedVersion() {
        return 0;
    }

    public short highestSupportedVersion() {
        return 0;
    }

    public void read(Readable _readable, short _version, MessageContext _context) {
        int i;
        this.throttleTimeMs = _readable.readInt();
        this.errorCode = _readable.readShort();
        int arrayLength = _readable.readUnsignedVarint() - 1;
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field unknownStateFilters was serialized as null");
        }
        if (arrayLength > _readable.remaining()) {
            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
        }
        ArrayList<String> newCollection = new ArrayList<String>(arrayLength);
        for (i = 0; i < arrayLength; ++i) {
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field unknownStateFilters element was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field unknownStateFilters element had invalid length " + length);
            }
            newCollection.add(_readable.readString(length));
        }
        this.unknownStateFilters = newCollection;
        arrayLength = _readable.readUnsignedVarint() - 1;
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field transactionStates was serialized as null");
        }
        if (arrayLength > _readable.remaining()) {
            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
        }
        newCollection = new ArrayList(arrayLength);
        for (i = 0; i < arrayLength; ++i) {
            newCollection.add((String)((Object)new TransactionState(_readable, _version, _context)));
        }
        this.transactionStates = newCollection;
        this._unknownTaggedFields = null;
        int _numTaggedFields = _readable.readUnsignedVarint();
        for (int _i = 0; _i < _numTaggedFields; ++_i) {
            int _tag = _readable.readUnsignedVarint();
            int _size = _readable.readUnsignedVarint();
            switch (_tag) {
                default: 
            }
            this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
        }
    }

    public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        _writable.writeInt(this.throttleTimeMs);
        _writable.writeShort(this.errorCode);
        _writable.writeUnsignedVarint(this.unknownStateFilters.size() + 1);
        for (String unknownStateFiltersElement : this.unknownStateFilters) {
            byte[] _stringBytes = _cache.getSerializedValue((Object)unknownStateFiltersElement);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
        }
        _writable.writeUnsignedVarint(this.transactionStates.size() + 1);
        for (TransactionState transactionStatesElement : this.transactionStates) {
            transactionStatesElement.write(_writable, _cache, _version, _context);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
        _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
    }

    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        _size.addBytes(4);
        _size.addBytes(2);
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)(this.unknownStateFilters.size() + 1)));
        for (String unknownStateFiltersElement : this.unknownStateFilters) {
            byte[] _stringBytes = unknownStateFiltersElement.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'unknownStateFiltersElement' field is too long to be serialized");
            }
            _cache.cacheSerializedValue((Object)unknownStateFiltersElement, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1)));
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)(this.transactionStates.size() + 1)));
        for (TransactionState transactionStatesElement : this.transactionStates) {
            transactionStatesElement.addSize(_size, _cache, _version, _context);
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                _size.addBytes(_field.size());
            }
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ListTransactionsResponseData)) {
            return false;
        }
        ListTransactionsResponseData other = (ListTransactionsResponseData)obj;
        if (this.throttleTimeMs != other.throttleTimeMs) {
            return false;
        }
        if (this.errorCode != other.errorCode) {
            return false;
        }
        if (this.unknownStateFilters == null ? other.unknownStateFilters != null : !this.unknownStateFilters.equals(other.unknownStateFilters)) {
            return false;
        }
        if (this.transactionStates == null ? other.transactionStates != null : !this.transactionStates.equals(other.transactionStates)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.throttleTimeMs;
        hashCode = 31 * hashCode + this.errorCode;
        hashCode = 31 * hashCode + (this.unknownStateFilters == null ? 0 : this.unknownStateFilters.hashCode());
        hashCode = 31 * hashCode + (this.transactionStates == null ? 0 : this.transactionStates.hashCode());
        return hashCode;
    }

    public ListTransactionsResponseData duplicate() {
        ListTransactionsResponseData _duplicate = new ListTransactionsResponseData();
        _duplicate.throttleTimeMs = this.throttleTimeMs;
        _duplicate.errorCode = this.errorCode;
        ArrayList<String> newUnknownStateFilters = new ArrayList<String>(this.unknownStateFilters.size());
        for (String _element : this.unknownStateFilters) {
            newUnknownStateFilters.add(_element);
        }
        _duplicate.unknownStateFilters = newUnknownStateFilters;
        ArrayList<TransactionState> newTransactionStates = new ArrayList<TransactionState>(this.transactionStates.size());
        for (TransactionState _element : this.transactionStates) {
            newTransactionStates.add(_element.duplicate());
        }
        _duplicate.transactionStates = newTransactionStates;
        return _duplicate;
    }

    public String toString() {
        return "ListTransactionsResponseData(throttleTimeMs=" + this.throttleTimeMs + ", errorCode=" + this.errorCode + ", unknownStateFilters=" + MessageUtil.deepToString(this.unknownStateFilters.iterator()) + ", transactionStates=" + MessageUtil.deepToString(this.transactionStates.iterator()) + ")";
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public short errorCode() {
        return this.errorCode;
    }

    public List<String> unknownStateFilters() {
        return this.unknownStateFilters;
    }

    public List<TransactionState> transactionStates() {
        return this.transactionStates;
    }

    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public ListTransactionsResponseData setThrottleTimeMs(int v) {
        this.throttleTimeMs = v;
        return this;
    }

    public ListTransactionsResponseData setErrorCode(short v) {
        this.errorCode = v;
        return this;
    }

    public ListTransactionsResponseData setUnknownStateFilters(List<String> v) {
        this.unknownStateFilters = v;
        return this;
    }

    public ListTransactionsResponseData setTransactionStates(List<TransactionState> v) {
        this.transactionStates = v;
        return this;
    }

    public static class TransactionState
    implements Message {
        String transactionalId;
        long producerId;
        String transactionState;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("transactional_id", (Type)Type.COMPACT_STRING, ""), new Field("producer_id", (Type)Type.INT64, ""), new Field("transaction_state", (Type)Type.COMPACT_STRING, "The current transaction state of the producer"), Field.TaggedFieldsSection.of((Object[])new Object[0])});
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public TransactionState(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public TransactionState() {
            this.transactionalId = "";
            this.producerId = 0L;
            this.transactionState = "";
        }

        public short lowestSupportedVersion() {
            return 0;
        }

        public short highestSupportedVersion() {
            return 0;
        }

        public void read(Readable _readable, short _version, MessageContext _context) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of TransactionState");
            }
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field transactionalId was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field transactionalId had invalid length " + length);
            }
            this.transactionalId = _context.read(EntityType.TRANSACTIONAL_ID, _readable.readString(length));
            this.producerId = _readable.readLong();
            length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field transactionState was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field transactionState had invalid length " + length);
            }
            this.transactionState = _readable.readString(length);
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            byte[] _stringBytes = _cache.getSerializedValue((Object)this.transactionalId);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
            _writable.writeLong(this.producerId);
            _stringBytes = _cache.getSerializedValue((Object)this.transactionState);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of TransactionState");
            }
            byte[] _stringBytes = _context.write(EntityType.TRANSACTIONAL_ID, this.transactionalId).getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'transactionalId' field is too long to be serialized");
            }
            _cache.cacheSerializedValue((Object)this.transactionalId, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1)));
            _size.addBytes(8);
            _stringBytes = this.transactionState.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'transactionState' field is too long to be serialized");
            }
            _cache.cacheSerializedValue((Object)this.transactionState, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1)));
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TransactionState)) {
                return false;
            }
            TransactionState other = (TransactionState)obj;
            if (this.transactionalId == null ? other.transactionalId != null : !this.transactionalId.equals(other.transactionalId)) {
                return false;
            }
            if (this.producerId != other.producerId) {
                return false;
            }
            if (this.transactionState == null ? other.transactionState != null : !this.transactionState.equals(other.transactionState)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.transactionalId == null ? 0 : this.transactionalId.hashCode());
            hashCode = 31 * hashCode + ((int)(this.producerId >> 32) ^ (int)this.producerId);
            hashCode = 31 * hashCode + (this.transactionState == null ? 0 : this.transactionState.hashCode());
            return hashCode;
        }

        public TransactionState duplicate() {
            TransactionState _duplicate = new TransactionState();
            _duplicate.transactionalId = this.transactionalId;
            _duplicate.producerId = this.producerId;
            _duplicate.transactionState = this.transactionState;
            return _duplicate;
        }

        public String toString() {
            return "TransactionState(transactionalId=" + (this.transactionalId == null ? "null" : "'" + this.transactionalId.toString() + "'") + ", producerId=" + this.producerId + ", transactionState=" + (this.transactionState == null ? "null" : "'" + this.transactionState.toString() + "'") + ")";
        }

        public String transactionalId() {
            return this.transactionalId;
        }

        public long producerId() {
            return this.producerId;
        }

        public String transactionState() {
            return this.transactionState;
        }

        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public TransactionState setTransactionalId(String v) {
            this.transactionalId = v;
            return this;
        }

        public TransactionState setProducerId(long v) {
            this.producerId = v;
            return this;
        }

        public TransactionState setTransactionState(String v) {
            this.transactionState = v;
            return this;
        }
    }
}

