/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.ProduceResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.common.requests.RequestTestUtils;
import org.apache.kafka.common.requests.ResponseHeader;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ProduceResponseTest {
    @Test
    public void produceResponseV5Test() {
        HashMap<TopicPartition, ProduceResponse.PartitionResponse> responseData = new HashMap<TopicPartition, ProduceResponse.PartitionResponse>();
        TopicPartition tp0 = new TopicPartition("test", 0);
        responseData.put(tp0, new ProduceResponse.PartitionResponse(Errors.NONE, 10000L, -1L, 100L));
        ProduceResponse v5Response = new ProduceResponse(responseData, 10);
        short version = 5;
        ByteBuffer buffer = RequestTestUtils.serializeResponseWithHeader((AbstractResponse)v5Response, version, 0);
        ResponseHeader.parse((ByteBuffer)buffer, (short)ApiKeys.PRODUCE.responseHeaderVersion(version));
        ProduceResponse v5FromBytes = (ProduceResponse)AbstractResponse.parseResponse((ApiKeys)ApiKeys.PRODUCE, (ByteBuffer)buffer, (short)version, (MessageContext)MessageContext.IDENTITY);
        Assertions.assertEquals((int)1, (int)v5FromBytes.data().responses().size());
        ProduceResponseData.TopicProduceResponse topicProduceResponse = (ProduceResponseData.TopicProduceResponse)v5FromBytes.data().responses().iterator().next();
        Assertions.assertEquals((int)1, (int)topicProduceResponse.partitionResponses().size());
        ProduceResponseData.PartitionProduceResponse partitionProduceResponse = topicProduceResponse.partitionResponses().iterator().next();
        TopicPartition tp = new TopicPartition(topicProduceResponse.name(), partitionProduceResponse.index());
        Assertions.assertEquals((Object)tp0, (Object)tp);
        Assertions.assertEquals((long)100L, (long)partitionProduceResponse.logStartOffset());
        Assertions.assertEquals((long)10000L, (long)partitionProduceResponse.baseOffset());
        Assertions.assertEquals((long)-1L, (long)partitionProduceResponse.logAppendTimeMs());
        Assertions.assertEquals((Object)Errors.NONE, (Object)Errors.forCode((short)partitionProduceResponse.errorCode()));
        Assertions.assertNull((Object)partitionProduceResponse.errorMessage());
        Assertions.assertTrue((boolean)partitionProduceResponse.recordErrors().isEmpty());
    }

    @Test
    public void produceResponseVersionTest() {
        HashMap<TopicPartition, ProduceResponse.PartitionResponse> responseData = new HashMap<TopicPartition, ProduceResponse.PartitionResponse>();
        responseData.put(new TopicPartition("test", 0), new ProduceResponse.PartitionResponse(Errors.NONE, 10000L, -1L, 100L));
        ProduceResponse v0Response = new ProduceResponse(responseData);
        ProduceResponse v1Response = new ProduceResponse(responseData, 10);
        ProduceResponse v2Response = new ProduceResponse(responseData, 10);
        Assertions.assertEquals((int)0, (int)v0Response.throttleTimeMs(), (String)"Throttle time must be zero");
        Assertions.assertEquals((int)10, (int)v1Response.throttleTimeMs(), (String)"Throttle time must be 10");
        Assertions.assertEquals((int)10, (int)v2Response.throttleTimeMs(), (String)"Throttle time must be 10");
        List<ProduceResponse> arrResponse = Arrays.asList(v0Response, v1Response, v2Response);
        for (ProduceResponse produceResponse : arrResponse) {
            Assertions.assertEquals((int)1, (int)produceResponse.data().responses().size());
            ProduceResponseData.TopicProduceResponse topicProduceResponse = (ProduceResponseData.TopicProduceResponse)produceResponse.data().responses().iterator().next();
            Assertions.assertEquals((int)1, (int)topicProduceResponse.partitionResponses().size());
            ProduceResponseData.PartitionProduceResponse partitionProduceResponse = topicProduceResponse.partitionResponses().iterator().next();
            Assertions.assertEquals((long)100L, (long)partitionProduceResponse.logStartOffset());
            Assertions.assertEquals((long)10000L, (long)partitionProduceResponse.baseOffset());
            Assertions.assertEquals((long)-1L, (long)partitionProduceResponse.logAppendTimeMs());
            Assertions.assertEquals((Object)Errors.NONE, (Object)Errors.forCode((short)partitionProduceResponse.errorCode()));
            Assertions.assertNull((Object)partitionProduceResponse.errorMessage());
            Assertions.assertTrue((boolean)partitionProduceResponse.recordErrors().isEmpty());
        }
    }

    @Test
    public void produceResponseRecordErrorsTest() {
        HashMap<TopicPartition, ProduceResponse.PartitionResponse> responseData = new HashMap<TopicPartition, ProduceResponse.PartitionResponse>();
        TopicPartition tp = new TopicPartition("test", 0);
        ProduceResponse.PartitionResponse partResponse = new ProduceResponse.PartitionResponse(Errors.NONE, 10000L, -1L, 100L, Collections.singletonList(new ProduceResponse.RecordError(3, "Record error")), "Produce failed");
        responseData.put(tp, partResponse);
        Iterator iterator = ApiKeys.PRODUCE.allVersions().iterator();
        while (iterator.hasNext()) {
            short version = (Short)iterator.next();
            ProduceResponse response = new ProduceResponse(responseData);
            ProduceResponse produceResponse = ProduceResponse.parse((ByteBuffer)response.serialize(version), (short)version, (MessageContext)MessageContext.IDENTITY);
            ProduceResponseData.TopicProduceResponse topicProduceResponse = (ProduceResponseData.TopicProduceResponse)produceResponse.data().responses().iterator().next();
            ProduceResponseData.PartitionProduceResponse deserialized = topicProduceResponse.partitionResponses().iterator().next();
            if (version >= 8) {
                Assertions.assertEquals((int)1, (int)deserialized.recordErrors().size());
                Assertions.assertEquals((int)3, (int)deserialized.recordErrors().get(0).batchIndex());
                Assertions.assertEquals((Object)"Record error", (Object)deserialized.recordErrors().get(0).batchIndexErrorMessage());
                Assertions.assertEquals((Object)"Produce failed", (Object)deserialized.errorMessage());
                continue;
            }
            Assertions.assertEquals((int)0, (int)deserialized.recordErrors().size());
            Assertions.assertNull((Object)deserialized.errorMessage());
        }
    }
}

