/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.ArrayList;
import java.util.HashSet;
import org.apache.kafka.clients.admin.RemoveBrokersOptions;
import org.apache.kafka.common.message.RemoveBrokersRequestData;
import org.apache.kafka.common.requests.RemoveBrokersRequest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RemoveBrokersRequestTest {
    @Test
    public void testRemoveBrokerRequestBuilder() {
        HashSet<RemoveBrokersRequestData.BrokerId> brokerIds = new HashSet<RemoveBrokersRequestData.BrokerId>();
        brokerIds.add(new RemoveBrokersRequestData.BrokerId().setBrokerId(2));
        brokerIds.add(new RemoveBrokersRequestData.BrokerId().setBrokerId(3));
        RemoveBrokersOptions options = new RemoveBrokersOptions();
        Assertions.assertTrue((boolean)options.shouldShutdownBrokers());
        RemoveBrokersRequest request = (RemoveBrokersRequest)new RemoveBrokersRequest.Builder(brokerIds, options.shouldShutdownBrokers()).build();
        Assertions.assertTrue((boolean)request.data().shouldShutdown());
        Assertions.assertEquals(new ArrayList(brokerIds), request.data().brokersToRemove());
    }

    @Test
    public void setShouldShutdownOptionRequestBuilder() {
        HashSet<RemoveBrokersRequestData.BrokerId> brokerIds = new HashSet<RemoveBrokersRequestData.BrokerId>();
        brokerIds.add(new RemoveBrokersRequestData.BrokerId().setBrokerId(2));
        RemoveBrokersOptions options = new RemoveBrokersOptions();
        options.shouldShutdownBrokers(false);
        RemoveBrokersRequest request = (RemoveBrokersRequest)new RemoveBrokersRequest.Builder(brokerIds, options.shouldShutdownBrokers()).build();
        Assertions.assertFalse((boolean)request.data().shouldShutdown());
        Assertions.assertEquals(new ArrayList(brokerIds), request.data().brokersToRemove());
    }
}

