/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.authenticator;

import org.apache.kafka.common.security.authenticator.PathAwareSniHostName;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PathAwareSniHostnameTest {
    @Test
    public void testV3BootstrapHostname() {
        PathAwareSniHostName sniHostName = new PathAwareSniHostName("pkc-abc.us-west-2.aws.confluent.cloud");
        Assertions.assertNull((Object)sniHostName.routingPathPrefix());
        Assertions.assertNull((Object)sniHostName.logicalClusterId());
        Assertions.assertEquals((Object)"pkc-abc.us-west-2.aws.confluent.cloud", (Object)sniHostName.strippedHostname());
    }

    @Test
    public void testV3BrokerHostname() {
        this.testV3BrokerHostname("b0-pkc-abc.us-west-2.aws.confluent.cloud");
        this.testV3BrokerHostname("b10-pkc-abc.us-west-2.aws.confluent.cloud");
    }

    @Test
    public void testV4Bootstrap() {
        PathAwareSniHostName sniHostName = new PathAwareSniHostName("lkc-1234-x092.us-west-2.aws.glb.confluent.cloud");
        Assertions.assertNull((Object)sniHostName.routingPathPrefix());
        Assertions.assertEquals((Object)"lkc-1234", (Object)sniHostName.logicalClusterId());
        Assertions.assertEquals((Object)"lkc-1234-x092.us-west-2.aws.glb.confluent.cloud", (Object)sniHostName.strippedHostname());
    }

    @Test
    public void testV4BootstrapWithPathPrefix() {
        PathAwareSniHostName sniHostName = new PathAwareSniHostName("pb-lkc-1234-x092.us-west-2.aws.glb.confluent.cloud");
        Assertions.assertEquals((Object)"pb", (Object)sniHostName.routingPathPrefix());
        Assertions.assertEquals((Object)"lkc-1234", (Object)sniHostName.logicalClusterId());
        Assertions.assertEquals((Object)"lkc-1234-x092.us-west-2.aws.glb.confluent.cloud", (Object)sniHostName.strippedHostname());
    }

    @Test
    public void testV4BrokerNoLogicalCluster() {
        PathAwareSniHostName sniHostName = new PathAwareSniHostName("e-00aa-usw2-az1-x092.us-west-2.aws.glb.confluent.cloud");
        Assertions.assertNull((Object)sniHostName.routingPathPrefix());
        Assertions.assertNull((Object)sniHostName.logicalClusterId());
        Assertions.assertEquals((Object)"e-00aa-usw2-az1-x092.us-west-2.aws.glb.confluent.cloud", (Object)sniHostName.strippedHostname());
    }

    @Test
    public void testV4BrokerNoLogicalClusterWithPathPrefix() {
        PathAwareSniHostName sniHostName = new PathAwareSniHostName("pb-e-00aa-usw2-az1-x092.us-west-2.aws.glb.confluent.cloud");
        Assertions.assertEquals((Object)"pb", (Object)sniHostName.routingPathPrefix());
        Assertions.assertNull((Object)sniHostName.logicalClusterId());
        Assertions.assertEquals((Object)"e-00aa-usw2-az1-x092.us-west-2.aws.glb.confluent.cloud", (Object)sniHostName.strippedHostname());
    }

    @Test
    public void testV4BrokerWithLogicalCluster() {
        PathAwareSniHostName sniHostName = new PathAwareSniHostName("lkc-1234-00aa-usw2-az1-x092.us-west-2.aws.glb.confluent.cloud");
        Assertions.assertNull((Object)sniHostName.routingPathPrefix());
        Assertions.assertEquals((Object)"lkc-1234", (Object)sniHostName.logicalClusterId());
        Assertions.assertEquals((Object)"lkc-1234-00aa-usw2-az1-x092.us-west-2.aws.glb.confluent.cloud", (Object)sniHostName.strippedHostname());
    }

    @Test
    public void testV4BrokerWithLogicalClusterWithPathPrefix() {
        PathAwareSniHostName sniHostName = new PathAwareSniHostName("pb-lkc-1234-00aa-usw2-az1-x092.us-west-2.aws.glb.confluent.cloud");
        Assertions.assertEquals((Object)"pb", (Object)sniHostName.routingPathPrefix());
        Assertions.assertEquals((Object)"lkc-1234", (Object)sniHostName.logicalClusterId());
        Assertions.assertEquals((Object)"lkc-1234-00aa-usw2-az1-x092.us-west-2.aws.glb.confluent.cloud", (Object)sniHostName.strippedHostname());
    }

    @Test
    public void testHostnameNotNull() {
        Assertions.assertThrows(NullPointerException.class, () -> new PathAwareSniHostName(null));
    }

    private void testV3BrokerHostname(String hostname) {
        PathAwareSniHostName sniHostName = new PathAwareSniHostName(hostname);
        Assertions.assertNull((Object)sniHostName.routingPathPrefix());
        Assertions.assertNull((Object)sniHostName.logicalClusterId());
        Assertions.assertEquals((Object)hostname, (Object)sniHostName.strippedHostname());
    }
}

