/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.authenticator;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.common.security.authenticator.TestDigestLoginModule;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerLoginModule;
import org.apache.kafka.common.security.plain.PlainLoginModule;
import org.apache.kafka.common.security.scram.ScramLoginModule;
import org.apache.kafka.common.security.scram.internals.ScramMechanism;

public class TestJaasConfig
extends Configuration {
    static final String LOGIN_CONTEXT_CLIENT = "KafkaClient";
    static final String LOGIN_CONTEXT_SERVER = "KafkaServer";
    public static final String USERNAME = "myuser";
    public static final String PASSWORD = "mypassword";
    private Map<String, AppConfigurationEntry[]> entryMap = new HashMap<String, AppConfigurationEntry[]>();

    public static TestJaasConfig createConfiguration(String clientMechanism, List<String> serverMechanisms) {
        TestJaasConfig config = new TestJaasConfig();
        config.createOrUpdateEntry(LOGIN_CONTEXT_CLIENT, TestJaasConfig.loginModule(clientMechanism), TestJaasConfig.defaultClientOptions(clientMechanism));
        for (String mechanism : serverMechanisms) {
            config.addEntry(LOGIN_CONTEXT_SERVER, TestJaasConfig.loginModule(mechanism), TestJaasConfig.defaultServerOptions(mechanism));
        }
        Configuration.setConfiguration(config);
        return config;
    }

    public static Password jaasConfigProperty(String mechanism, String username, String password) {
        return new Password(TestJaasConfig.loginModule(mechanism) + " required username=" + username + " password=" + password + ";");
    }

    public static Password jaasConfigProperty(String mechanism, Map<String, Object> options) {
        StringBuilder builder = new StringBuilder();
        builder.append(TestJaasConfig.loginModule(mechanism));
        builder.append(" required");
        for (Map.Entry<String, Object> option : options.entrySet()) {
            builder.append(' ');
            builder.append(option.getKey());
            builder.append('=');
            builder.append(option.getValue());
        }
        builder.append(';');
        return new Password(builder.toString());
    }

    public void setClientOptions(String saslMechanism, String clientUsername, String clientPassword) {
        HashMap<String, Object> options = new HashMap<String, Object>();
        if (clientUsername != null) {
            options.put("username", clientUsername);
        }
        if (clientPassword != null) {
            options.put("password", clientPassword);
        }
        Class loginModuleClass = ScramMechanism.isScram((String)saslMechanism) ? ScramLoginModule.class : PlainLoginModule.class;
        this.createOrUpdateEntry(LOGIN_CONTEXT_CLIENT, loginModuleClass.getName(), options);
    }

    public void createOrUpdateEntry(String name, String loginModule, Map<String, Object> options) {
        AppConfigurationEntry entry = new AppConfigurationEntry(loginModule, AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options);
        this.entryMap.put(name, new AppConfigurationEntry[]{entry});
    }

    public void addEntry(String name, String loginModule, Map<String, Object> options) {
        AppConfigurationEntry entry = new AppConfigurationEntry(loginModule, AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options);
        AppConfigurationEntry[] existing = this.entryMap.get(name);
        AppConfigurationEntry[] newEntries = existing == null ? new AppConfigurationEntry[1] : Arrays.copyOf(existing, existing.length + 1);
        newEntries[newEntries.length - 1] = entry;
        this.entryMap.put(name, newEntries);
    }

    @Override
    public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
        return this.entryMap.get(name);
    }

    private static String loginModule(String mechanism) {
        String loginModule;
        switch (mechanism) {
            case "PLAIN": {
                loginModule = PlainLoginModule.class.getName();
                break;
            }
            case "DIGEST-MD5": {
                loginModule = TestDigestLoginModule.class.getName();
                break;
            }
            case "OAUTHBEARER": {
                loginModule = OAuthBearerLoginModule.class.getName();
                break;
            }
            default: {
                if (ScramMechanism.isScram((String)mechanism)) {
                    loginModule = ScramLoginModule.class.getName();
                    break;
                }
                throw new IllegalArgumentException("Unsupported mechanism " + mechanism);
            }
        }
        return loginModule;
    }

    public static Map<String, Object> defaultClientOptions(String mechanism) {
        switch (mechanism) {
            case "OAUTHBEARER": {
                HashMap<String, Object> options = new HashMap<String, Object>();
                options.put("unsecuredLoginStringClaim_sub", USERNAME);
                return options;
            }
        }
        return TestJaasConfig.defaultClientOptions();
    }

    public static Map<String, Object> defaultClientOptions() {
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("username", USERNAME);
        options.put("password", PASSWORD);
        return options;
    }

    public static Map<String, Object> defaultServerOptions(String mechanism) {
        HashMap<String, Object> options = new HashMap<String, Object>();
        switch (mechanism) {
            case "PLAIN": 
            case "DIGEST-MD5": {
                options.put("user_myuser", PASSWORD);
                break;
            }
            case "OAUTHBEARER": {
                options.put("unsecuredLoginStringClaim_sub", USERNAME);
                break;
            }
            default: {
                if (ScramMechanism.isScram((String)mechanism)) break;
                throw new IllegalArgumentException("Unsupported mechanism " + mechanism);
            }
        }
        return options;
    }
}

