/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.kafka.common.ConfluentNode;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.message.DescribeClusterResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.requests.AbstractResponse;

public class DescribeClusterResponse
extends AbstractResponse {
    private final DescribeClusterResponseData data;

    public DescribeClusterResponse(DescribeClusterResponseData data) {
        super(ApiKeys.DESCRIBE_CLUSTER);
        this.data = data;
    }

    public Map<Integer, Node> nodes() {
        return this.data.brokers().valuesList().stream().map(b -> new ConfluentNode(b.brokerId(), b.host(), b.port(), b.rack(), DescribeClusterResponse.mapFromTags(b.tags()))).collect(Collectors.toMap(Node::id, Function.identity()));
    }

    private static Map<String, String> mapFromTags(DescribeClusterResponseData.TagKeyValueCollection tags) {
        return tags.stream().collect(Collectors.toMap(DescribeClusterResponseData.TagKeyValue::name, DescribeClusterResponseData.TagKeyValue::value));
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        return this.errorCounts(Errors.forCode(this.data.errorCode()));
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    @Override
    public void maybeSetThrottleTimeMs(int throttleTimeMs) {
        this.data.setThrottleTimeMs(throttleTimeMs);
    }

    @Override
    public DescribeClusterResponseData data() {
        return this.data;
    }

    public static DescribeClusterResponse parse(ByteBuffer buffer, short version, MessageContext context) {
        return new DescribeClusterResponse(new DescribeClusterResponseData(new ByteBufferAccessor(buffer), version, context));
    }
}

