/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.protocol;

import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.types.BoundField;
import org.apache.kafka.common.protocol.types.Schema;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ApiKeysTest {
    @Test
    public void testForIdWithInvalidIdLow() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> ApiKeys.forId((int)-1));
    }

    @Test
    public void testForIdWithInvalidIdHigh() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> ApiKeys.forId((int)10000));
    }

    @Test
    public void testAlterPartitionIsClusterAction() {
        Assertions.assertTrue((boolean)ApiKeys.ALTER_PARTITION.clusterAction);
    }

    @Test
    public void testResponseThrottleTime() {
        EnumSet<ApiKeys> authenticationKeys = EnumSet.of(ApiKeys.SASL_HANDSHAKE, ApiKeys.SASL_AUTHENTICATE);
        EnumSet<ApiKeys> clusterActionsWithThrottleTimeMs = EnumSet.of(ApiKeys.ALTER_PARTITION, ApiKeys.ALLOCATE_PRODUCER_IDS, ApiKeys.UPDATE_FEATURES);
        for (ApiKeys apiKey : ApiKeys.zkBrokerApis()) {
            Schema responseSchema = apiKey.messageType.responseSchemas()[apiKey.latestVersion()];
            BoundField throttleTimeField = responseSchema.get("throttle_time_ms");
            if (apiKey.clusterAction && !clusterActionsWithThrottleTimeMs.contains(apiKey) || authenticationKeys.contains(apiKey)) {
                Assertions.assertNull((Object)throttleTimeField, (String)("Unexpected throttle time field: " + apiKey));
                continue;
            }
            Assertions.assertNotNull((Object)throttleTimeField, (String)("Throttle time field missing: " + apiKey));
        }
    }

    @Test
    public void testApiScope() {
        HashSet<ApiKeys> apisMissingScope = new HashSet<ApiKeys>();
        for (ApiKeys apiKey : ApiKeys.values()) {
            if (!apiKey.messageType.listeners().isEmpty()) continue;
            apisMissingScope.add(apiKey);
        }
        Assertions.assertEquals(Collections.emptySet(), apisMissingScope, (String)"Found some APIs missing scope definition");
    }
}

