/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.utils;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.Random;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollectionTest;
import org.apache.kafka.common.utils.ImplicitLinkedHashMultiCollection;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=120L)
public class ImplicitLinkedHashMultiCollectionTest {
    @Test
    public void testNullForbidden() {
        ImplicitLinkedHashMultiCollection multiSet = new ImplicitLinkedHashMultiCollection();
        Assertions.assertFalse((boolean)multiSet.add(null));
    }

    @Test
    public void testFindFindAllContainsRemoveOnEmptyCollection() {
        ImplicitLinkedHashMultiCollection coll = new ImplicitLinkedHashMultiCollection();
        Assertions.assertNull((Object)coll.find((ImplicitLinkedHashCollection.Element)new ImplicitLinkedHashCollectionTest.TestElement(2)));
        Assertions.assertFalse((boolean)coll.contains((Object)new ImplicitLinkedHashCollectionTest.TestElement(2)));
        Assertions.assertFalse((boolean)coll.remove((Object)new ImplicitLinkedHashCollectionTest.TestElement(2)));
        Assertions.assertTrue((boolean)coll.findAll((ImplicitLinkedHashCollection.Element)new ImplicitLinkedHashCollectionTest.TestElement(2)).isEmpty());
    }

    @Test
    public void testInsertDelete() {
        ImplicitLinkedHashMultiCollection multiSet = new ImplicitLinkedHashMultiCollection(100);
        ImplicitLinkedHashCollectionTest.TestElement e1 = new ImplicitLinkedHashCollectionTest.TestElement(1);
        ImplicitLinkedHashCollectionTest.TestElement e2 = new ImplicitLinkedHashCollectionTest.TestElement(1);
        ImplicitLinkedHashCollectionTest.TestElement e3 = new ImplicitLinkedHashCollectionTest.TestElement(2);
        multiSet.mustAdd((ImplicitLinkedHashCollection.Element)e1);
        multiSet.mustAdd((ImplicitLinkedHashCollection.Element)e2);
        multiSet.mustAdd((ImplicitLinkedHashCollection.Element)e3);
        Assertions.assertFalse((boolean)multiSet.add((ImplicitLinkedHashCollection.Element)e3));
        Assertions.assertEquals((int)3, (int)multiSet.size());
        ImplicitLinkedHashMultiCollectionTest.expectExactTraversal(multiSet.findAll((ImplicitLinkedHashCollection.Element)e1).iterator(), e1, e2);
        ImplicitLinkedHashMultiCollectionTest.expectExactTraversal(multiSet.findAll((ImplicitLinkedHashCollection.Element)e3).iterator(), e3);
        multiSet.remove((Object)e2);
        ImplicitLinkedHashMultiCollectionTest.expectExactTraversal(multiSet.findAll((ImplicitLinkedHashCollection.Element)e1).iterator(), e1);
        Assertions.assertTrue((boolean)multiSet.contains((Object)e2));
    }

    @Test
    public void testTraversal() {
        ImplicitLinkedHashMultiCollection multiSet = new ImplicitLinkedHashMultiCollection();
        ImplicitLinkedHashMultiCollectionTest.expectExactTraversal(multiSet.iterator(), new ImplicitLinkedHashCollectionTest.TestElement[0]);
        ImplicitLinkedHashCollectionTest.TestElement e1 = new ImplicitLinkedHashCollectionTest.TestElement(1);
        ImplicitLinkedHashCollectionTest.TestElement e2 = new ImplicitLinkedHashCollectionTest.TestElement(1);
        ImplicitLinkedHashCollectionTest.TestElement e3 = new ImplicitLinkedHashCollectionTest.TestElement(2);
        Assertions.assertTrue((boolean)multiSet.add((ImplicitLinkedHashCollection.Element)e1));
        Assertions.assertTrue((boolean)multiSet.add((ImplicitLinkedHashCollection.Element)e2));
        Assertions.assertTrue((boolean)multiSet.add((ImplicitLinkedHashCollection.Element)e3));
        ImplicitLinkedHashMultiCollectionTest.expectExactTraversal(multiSet.iterator(), e1, e2, e3);
        Assertions.assertTrue((boolean)multiSet.remove((Object)e2));
        ImplicitLinkedHashMultiCollectionTest.expectExactTraversal(multiSet.iterator(), e1, e3);
        Assertions.assertTrue((boolean)multiSet.remove((Object)e1));
        ImplicitLinkedHashMultiCollectionTest.expectExactTraversal(multiSet.iterator(), e3);
    }

    static void expectExactTraversal(Iterator<ImplicitLinkedHashCollectionTest.TestElement> iterator, ImplicitLinkedHashCollectionTest.TestElement ... sequence) {
        int i = 0;
        while (iterator.hasNext()) {
            ImplicitLinkedHashCollectionTest.TestElement element = iterator.next();
            Assertions.assertTrue((i < sequence.length ? 1 : 0) != 0, (String)("Iterator yieled " + (i + 1) + " elements, but only " + sequence.length + " were expected."));
            if (sequence[i] != element) {
                Assertions.fail((String)("Iterator value number " + (i + 1) + " was incorrect."));
            }
            ++i;
        }
        Assertions.assertEquals((int)sequence.length, (int)i, (String)("Iterator yieled " + (i + 1) + " elements, but " + sequence.length + " were expected."));
    }

    @Test
    public void testEnlargement() {
        int i;
        ImplicitLinkedHashMultiCollection multiSet = new ImplicitLinkedHashMultiCollection(5);
        Assertions.assertEquals((int)11, (int)multiSet.numSlots());
        ImplicitLinkedHashCollectionTest.TestElement[] testElements = new ImplicitLinkedHashCollectionTest.TestElement[]{new ImplicitLinkedHashCollectionTest.TestElement(100), new ImplicitLinkedHashCollectionTest.TestElement(101), new ImplicitLinkedHashCollectionTest.TestElement(102), new ImplicitLinkedHashCollectionTest.TestElement(100), new ImplicitLinkedHashCollectionTest.TestElement(101), new ImplicitLinkedHashCollectionTest.TestElement(105)};
        for (i = 0; i < testElements.length; ++i) {
            Assertions.assertTrue((boolean)multiSet.add((ImplicitLinkedHashCollection.Element)testElements[i]));
        }
        for (i = 0; i < testElements.length; ++i) {
            Assertions.assertFalse((boolean)multiSet.add((ImplicitLinkedHashCollection.Element)testElements[i]));
        }
        Assertions.assertEquals((int)23, (int)multiSet.numSlots());
        Assertions.assertEquals((int)testElements.length, (int)multiSet.size());
        ImplicitLinkedHashMultiCollectionTest.expectExactTraversal(multiSet.iterator(), testElements);
        multiSet.remove((Object)testElements[1]);
        Assertions.assertEquals((int)23, (int)multiSet.numSlots());
        Assertions.assertEquals((int)5, (int)multiSet.size());
        ImplicitLinkedHashMultiCollectionTest.expectExactTraversal(multiSet.iterator(), testElements[0], testElements[2], testElements[3], testElements[4], testElements[5]);
    }

    @Test
    public void testManyInsertsAndDeletes() {
        Random random = new Random(123L);
        LinkedList<ImplicitLinkedHashCollectionTest.TestElement> existing = new LinkedList<ImplicitLinkedHashCollectionTest.TestElement>();
        ImplicitLinkedHashMultiCollection multiSet = new ImplicitLinkedHashMultiCollection();
        for (int i = 0; i < 100; ++i) {
            for (int j = 0; j < 4; ++j) {
                ImplicitLinkedHashCollectionTest.TestElement testElement = new ImplicitLinkedHashCollectionTest.TestElement(random.nextInt());
                multiSet.mustAdd((ImplicitLinkedHashCollection.Element)testElement);
                existing.add(testElement);
            }
            int elementToRemove = random.nextInt(multiSet.size());
            Iterator iter1 = multiSet.iterator();
            Iterator iter2 = existing.iterator();
            for (int j = 0; j <= elementToRemove; ++j) {
                iter1.next();
                iter2.next();
            }
            iter1.remove();
            iter2.remove();
            this.expectTraversal(multiSet.iterator(), existing.iterator());
        }
    }

    void expectTraversal(Iterator<ImplicitLinkedHashCollectionTest.TestElement> iter, Iterator<ImplicitLinkedHashCollectionTest.TestElement> expectedIter) {
        int i = 0;
        while (iter.hasNext()) {
            ImplicitLinkedHashCollectionTest.TestElement element = iter.next();
            Assertions.assertTrue((boolean)expectedIter.hasNext(), (String)("Iterator yieled " + (i + 1) + " elements, but only " + i + " were expected."));
            ImplicitLinkedHashCollectionTest.TestElement expected = expectedIter.next();
            Assertions.assertSame((Object)expected, (Object)element, (String)("Iterator value number " + (i + 1) + " was incorrect."));
            ++i;
        }
        Assertions.assertFalse((boolean)expectedIter.hasNext(), (String)("Iterator yieled " + i + " elements, but at least " + (i + 1) + " were expected."));
    }
}

