/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.availability;

import io.confluent.kafka.availability.ThreadCountersManager;
import io.confluent.kafka.availability.ThreadLocalCounters;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class ThreadCountersManagerTest {
    @BeforeAll
    public static void setup() {
        ThreadCountersManager.threadCountersManagerEnabled = true;
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testNumSuccessOps(boolean testStorageMetrics) throws InterruptedException {
        Thread thread1 = new Thread(() -> {
            ThreadCountersManager.LocalCounters.setThreadType((ThreadLocalCounters.ThreadGroupType)ThreadLocalCounters.ThreadGroupType.REQUEST_HANDLER_THREAD);
            for (int numOps = 0; numOps < 10; ++numOps) {
                if (testStorageMetrics) {
                    ThreadCountersManager.wrapIOVoid(() -> {
                        try {
                            Thread.sleep(1L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    });
                    continue;
                }
                ThreadCountersManager.wrapEngine(() -> {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    return null;
                });
            }
        });
        thread1.start();
        thread1.join();
        Map threadLocalCountersForAllThreads = ThreadCountersManager.getThreadLocalCounterSnapshotForAllKnownThreads();
        Assertions.assertTrue((boolean)threadLocalCountersForAllThreads.containsKey(thread1));
        List counters = (List)threadLocalCountersForAllThreads.get(thread1);
        counters.forEach(counter -> {
            Assertions.assertEquals((Object)ThreadLocalCounters.ThreadGroupType.REQUEST_HANDLER_THREAD, (Object)counter.threadGroupType);
            if (testStorageMetrics && counter.metricComponentType == ThreadLocalCounters.MetricComponentType.STORAGE || !testStorageMetrics && counter.metricComponentType == ThreadLocalCounters.MetricComponentType.ENGINE) {
                Assertions.assertEquals((long)10L, (long)counter.numSuccessOps);
            } else {
                Assertions.assertEquals((long)0L, (long)counter.numSuccessOps);
            }
        });
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testNumInProgressOps(boolean testStorageMetrics) throws InterruptedException {
        ReentrantLock lock = new ReentrantLock();
        Condition condition = lock.newCondition();
        AtomicBoolean ioControl = new AtomicBoolean(false);
        Thread thread1 = testStorageMetrics ? new Thread(this.getRunnableThreadWaitingForBothExecutionAndExit(lock, condition, ioControl, ThreadLocalCounters.ThreadGroupType.REQUEST_HANDLER_THREAD)) : new Thread(this.getRunnableEngineThreadWaitingForBothExecutionAndExit(lock, condition, ioControl, ThreadLocalCounters.ThreadGroupType.REQUEST_HANDLER_THREAD));
        thread1.start();
        TestUtils.waitForCondition(ioControl::get, "ioControl should be true");
        Map threadLocalCountersForAllThreads = ThreadCountersManager.getThreadLocalCounterSnapshotForAllKnownThreads();
        Assertions.assertTrue((boolean)threadLocalCountersForAllThreads.containsKey(thread1));
        List counters = (List)threadLocalCountersForAllThreads.get(thread1);
        counters.forEach(counter -> {
            Assertions.assertEquals((Object)ThreadLocalCounters.ThreadGroupType.REQUEST_HANDLER_THREAD, (Object)counter.threadGroupType);
            if (testStorageMetrics && counter.metricComponentType == ThreadLocalCounters.MetricComponentType.STORAGE || !testStorageMetrics && counter.metricComponentType == ThreadLocalCounters.MetricComponentType.ENGINE) {
                Assertions.assertEquals((long)0L, (long)counter.numSuccessOps);
                Assertions.assertEquals((long)1L, (long)counter.numInProgressOps);
            } else {
                Assertions.assertEquals((long)0L, (long)counter.numSuccessOps);
                Assertions.assertEquals((long)0L, (long)counter.numInProgressOps);
            }
        });
        lock.lock();
        condition.signal();
        ioControl.set(false);
        lock.unlock();
        thread1.join();
        threadLocalCountersForAllThreads = ThreadCountersManager.getThreadLocalCounterSnapshotForAllKnownThreads();
        counters = (List)threadLocalCountersForAllThreads.get(thread1);
        counters.forEach(counter -> {
            Assertions.assertEquals((Object)ThreadLocalCounters.ThreadGroupType.REQUEST_HANDLER_THREAD, (Object)counter.threadGroupType);
            if (testStorageMetrics && counter.metricComponentType == ThreadLocalCounters.MetricComponentType.STORAGE || !testStorageMetrics && counter.metricComponentType == ThreadLocalCounters.MetricComponentType.ENGINE) {
                Assertions.assertEquals((long)10L, (long)counter.numSuccessOps);
            } else {
                Assertions.assertEquals((long)0L, (long)counter.numSuccessOps);
            }
            Assertions.assertEquals((long)0L, (long)counter.numInProgressOps);
        });
    }

    private Runnable getRunnableThreadWaitingForBothExecutionAndExit(Lock lock, Condition condition, AtomicBoolean enteredIOWrapper, ThreadLocalCounters.ThreadGroupType type) {
        return () -> {
            ThreadCountersManager.LocalCounters.setThreadType((ThreadLocalCounters.ThreadGroupType)type);
            int numIO = 0;
            while (numIO < 10) {
                int finalNumIO = numIO++;
                ThreadCountersManager.wrapIO(() -> {
                    enteredIOWrapper.set(true);
                    if (finalNumIO == 0) {
                        lock.lock();
                        try {
                            while (enteredIOWrapper.get()) {
                                condition.await();
                            }
                            Thread.sleep(1L);
                        }
                        catch (InterruptedException interruptedException) {
                        }
                        finally {
                            lock.unlock();
                        }
                    }
                    return 0;
                });
            }
        };
    }

    private Runnable getRunnableEngineThreadWaitingForBothExecutionAndExit(Lock lock, Condition condition, AtomicBoolean enteredIOWrapper, ThreadLocalCounters.ThreadGroupType type) {
        return this.getRunnableEngineThreadWaitingForBothExecutionAndExit(lock, condition, enteredIOWrapper, type, 10);
    }

    private Runnable getRunnableEngineThreadWaitingForBothExecutionAndExit(Lock lock, Condition condition, AtomicBoolean enteredIOWrapper, ThreadLocalCounters.ThreadGroupType type, int expectedOps) {
        return () -> {
            ThreadCountersManager.LocalCounters.setThreadType((ThreadLocalCounters.ThreadGroupType)type);
            int numOps = 0;
            while (numOps < expectedOps) {
                int finalNumIO = numOps++;
                ThreadCountersManager.wrapEngine(() -> {
                    enteredIOWrapper.set(true);
                    if (finalNumIO == 0) {
                        lock.lock();
                        try {
                            while (enteredIOWrapper.get()) {
                                condition.await();
                            }
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        finally {
                            lock.unlock();
                        }
                    }
                    return 0;
                });
            }
        };
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testMultipleThreadsForInProgress(boolean usesSameThreadGroupType) throws InterruptedException {
        ReentrantLock lock = new ReentrantLock();
        Condition condition = lock.newCondition();
        AtomicBoolean ioControl = new AtomicBoolean(false);
        ThreadLocalCounters.ThreadGroupType engineGroupType = ThreadLocalCounters.ThreadGroupType.REQUEST_HANDLER_THREAD;
        Thread thread1 = new Thread(this.getRunnableEngineThreadWaitingForBothExecutionAndExit(lock, condition, ioControl, engineGroupType, 12));
        ReentrantLock lock2 = new ReentrantLock();
        Condition condition2 = lock2.newCondition();
        AtomicBoolean ioControl2 = new AtomicBoolean(false);
        ThreadLocalCounters.ThreadGroupType storageGroupType = usesSameThreadGroupType ? engineGroupType : ThreadLocalCounters.ThreadGroupType.BACKGROUND_THREAD;
        Thread thread2 = new Thread(this.getRunnableThreadWaitingForBothExecutionAndExit(lock2, condition2, ioControl2, storageGroupType));
        thread1.start();
        thread2.start();
        TestUtils.waitForCondition(ioControl::get, "ioControl should be true");
        TestUtils.waitForCondition(ioControl2::get, "ioControl2 should be true");
        Map threadLocalCountersForAllThreads = ThreadCountersManager.getThreadLocalCounterSnapshotForAllKnownThreads();
        List counters1 = (List)threadLocalCountersForAllThreads.get(thread1);
        counters1.forEach(counter1 -> {
            if (counter1.metricComponentType == ThreadLocalCounters.MetricComponentType.ENGINE) {
                Assertions.assertEquals((long)1L, (long)counter1.numInProgressOps);
                Assertions.assertEquals((long)0L, (long)counter1.numSuccessOps);
            }
        });
        List counters2 = (List)threadLocalCountersForAllThreads.get(thread2);
        counters2.forEach(counter2 -> {
            if (counter2.metricComponentType == ThreadLocalCounters.MetricComponentType.STORAGE) {
                Assertions.assertEquals((long)1L, (long)counter2.numInProgressOps);
                Assertions.assertEquals((long)0L, (long)counter2.numSuccessOps);
            }
        });
        lock.lock();
        condition.signal();
        ioControl.set(false);
        lock.unlock();
        lock2.lock();
        condition2.signal();
        ioControl2.set(false);
        lock2.unlock();
        thread1.join();
        thread2.join();
        threadLocalCountersForAllThreads = ThreadCountersManager.getThreadLocalCounterSnapshotForAllKnownThreads();
        counters1 = (List)threadLocalCountersForAllThreads.get(thread1);
        counters1.forEach(counter1 -> {
            if (counter1.metricComponentType == ThreadLocalCounters.MetricComponentType.ENGINE) {
                Assertions.assertEquals((long)0L, (long)counter1.numInProgressOps);
                Assertions.assertEquals((long)12L, (long)counter1.numSuccessOps);
            }
        });
        counters2 = (List)threadLocalCountersForAllThreads.get(thread2);
        counters2.forEach(counter2 -> {
            if (counter2.metricComponentType == ThreadLocalCounters.MetricComponentType.STORAGE) {
                Assertions.assertEquals((long)0L, (long)counter2.numInProgressOps);
                Assertions.assertEquals((long)10L, (long)counter2.numSuccessOps);
            }
        });
    }

    @Test
    public void testNestedInProgressIO() throws InterruptedException {
        ReentrantLock lock = new ReentrantLock();
        Condition condition = lock.newCondition();
        AtomicBoolean ioControl = new AtomicBoolean(false);
        Thread thread1 = new Thread(() -> {
            ThreadCountersManager.LocalCounters.setThreadType((ThreadLocalCounters.ThreadGroupType)ThreadLocalCounters.ThreadGroupType.NETWORK_THREAD);
            int numIO = 0;
            while (numIO < 10) {
                int finalNumIO = numIO++;
                ThreadCountersManager.wrapIOVoid(() -> ThreadCountersManager.wrapIOVoid(() -> {
                    ioControl.set(true);
                    if (finalNumIO == 0) {
                        lock.lock();
                        try {
                            while (ioControl.get()) {
                                condition.await();
                            }
                            Thread.sleep(1L);
                        }
                        catch (InterruptedException interruptedException) {
                        }
                        finally {
                            lock.unlock();
                        }
                    }
                }));
            }
        });
        thread1.start();
        TestUtils.waitForCondition(ioControl::get, "ioControl should be true");
        Map threadLocalCountersForAllThreads = ThreadCountersManager.getThreadLocalCounterSnapshotForAllKnownThreads();
        List counters = (List)threadLocalCountersForAllThreads.get(thread1);
        counters.forEach(counter -> {
            if (counter.metricComponentType == ThreadLocalCounters.MetricComponentType.STORAGE) {
                Assertions.assertEquals((long)2L, (long)counter.numInProgressOps);
                Assertions.assertEquals((long)0L, (long)counter.numSuccessOps);
            }
        });
        lock.lock();
        ioControl.set(false);
        condition.signal();
        lock.unlock();
        thread1.join();
        threadLocalCountersForAllThreads = ThreadCountersManager.getThreadLocalCounterSnapshotForAllKnownThreads();
        counters = (List)threadLocalCountersForAllThreads.get(thread1);
        counters.forEach(counter -> {
            if (counter.metricComponentType == ThreadLocalCounters.MetricComponentType.STORAGE) {
                Assertions.assertEquals((long)0L, (long)counter.numInProgressOps);
                Assertions.assertEquals((long)20L, (long)counter.numSuccessOps);
            }
        });
    }
}

