/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant;

import io.confluent.kafka.multitenant.InetAddressToTenantContext;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Optional;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class InetAddressToTenantContextTest {
    @Test
    public void testTenant() throws UnknownHostException {
        InetAddressToTenantContext inetAddressToTenantContext = new InetAddressToTenantContext(() -> true, () -> true, () -> 100000);
        InetAddress address = InetAddress.getLoopbackAddress();
        String tenantId = "lkc-abcd";
        inetAddressToTenantContext.trackTenantIdByInetAddress(address, tenantId);
        Assertions.assertEquals(Optional.of(tenantId), (Object)inetAddressToTenantContext.tenant(address));
        Assertions.assertEquals(Optional.empty(), (Object)inetAddressToTenantContext.tenant(InetAddress.getByName("127.0.0.2")));
    }

    @Test
    public void testTenantMetrics() throws UnknownHostException {
        InetAddressToTenantContext inetAddressToTenantContext = new InetAddressToTenantContext(() -> true, () -> true, () -> 100000);
        InetAddress address = InetAddress.getLoopbackAddress();
        String tenantId = "lkc-abcd";
        String secondTenantId = "lkc-xyza";
        inetAddressToTenantContext.trackTenantIdByInetAddress(address, tenantId);
        inetAddressToTenantContext.trackTenantIdByInetAddress(address, secondTenantId);
        inetAddressToTenantContext.trackTenantIdByInetAddress(InetAddress.getByName("127.0.0.2"), tenantId);
        inetAddressToTenantContext.trackTenantIdByInetAddress(InetAddress.getByName("127.0.0.3"), secondTenantId);
        Assertions.assertEquals((int)2, (int)inetAddressToTenantContext.tenantCount());
        Assertions.assertEquals((int)3, (int)inetAddressToTenantContext.tenantMappedCount());
        Assertions.assertEquals((int)1, (int)inetAddressToTenantContext.tenantRemappedCount());
    }

    @Test
    public void testApiKeyMetrics() throws UnknownHostException {
        InetAddressToTenantContext inetAddressToTenantContext = new InetAddressToTenantContext(() -> true, () -> true, () -> 100000);
        InetAddress address = InetAddress.getLoopbackAddress();
        String apiKey = "apikey";
        String secondApiKey = "apikey2";
        inetAddressToTenantContext.trackAPIKeyByInetAddress(address, apiKey);
        inetAddressToTenantContext.trackAPIKeyByInetAddress(address, secondApiKey);
        inetAddressToTenantContext.trackAPIKeyByInetAddress(InetAddress.getByName("127.0.0.2"), apiKey);
        inetAddressToTenantContext.trackAPIKeyByInetAddress(InetAddress.getByName("127.0.0.3"), secondApiKey);
        Assertions.assertEquals((int)2, (int)inetAddressToTenantContext.apiKeyCount());
        Assertions.assertEquals((int)3, (int)inetAddressToTenantContext.apiKeyMappedCount());
        Assertions.assertEquals((int)1, (int)inetAddressToTenantContext.apiKeyRemappedCount());
    }

    @Test
    public void testApiKey() throws UnknownHostException {
        InetAddressToTenantContext inetAddressToTenantContext = new InetAddressToTenantContext(() -> true, () -> true, () -> 100000);
        InetAddress address = InetAddress.getLoopbackAddress();
        String apiKey = "apiKey";
        inetAddressToTenantContext.trackAPIKeyByInetAddress(address, apiKey);
        Assertions.assertEquals(Optional.of(apiKey), (Object)inetAddressToTenantContext.apiKey(address));
        Assertions.assertEquals(Optional.empty(), (Object)inetAddressToTenantContext.apiKey(InetAddress.getByName("127.0.0.2")));
    }

    @Test
    public void testInetAddressToTenantMapExpiration() throws UnknownHostException {
        InetAddressToTenantContext inetAddressToTenantContext = new InetAddressToTenantContext(() -> true, () -> true, () -> 2);
        String tenantId = "lkc-abcd";
        String secondTenantId = "lkc-xyza";
        inetAddressToTenantContext.trackTenantIdByInetAddress(InetAddress.getByName("127.0.0.1"), tenantId);
        inetAddressToTenantContext.trackTenantIdByInetAddress(InetAddress.getByName("127.0.0.2"), secondTenantId);
        Assertions.assertEquals(Optional.of(secondTenantId), (Object)inetAddressToTenantContext.tenant(InetAddress.getByName("127.0.0.2")));
        Assertions.assertEquals(Optional.of(tenantId), (Object)inetAddressToTenantContext.tenant(InetAddress.getByName("127.0.0.1")));
        inetAddressToTenantContext.trackTenantIdByInetAddress(InetAddress.getByName("127.0.0.3"), tenantId);
        Assertions.assertEquals(Optional.empty(), (Object)inetAddressToTenantContext.tenant(InetAddress.getByName("127.0.0.2")));
        Assertions.assertEquals(Optional.of(tenantId), (Object)inetAddressToTenantContext.tenant(InetAddress.getByName("127.0.0.1")));
        Assertions.assertEquals(Optional.of(tenantId), (Object)inetAddressToTenantContext.tenant(InetAddress.getByName("127.0.0.3")));
        Assertions.assertEquals((int)1, (int)inetAddressToTenantContext.tenantCount());
        Assertions.assertEquals((int)2, (int)inetAddressToTenantContext.tenantMappedCount());
        Assertions.assertEquals((int)0, (int)inetAddressToTenantContext.tenantRemappedCount());
        inetAddressToTenantContext.trackTenantIdByInetAddress(InetAddress.getByName("127.0.0.4"), tenantId);
        Assertions.assertEquals(Optional.empty(), (Object)inetAddressToTenantContext.tenant(InetAddress.getByName("127.0.0.1")));
        Assertions.assertEquals(Optional.of(tenantId), (Object)inetAddressToTenantContext.tenant(InetAddress.getByName("127.0.0.3")));
        Assertions.assertEquals(Optional.of(tenantId), (Object)inetAddressToTenantContext.tenant(InetAddress.getByName("127.0.0.4")));
        Assertions.assertEquals((int)1, (int)inetAddressToTenantContext.tenantCount());
        Assertions.assertEquals((int)2, (int)inetAddressToTenantContext.tenantMappedCount());
        Assertions.assertEquals((int)0, (int)inetAddressToTenantContext.tenantRemappedCount());
    }

    @Test
    public void testSmallScaleTenantTest() throws UnknownHostException {
        int maxSize = 100000;
        InetAddressToTenantContext inetAddressToTenantContext = new InetAddressToTenantContext(() -> true, () -> true, () -> maxSize);
        String tenantId = "lkc-abcd";
        for (int i = 0; i <= 255; ++i) {
            for (int j = 0; j <= 255; ++j) {
                for (int k = 0; k <= 1; ++k) {
                    InetAddress address = InetAddress.getByName(String.format("127.%d.%d.%d", i, j, k));
                    inetAddressToTenantContext.trackTenantIdByInetAddress(address, tenantId);
                    Assertions.assertEquals((Object)tenantId, inetAddressToTenantContext.tenant(address).get());
                }
            }
        }
        Assertions.assertEquals((int)0, (int)inetAddressToTenantContext.apiKeyRemappedCount());
        Assertions.assertEquals((int)0, (int)inetAddressToTenantContext.apiKeyMappedCount());
        Assertions.assertEquals((int)0, (int)inetAddressToTenantContext.apiKeyCount());
        Assertions.assertEquals((int)0, (int)inetAddressToTenantContext.tenantRemappedCount());
        Assertions.assertEquals((int)maxSize, (int)inetAddressToTenantContext.tenantMappedCount());
        Assertions.assertEquals((int)1, (int)inetAddressToTenantContext.tenantCount());
    }

    @Test
    public void testSmallScaleApiKeyTest() throws UnknownHostException {
        int maxSize = 100000;
        InetAddressToTenantContext inetAddressToTenantContext = new InetAddressToTenantContext(() -> true, () -> true, () -> maxSize);
        for (int i = 0; i <= 255; ++i) {
            for (int j = 0; j <= 255; ++j) {
                for (int k = 0; k <= 1; ++k) {
                    InetAddress address = InetAddress.getByName(String.format("127.%d.%d.%d", i, j, k));
                    String apiKey = "apiKey" + String.format("%d.%d.%d", i, j, k);
                    inetAddressToTenantContext.trackAPIKeyByInetAddress(address, apiKey);
                    Assertions.assertEquals((Object)apiKey, inetAddressToTenantContext.apiKey(address).get());
                }
            }
        }
        Assertions.assertEquals((int)0, (int)inetAddressToTenantContext.apiKeyRemappedCount());
        Assertions.assertEquals((int)maxSize, (int)inetAddressToTenantContext.apiKeyMappedCount());
        Assertions.assertEquals((int)maxSize, (int)inetAddressToTenantContext.apiKeyCount());
        Assertions.assertEquals((int)0, (int)inetAddressToTenantContext.tenantRemappedCount());
        Assertions.assertEquals((int)0, (int)inetAddressToTenantContext.tenantMappedCount());
        Assertions.assertEquals((int)0, (int)inetAddressToTenantContext.tenantCount());
    }
}

