/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.util;

import io.confluent.kafka.util.OpenTelemetryManager;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.api.trace.SpanId;
import io.opentelemetry.api.trace.TraceFlags;
import io.opentelemetry.api.trace.TraceId;
import io.opentelemetry.api.trace.TraceState;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import org.apache.kafka.common.message.RequestHeaderData;
import org.apache.kafka.common.requests.RequestHeader;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class OpenTelemetryManagerTest {
    @Test
    public void testExtractAndInjectRequestHeader() {
        byte[] validTraceId = new byte[TraceId.getLength() / 2];
        validTraceId[0] = 1;
        byte[] validSpanId = new byte[SpanId.getLength() / 2];
        validSpanId[0] = 1;
        byte traceFlagByte = 1;
        Context rootCtx = Context.root();
        SpanContext spCtx = SpanContext.createFromRemoteParent((String)TraceId.fromBytes((byte[])validTraceId), (String)SpanId.fromBytes((byte[])validSpanId), (TraceFlags)TraceFlags.fromByte((byte)traceFlagByte), (TraceState)TraceState.getDefault());
        Span sp = Span.wrap((SpanContext)spCtx);
        Context ctxWithValidSpan = rootCtx.with((ImplicitContextKeyed)sp);
        RequestHeader validRh = new RequestHeader(new RequestHeaderData(), 0);
        OpenTelemetryManager.injectContext((Context)ctxWithValidSpan, (RequestHeader)validRh);
        RequestHeaderData.TraceContext expectTc = new RequestHeaderData.TraceContext().setTraceId(validTraceId).setParentSpanId(validSpanId).setTraceFlags(traceFlagByte);
        Assertions.assertEquals((Object)expectTc, (Object)validRh.traceContext());
        Context ctx = OpenTelemetryManager.extractContext((RequestHeader)validRh);
        SpanContext extractedSpCtx = Span.fromContext((Context)ctx).getSpanContext();
        Assertions.assertEquals((Object)spCtx, (Object)extractedSpCtx);
        RequestHeader invalidRh = new RequestHeader(new RequestHeaderData(), 0);
        OpenTelemetryManager.injectContext((Context)rootCtx, (RequestHeader)invalidRh);
        Assertions.assertEquals((Object)new RequestHeaderData.TraceContext(), (Object)invalidRh.traceContext());
        ctx = OpenTelemetryManager.extractContext((RequestHeader)invalidRh);
        extractedSpCtx = Span.fromContext((Context)ctx).getSpanContext();
        Assertions.assertEquals((Object)SpanContext.getInvalid(), (Object)extractedSpCtx);
        Context ctxWithInValidSpan = rootCtx.with((ImplicitContextKeyed)Span.wrap((SpanContext)SpanContext.getInvalid()));
        invalidRh = new RequestHeader(new RequestHeaderData(), 0);
        OpenTelemetryManager.injectContext((Context)ctxWithInValidSpan, (RequestHeader)invalidRh);
        Assertions.assertEquals((Object)new RequestHeaderData.TraceContext(), (Object)invalidRh.traceContext());
        ctx = OpenTelemetryManager.extractContext((RequestHeader)invalidRh);
        extractedSpCtx = Span.fromContext((Context)ctx).getSpanContext();
        Assertions.assertEquals((Object)SpanContext.getInvalid(), (Object)extractedSpCtx);
    }

    @Test
    public void testIsValidRequestHeaderData() {
        RequestHeaderData.TraceContext tc = new RequestHeaderData.TraceContext();
        byte[] validTraceIdBytes = new byte[TraceId.getLength() / 2];
        validTraceIdBytes[0] = 1;
        byte[] validSpanIdBytes = new byte[SpanId.getLength() / 2];
        validSpanIdBytes[0] = 1;
        byte[] invalidTraceIdBytes = new byte[TraceId.getLength() / 2];
        byte[] invalidSpanIdBytes = new byte[SpanId.getLength() / 2];
        tc.setTraceId(validTraceIdBytes).setParentSpanId(validSpanIdBytes);
        Assertions.assertTrue((boolean)OpenTelemetryManager.isValid((RequestHeaderData.TraceContext)tc));
        tc.setTraceId(validTraceIdBytes).setParentSpanId(invalidSpanIdBytes);
        Assertions.assertFalse((boolean)OpenTelemetryManager.isValid((RequestHeaderData.TraceContext)tc));
        tc.setTraceId(invalidTraceIdBytes).setParentSpanId(validSpanIdBytes);
        Assertions.assertFalse((boolean)OpenTelemetryManager.isValid((RequestHeaderData.TraceContext)tc));
        tc.setTraceId(invalidTraceIdBytes).setParentSpanId(invalidSpanIdBytes);
        Assertions.assertFalse((boolean)OpenTelemetryManager.isValid((RequestHeaderData.TraceContext)tc));
    }
}

