/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.kafka.clients.HostResolver;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AdminClientConfig;
import org.apache.kafka.clients.admin.AlterConfigsResult;
import org.apache.kafka.clients.admin.BrokerComponent;
import org.apache.kafka.clients.admin.BrokerHealthStatusResult;
import org.apache.kafka.clients.admin.ClientMetricsResourceListing;
import org.apache.kafka.clients.admin.ComponentHealthStatus;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.CreatePartitionsResult;
import org.apache.kafka.clients.admin.CreateTopicsResult;
import org.apache.kafka.clients.admin.DeleteTopicsResult;
import org.apache.kafka.clients.admin.DescribeConfigsResult;
import org.apache.kafka.clients.admin.DescribeTopicsResult;
import org.apache.kafka.clients.admin.GroupListing;
import org.apache.kafka.clients.admin.KafkaAdminClient;
import org.apache.kafka.clients.admin.ListClientMetricsResourcesResult;
import org.apache.kafka.clients.admin.ListConsumerGroupOffsetsResult;
import org.apache.kafka.clients.admin.ListGroupsResult;
import org.apache.kafka.clients.admin.ListPartitionReassignmentsResult;
import org.apache.kafka.clients.admin.ListTopicsResult;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.clients.admin.TopicListing;
import org.apache.kafka.clients.admin.internals.CoordinatorKey;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicType;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.internals.KafkaFutureImpl;

public class AdminClientTestUtils {
    public static ListPartitionReassignmentsResult listPartitionReassignmentsResult(Throwable t) {
        KafkaFutureImpl future = new KafkaFutureImpl();
        future.completeExceptionally(t);
        return new ListPartitionReassignmentsResult((KafkaFuture)future);
    }

    public static CreateTopicsResult createTopicsResult(String topic, Throwable t) {
        KafkaFutureImpl future = new KafkaFutureImpl();
        future.completeExceptionally(t);
        return new CreateTopicsResult(Collections.singletonMap(topic, future));
    }

    public static DeleteTopicsResult deleteTopicsResult(String topic, Throwable t) {
        KafkaFutureImpl future = new KafkaFutureImpl();
        future.completeExceptionally(t);
        return DeleteTopicsResult.ofTopicNames(Collections.singletonMap(topic, future));
    }

    public static ListTopicsResult listTopicsResult(String topic) {
        KafkaFutureImpl future = new KafkaFutureImpl();
        future.complete(Collections.singletonMap(topic, new TopicListing(topic, Uuid.ZERO_UUID, false, TopicType.STANDARD)));
        return new ListTopicsResult((KafkaFuture)future);
    }

    public static AlterConfigsResult alterConfigsResult(ConfigResource cr, Throwable t) {
        KafkaFutureImpl future = new KafkaFutureImpl();
        Map<ConfigResource, KafkaFutureImpl> futures = Collections.singletonMap(cr, future);
        future.completeExceptionally(t);
        return new AlterConfigsResult(futures);
    }

    public static AlterConfigsResult alterConfigsResult(ConfigResource cr) {
        KafkaFutureImpl future = new KafkaFutureImpl();
        Map<ConfigResource, KafkaFutureImpl> futures = Collections.singletonMap(cr, future);
        future.complete(null);
        return new AlterConfigsResult(futures);
    }

    public static DescribeConfigsResult describeConfigsResult(ConfigResource cr, Config config) {
        KafkaFutureImpl future = new KafkaFutureImpl();
        future.complete((Object)config);
        return new DescribeConfigsResult(Collections.singletonMap(cr, future));
    }

    public static CreatePartitionsResult createPartitionsResult(String topic, Throwable t) {
        KafkaFutureImpl future = new KafkaFutureImpl();
        future.completeExceptionally(t);
        return new CreatePartitionsResult(Collections.singletonMap(topic, future));
    }

    public static DescribeTopicsResult describeTopicsResult(String topic, TopicDescription description) {
        KafkaFutureImpl future = new KafkaFutureImpl();
        future.complete((Object)description);
        return DescribeTopicsResult.ofTopicNames(Collections.singletonMap(topic, future));
    }

    public static DescribeTopicsResult describeTopicsResult(Map<String, TopicDescription> topicDescriptions) {
        return DescribeTopicsResult.ofTopicNames(topicDescriptions.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> KafkaFuture.completedFuture((Object)((TopicDescription)e.getValue())))));
    }

    public static DescribeTopicsResult describeTopicsResultWithException(String topic, Throwable e) {
        KafkaFutureImpl future = new KafkaFutureImpl();
        future.completeExceptionally(e);
        return DescribeTopicsResult.ofTopicNames(Collections.singletonMap(topic, future));
    }

    public static ListGroupsResult listGroupsResult(GroupListing ... groups) {
        return new ListGroupsResult(KafkaFuture.completedFuture((Object)Arrays.stream(groups).collect(Collectors.toList())));
    }

    public static ListGroupsResult listGroupsResult(KafkaException exception) {
        return new ListGroupsResult(KafkaFuture.completedFuture(Collections.singleton(exception)));
    }

    public static ListConsumerGroupOffsetsResult listConsumerGroupOffsetsResult(Map<String, Map<TopicPartition, OffsetAndMetadata>> offsets) {
        Map<CoordinatorKey, KafkaFuture> resultMap = offsets.entrySet().stream().collect(Collectors.toMap(e -> CoordinatorKey.byGroupId((String)((String)e.getKey())), e -> KafkaFutureImpl.completedFuture((Object)((Map)e.getValue()))));
        return new ListConsumerGroupOffsetsResult(resultMap);
    }

    public static ListConsumerGroupOffsetsResult listConsumerGroupOffsetsResult(String group, KafkaException exception) {
        KafkaFutureImpl future = new KafkaFutureImpl();
        future.completeExceptionally((Throwable)exception);
        return new ListConsumerGroupOffsetsResult(Collections.singletonMap(CoordinatorKey.byGroupId((String)group), future));
    }

    public static ListClientMetricsResourcesResult listClientMetricsResourcesResult(String ... names) {
        return new ListClientMetricsResourcesResult(KafkaFuture.completedFuture((Object)Arrays.stream(names).map(ClientMetricsResourceListing::new).collect(Collectors.toList())));
    }

    public static ListClientMetricsResourcesResult listClientMetricsResourcesResult(KafkaException exception) {
        KafkaFutureImpl future = new KafkaFutureImpl();
        future.completeExceptionally((Throwable)exception);
        return new ListClientMetricsResourcesResult((KafkaFuture)future);
    }

    public static BrokerHealthStatusResult brokerHealthStatusResult(Integer brokerId, BrokerComponent brokerComponent, ComponentHealthStatus componentHealthStatus) {
        return new BrokerHealthStatusResult(brokerId.intValue(), brokerComponent, componentHealthStatus);
    }

    public static Admin create(Map<String, Object> conf, HostResolver hostResolver) {
        return KafkaAdminClient.createInternal((AdminClientConfig)new AdminClientConfig(conf, true), null, (HostResolver)hostResolver);
    }
}

